/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecord;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai.org.apache.poi.util.StringUtil;

public final class StringRecord
extends ContinuableRecord {
    public static final short sid = 519;
    private boolean _is16bitUnicode;
    private String _text;

    public StringRecord() {
    }

    public StringRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readUShort();
        this._is16bitUnicode = recordInputStream.readByte() != 0;
        this._text = this._is16bitUnicode ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
    }

    protected void serialize(ContinuableRecordOutput continuableRecordOutput) {
        continuableRecordOutput.writeShort(this._text.length());
        continuableRecordOutput.writeStringData(this._text);
    }

    public short getSid() {
        return 519;
    }

    public String getString() {
        return this._text;
    }

    public void setString(String string) {
        this._text = string;
        this._is16bitUnicode = StringUtil.hasMultibyte(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[STRING]\n");
        stringBuffer.append("    .string            = ").append(this._text).append("\n");
        stringBuffer.append("[/STRING]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        StringRecord stringRecord = new StringRecord();
        stringRecord._is16bitUnicode = this._is16bitUnicode;
        stringRecord._text = this._text;
        return stringRecord;
    }
}

