/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.common.UnicodeString;
import ai.org.apache.poi.util.IntMapper;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SSTDeserializer {
    private static POILogger logger = POILogFactory.getLogger(SSTDeserializer.class);
    private IntMapper<UnicodeString> strings;

    public SSTDeserializer(IntMapper<UnicodeString> intMapper) {
        this.strings = intMapper;
    }

    public void manufactureStrings(int n, RecordInputStream recordInputStream) {
        for (int i = 0; i < n; ++i) {
            UnicodeString unicodeString;
            if (recordInputStream.available() == 0 && !recordInputStream.hasNextRecord()) {
                logger.log(7, "Ran out of data before creating all the strings! String at index " + i + "");
                unicodeString = new UnicodeString("");
            } else {
                unicodeString = new UnicodeString(recordInputStream);
            }
            SSTDeserializer.addToStringTable(this.strings, unicodeString);
        }
    }

    public static void addToStringTable(IntMapper<UnicodeString> intMapper, UnicodeString unicodeString) {
        intMapper.add(unicodeString);
    }
}

