/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class RefreshAllRecord
extends StandardRecord {
    public static final short sid = 439;
    private static final BitField refreshFlag = BitFieldFactory.getInstance(1);
    private int _options;

    private RefreshAllRecord(int n) {
        this._options = n;
    }

    public RefreshAllRecord(RecordInputStream recordInputStream) {
        this(recordInputStream.readUShort());
    }

    public RefreshAllRecord(boolean bl) {
        this(0);
        this.setRefreshAll(bl);
    }

    public void setRefreshAll(boolean bl) {
        this._options = refreshFlag.setBoolean(this._options, bl);
    }

    public boolean getRefreshAll() {
        return refreshFlag.isSet(this._options);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[REFRESHALL]\n");
        stringBuffer.append("    .options      = ").append(HexDump.shortToHex(this._options)).append("\n");
        stringBuffer.append("[/REFRESHALL]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._options);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 439;
    }

    public Object clone() {
        return new RefreshAllRecord(this._options);
    }
}

