/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.hssf.record.ArrayRecord;
import ai.org.apache.poi.hssf.record.AutoFilterInfoRecord;
import ai.org.apache.poi.hssf.record.BOFRecord;
import ai.org.apache.poi.hssf.record.BackupRecord;
import ai.org.apache.poi.hssf.record.BlankRecord;
import ai.org.apache.poi.hssf.record.BookBoolRecord;
import ai.org.apache.poi.hssf.record.BoolErrRecord;
import ai.org.apache.poi.hssf.record.BottomMarginRecord;
import ai.org.apache.poi.hssf.record.BoundSheetRecord;
import ai.org.apache.poi.hssf.record.CFHeaderRecord;
import ai.org.apache.poi.hssf.record.CFRuleRecord;
import ai.org.apache.poi.hssf.record.CRNCountRecord;
import ai.org.apache.poi.hssf.record.CRNRecord;
import ai.org.apache.poi.hssf.record.CalcCountRecord;
import ai.org.apache.poi.hssf.record.CalcModeRecord;
import ai.org.apache.poi.hssf.record.CodepageRecord;
import ai.org.apache.poi.hssf.record.ColumnInfoRecord;
import ai.org.apache.poi.hssf.record.ContinueRecord;
import ai.org.apache.poi.hssf.record.CountryRecord;
import ai.org.apache.poi.hssf.record.DBCellRecord;
import ai.org.apache.poi.hssf.record.DConRefRecord;
import ai.org.apache.poi.hssf.record.DSFRecord;
import ai.org.apache.poi.hssf.record.DVALRecord;
import ai.org.apache.poi.hssf.record.DVRecord;
import ai.org.apache.poi.hssf.record.DateWindow1904Record;
import ai.org.apache.poi.hssf.record.DefaultColWidthRecord;
import ai.org.apache.poi.hssf.record.DefaultRowHeightRecord;
import ai.org.apache.poi.hssf.record.DeltaRecord;
import ai.org.apache.poi.hssf.record.DimensionsRecord;
import ai.org.apache.poi.hssf.record.DrawingGroupRecord;
import ai.org.apache.poi.hssf.record.DrawingRecord;
import ai.org.apache.poi.hssf.record.DrawingSelectionRecord;
import ai.org.apache.poi.hssf.record.EOFRecord;
import ai.org.apache.poi.hssf.record.ExtSSTRecord;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.ExternSheetRecord;
import ai.org.apache.poi.hssf.record.ExternalNameRecord;
import ai.org.apache.poi.hssf.record.FeatHdrRecord;
import ai.org.apache.poi.hssf.record.FeatRecord;
import ai.org.apache.poi.hssf.record.FilePassRecord;
import ai.org.apache.poi.hssf.record.FileSharingRecord;
import ai.org.apache.poi.hssf.record.FnGroupCountRecord;
import ai.org.apache.poi.hssf.record.FontRecord;
import ai.org.apache.poi.hssf.record.FooterRecord;
import ai.org.apache.poi.hssf.record.FormatRecord;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.GridsetRecord;
import ai.org.apache.poi.hssf.record.GutsRecord;
import ai.org.apache.poi.hssf.record.HCenterRecord;
import ai.org.apache.poi.hssf.record.HeaderFooterRecord;
import ai.org.apache.poi.hssf.record.HeaderRecord;
import ai.org.apache.poi.hssf.record.HideObjRecord;
import ai.org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import ai.org.apache.poi.hssf.record.HyperlinkRecord;
import ai.org.apache.poi.hssf.record.IndexRecord;
import ai.org.apache.poi.hssf.record.InterfaceEndRecord;
import ai.org.apache.poi.hssf.record.InterfaceHdrRecord;
import ai.org.apache.poi.hssf.record.IterationRecord;
import ai.org.apache.poi.hssf.record.LabelRecord;
import ai.org.apache.poi.hssf.record.LabelSSTRecord;
import ai.org.apache.poi.hssf.record.LeftMarginRecord;
import ai.org.apache.poi.hssf.record.MMSRecord;
import ai.org.apache.poi.hssf.record.MergeCellsRecord;
import ai.org.apache.poi.hssf.record.MulBlankRecord;
import ai.org.apache.poi.hssf.record.MulRKRecord;
import ai.org.apache.poi.hssf.record.NameCommentRecord;
import ai.org.apache.poi.hssf.record.NameRecord;
import ai.org.apache.poi.hssf.record.NoteRecord;
import ai.org.apache.poi.hssf.record.NumberRecord;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.record.ObjectProtectRecord;
import ai.org.apache.poi.hssf.record.PaletteRecord;
import ai.org.apache.poi.hssf.record.PaneRecord;
import ai.org.apache.poi.hssf.record.PasswordRecord;
import ai.org.apache.poi.hssf.record.PasswordRev4Record;
import ai.org.apache.poi.hssf.record.PrecisionRecord;
import ai.org.apache.poi.hssf.record.PrintGridlinesRecord;
import ai.org.apache.poi.hssf.record.PrintHeadersRecord;
import ai.org.apache.poi.hssf.record.PrintSetupRecord;
import ai.org.apache.poi.hssf.record.ProtectRecord;
import ai.org.apache.poi.hssf.record.ProtectionRev4Record;
import ai.org.apache.poi.hssf.record.RKRecord;
import ai.org.apache.poi.hssf.record.RecalcIdRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordFactoryInputStream;
import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.RefModeRecord;
import ai.org.apache.poi.hssf.record.RefreshAllRecord;
import ai.org.apache.poi.hssf.record.RightMarginRecord;
import ai.org.apache.poi.hssf.record.RowRecord;
import ai.org.apache.poi.hssf.record.SSTRecord;
import ai.org.apache.poi.hssf.record.SaveRecalcRecord;
import ai.org.apache.poi.hssf.record.ScenarioProtectRecord;
import ai.org.apache.poi.hssf.record.SelectionRecord;
import ai.org.apache.poi.hssf.record.SharedFormulaRecord;
import ai.org.apache.poi.hssf.record.StringRecord;
import ai.org.apache.poi.hssf.record.StyleRecord;
import ai.org.apache.poi.hssf.record.SupBookRecord;
import ai.org.apache.poi.hssf.record.TabIdRecord;
import ai.org.apache.poi.hssf.record.TableRecord;
import ai.org.apache.poi.hssf.record.TableStylesRecord;
import ai.org.apache.poi.hssf.record.TextObjectRecord;
import ai.org.apache.poi.hssf.record.TopMarginRecord;
import ai.org.apache.poi.hssf.record.UncalcedRecord;
import ai.org.apache.poi.hssf.record.UnknownRecord;
import ai.org.apache.poi.hssf.record.UseSelFSRecord;
import ai.org.apache.poi.hssf.record.UserSViewBegin;
import ai.org.apache.poi.hssf.record.UserSViewEnd;
import ai.org.apache.poi.hssf.record.VCenterRecord;
import ai.org.apache.poi.hssf.record.VerticalPageBreakRecord;
import ai.org.apache.poi.hssf.record.WSBoolRecord;
import ai.org.apache.poi.hssf.record.WindowOneRecord;
import ai.org.apache.poi.hssf.record.WindowProtectRecord;
import ai.org.apache.poi.hssf.record.WindowTwoRecord;
import ai.org.apache.poi.hssf.record.WriteAccessRecord;
import ai.org.apache.poi.hssf.record.WriteProtectRecord;
import ai.org.apache.poi.hssf.record.chart.BeginRecord;
import ai.org.apache.poi.hssf.record.chart.CatLabRecord;
import ai.org.apache.poi.hssf.record.chart.ChartEndBlockRecord;
import ai.org.apache.poi.hssf.record.chart.ChartEndObjectRecord;
import ai.org.apache.poi.hssf.record.chart.ChartFRTInfoRecord;
import ai.org.apache.poi.hssf.record.chart.ChartRecord;
import ai.org.apache.poi.hssf.record.chart.ChartStartBlockRecord;
import ai.org.apache.poi.hssf.record.chart.ChartStartObjectRecord;
import ai.org.apache.poi.hssf.record.chart.ChartTitleFormatRecord;
import ai.org.apache.poi.hssf.record.chart.DataFormatRecord;
import ai.org.apache.poi.hssf.record.chart.EndRecord;
import ai.org.apache.poi.hssf.record.chart.LegendRecord;
import ai.org.apache.poi.hssf.record.chart.LinkedDataRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesTextRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesToChartGroupRecord;
import ai.org.apache.poi.hssf.record.chart.ValueRangeRecord;
import ai.org.apache.poi.hssf.record.pivottable.DataItemRecord;
import ai.org.apache.poi.hssf.record.pivottable.ExtendedPivotTableViewFieldsRecord;
import ai.org.apache.poi.hssf.record.pivottable.PageItemRecord;
import ai.org.apache.poi.hssf.record.pivottable.StreamIDRecord;
import ai.org.apache.poi.hssf.record.pivottable.ViewDefinitionRecord;
import ai.org.apache.poi.hssf.record.pivottable.ViewFieldsRecord;
import ai.org.apache.poi.hssf.record.pivottable.ViewSourceRecord;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordFactory {
    private static final int NUM_RECORDS = 512;
    private static final Class<?>[] CONSTRUCTOR_ARGS = new Class[]{RecordInputStream.class};
    private static final Class<? extends Record>[] recordClasses = new Class[]{ArrayRecord.class, AutoFilterInfoRecord.class, BackupRecord.class, BlankRecord.class, BOFRecord.class, BookBoolRecord.class, BoolErrRecord.class, BottomMarginRecord.class, BoundSheetRecord.class, CalcCountRecord.class, CalcModeRecord.class, CFHeaderRecord.class, CFRuleRecord.class, ChartRecord.class, ChartTitleFormatRecord.class, CodepageRecord.class, ColumnInfoRecord.class, ContinueRecord.class, CountryRecord.class, CRNCountRecord.class, CRNRecord.class, DateWindow1904Record.class, DBCellRecord.class, DConRefRecord.class, DefaultColWidthRecord.class, DefaultRowHeightRecord.class, DeltaRecord.class, DimensionsRecord.class, DrawingGroupRecord.class, DrawingRecord.class, DrawingSelectionRecord.class, DSFRecord.class, DVALRecord.class, DVRecord.class, EOFRecord.class, ExtendedFormatRecord.class, ExternalNameRecord.class, ExternSheetRecord.class, ExtSSTRecord.class, FeatRecord.class, FeatHdrRecord.class, FilePassRecord.class, FileSharingRecord.class, FnGroupCountRecord.class, FontRecord.class, FooterRecord.class, FormatRecord.class, FormulaRecord.class, GridsetRecord.class, GutsRecord.class, HCenterRecord.class, HeaderRecord.class, HeaderFooterRecord.class, HideObjRecord.class, HorizontalPageBreakRecord.class, HyperlinkRecord.class, IndexRecord.class, InterfaceEndRecord.class, InterfaceHdrRecord.class, IterationRecord.class, LabelRecord.class, LabelSSTRecord.class, LeftMarginRecord.class, LegendRecord.class, MergeCellsRecord.class, MMSRecord.class, MulBlankRecord.class, MulRKRecord.class, NameRecord.class, NameCommentRecord.class, NoteRecord.class, NumberRecord.class, ObjectProtectRecord.class, ObjRecord.class, PaletteRecord.class, PaneRecord.class, PasswordRecord.class, PasswordRev4Record.class, PrecisionRecord.class, PrintGridlinesRecord.class, PrintHeadersRecord.class, PrintSetupRecord.class, ProtectionRev4Record.class, ProtectRecord.class, RecalcIdRecord.class, RefModeRecord.class, RefreshAllRecord.class, RightMarginRecord.class, RKRecord.class, RowRecord.class, SaveRecalcRecord.class, ScenarioProtectRecord.class, SelectionRecord.class, SeriesRecord.class, SeriesTextRecord.class, SharedFormulaRecord.class, SSTRecord.class, StringRecord.class, StyleRecord.class, SupBookRecord.class, TabIdRecord.class, TableRecord.class, TableStylesRecord.class, TextObjectRecord.class, TopMarginRecord.class, UncalcedRecord.class, UseSelFSRecord.class, UserSViewBegin.class, UserSViewEnd.class, ValueRangeRecord.class, VCenterRecord.class, VerticalPageBreakRecord.class, WindowOneRecord.class, WindowProtectRecord.class, WindowTwoRecord.class, WriteAccessRecord.class, WriteProtectRecord.class, WSBoolRecord.class, BeginRecord.class, ChartFRTInfoRecord.class, ChartStartBlockRecord.class, ChartEndBlockRecord.class, ChartStartObjectRecord.class, ChartEndObjectRecord.class, CatLabRecord.class, DataFormatRecord.class, EndRecord.class, LinkedDataRecord.class, SeriesToChartGroupRecord.class, DataItemRecord.class, ExtendedPivotTableViewFieldsRecord.class, PageItemRecord.class, StreamIDRecord.class, ViewDefinitionRecord.class, ViewFieldsRecord.class, ViewSourceRecord.class};
    private static final Map<Integer, I_RecordCreator> _recordCreatorsById = RecordFactory.recordsToMap(recordClasses);
    private static short[] _allKnownRecordSIDs;

    public static Class<? extends Record> getRecordClass(int n) {
        I_RecordCreator i_RecordCreator = _recordCreatorsById.get(n);
        if (i_RecordCreator == null) {
            return null;
        }
        return i_RecordCreator.getRecordClass();
    }

    public static Record[] createRecord(RecordInputStream recordInputStream) {
        Record record = RecordFactory.createSingleRecord(recordInputStream);
        if (record instanceof DBCellRecord) {
            return new Record[]{null};
        }
        if (record instanceof RKRecord) {
            return new Record[]{RecordFactory.convertToNumberRecord((RKRecord)record)};
        }
        if (record instanceof MulRKRecord) {
            return RecordFactory.convertRKRecords((MulRKRecord)record);
        }
        return new Record[]{record};
    }

    public static Record createSingleRecord(RecordInputStream recordInputStream) {
        I_RecordCreator i_RecordCreator = _recordCreatorsById.get(recordInputStream.getSid());
        if (i_RecordCreator == null) {
            return new UnknownRecord(recordInputStream);
        }
        return i_RecordCreator.create(recordInputStream);
    }

    public static NumberRecord convertToNumberRecord(RKRecord rKRecord) {
        NumberRecord numberRecord = new NumberRecord();
        numberRecord.setColumn(rKRecord.getColumn());
        numberRecord.setRow(rKRecord.getRow());
        numberRecord.setXFIndex(rKRecord.getXFIndex());
        numberRecord.setValue(rKRecord.getRKNumber());
        return numberRecord;
    }

    public static NumberRecord[] convertRKRecords(MulRKRecord mulRKRecord) {
        NumberRecord[] numberRecordArray = new NumberRecord[mulRKRecord.getNumColumns()];
        for (int i = 0; i < mulRKRecord.getNumColumns(); ++i) {
            NumberRecord numberRecord = new NumberRecord();
            numberRecord.setColumn((short)(i + mulRKRecord.getFirstColumn()));
            numberRecord.setRow(mulRKRecord.getRow());
            numberRecord.setXFIndex(mulRKRecord.getXFAt(i));
            numberRecord.setValue(mulRKRecord.getRKNumberAt(i));
            numberRecordArray[i] = numberRecord;
        }
        return numberRecordArray;
    }

    public static BlankRecord[] convertBlankRecords(MulBlankRecord mulBlankRecord) {
        BlankRecord[] blankRecordArray = new BlankRecord[mulBlankRecord.getNumColumns()];
        for (int i = 0; i < mulBlankRecord.getNumColumns(); ++i) {
            BlankRecord blankRecord = new BlankRecord();
            blankRecord.setColumn((short)(i + mulBlankRecord.getFirstColumn()));
            blankRecord.setRow(mulBlankRecord.getRow());
            blankRecord.setXFIndex(mulBlankRecord.getXFAt(i));
            blankRecordArray[i] = blankRecord;
        }
        return blankRecordArray;
    }

    public static short[] getAllKnownRecordSIDs() {
        if (_allKnownRecordSIDs == null) {
            short[] sArray = new short[_recordCreatorsById.size()];
            int n = 0;
            for (Integer n2 : _recordCreatorsById.keySet()) {
                sArray[n++] = n2.shortValue();
            }
            Arrays.sort(sArray);
            _allKnownRecordSIDs = sArray;
        }
        return (short[])_allKnownRecordSIDs.clone();
    }

    private static Map<Integer, I_RecordCreator> recordsToMap(Class<? extends Record>[] classArray) {
        HashMap<Integer, I_RecordCreator> hashMap = new HashMap<Integer, I_RecordCreator>();
        HashSet<Class<? extends Record>> hashSet = new HashSet<Class<? extends Record>>(classArray.length * 3 / 2);
        for (int i = 0; i < classArray.length; ++i) {
            short s;
            Class<? extends Record> clazz = classArray[i];
            if (!Record.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("Invalid record sub-class (" + clazz.getName() + ")");
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new RuntimeException("Invalid record class (" + clazz.getName() + ") - must not be abstract");
            }
            if (!hashSet.add(clazz)) {
                throw new RuntimeException("duplicate record class (" + clazz.getName() + ")");
            }
            try {
                s = clazz.getField("sid").getShort(null);
            }
            catch (Exception exception) {
                throw new RecordFormatException("Unable to determine record types");
            }
            Integer n = s;
            if (hashMap.containsKey(n)) {
                Class<? extends Record> clazz2 = ((I_RecordCreator)hashMap.get(n)).getRecordClass();
                throw new RuntimeException("duplicate record sid 0x" + Integer.toHexString(s).toUpperCase() + " for classes (" + clazz.getName() + ") and (" + clazz2.getName() + ")");
            }
            hashMap.put(n, RecordFactory.getRecordCreator(clazz));
        }
        return hashMap;
    }

    private static I_RecordCreator getRecordCreator(Class<? extends Record> clazz) {
        try {
            Constructor<? extends Record> constructor = clazz.getConstructor(CONSTRUCTOR_ARGS);
            return new ReflectionConstructorRecordCreator(constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = clazz.getDeclaredMethod("create", CONSTRUCTOR_ARGS);
                return new ReflectionMethodRecordCreator(method);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Failed to find constructor or create method for (" + clazz.getName() + ").");
            }
        }
    }

    public static List<Record> createRecords(InputStream inputStream) throws RecordFormatException {
        Record record;
        ArrayList<Record> arrayList = new ArrayList<Record>(512);
        RecordFactoryInputStream recordFactoryInputStream = new RecordFactoryInputStream(inputStream, true);
        while ((record = recordFactoryInputStream.nextRecord()) != null) {
            arrayList.add(record);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReflectionMethodRecordCreator
    implements I_RecordCreator {
        private final Method _m;

        public ReflectionMethodRecordCreator(Method method) {
            this._m = method;
        }

        @Override
        public Record create(RecordInputStream recordInputStream) {
            Object[] objectArray = new Object[]{recordInputStream};
            try {
                return (Record)this._m.invoke(null, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RecordFormatException("Unable to construct record instance", invocationTargetException.getTargetException());
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._m.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReflectionConstructorRecordCreator
    implements I_RecordCreator {
        private final Constructor<? extends Record> _c;

        public ReflectionConstructorRecordCreator(Constructor<? extends Record> constructor) {
            this._c = constructor;
        }

        @Override
        public Record create(RecordInputStream recordInputStream) {
            Object[] objectArray = new Object[]{recordInputStream};
            try {
                return this._c.newInstance(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RecordFormatException) {
                    throw (RecordFormatException)throwable;
                }
                if (throwable instanceof EncryptedDocumentException) {
                    throw (EncryptedDocumentException)throwable;
                }
                throw new RecordFormatException("Unable to construct record instance", throwable);
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._c.getDeclaringClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface I_RecordCreator {
        public Record create(RecordInputStream var1);

        public Class<? extends Record> getRecordClass();
    }
}

