/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.CellRecord;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.util.RKUtil;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class RKRecord
extends CellRecord {
    public static final short sid = 638;
    public static final short RK_IEEE_NUMBER = 0;
    public static final short RK_IEEE_NUMBER_TIMES_100 = 1;
    public static final short RK_INTEGER = 2;
    public static final short RK_INTEGER_TIMES_100 = 3;
    private int field_4_rk_number;

    private RKRecord() {
    }

    public RKRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_4_rk_number = recordInputStream.readInt();
    }

    public double getRKNumber() {
        return RKUtil.decodeNumber(this.field_4_rk_number);
    }

    protected String getRecordName() {
        return "RK";
    }

    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("  .value= ").append(this.getRKNumber());
    }

    protected void serializeValue(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.field_4_rk_number);
    }

    protected int getValueDataSize() {
        return 4;
    }

    public short getSid() {
        return 638;
    }

    public Object clone() {
        RKRecord rKRecord = new RKRecord();
        this.copyBaseFields(rKRecord);
        rKRecord.field_4_rk_number = this.field_4_rk_number;
        return rKRecord;
    }
}

