/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.OldCellRecord;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.ss.formula.Formula;
import ai.org.apache.poi.ss.formula.ptg.Ptg;

public final class OldFormulaRecord
extends OldCellRecord {
    public static final short biff2_sid = 6;
    public static final short biff3_sid = 518;
    public static final short biff4_sid = 1030;
    public static final short biff5_sid = 6;
    private FormulaRecord.SpecialCachedValue specialCachedValue;
    private double field_4_value;
    private short field_5_options;
    private Formula field_6_parsed_expr;

    public OldFormulaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream, recordInputStream.getSid() == 6);
        if (this.isBiff2()) {
            this.field_4_value = recordInputStream.readDouble();
        } else {
            long l = recordInputStream.readLong();
            this.specialCachedValue = FormulaRecord.SpecialCachedValue.create(l);
            if (this.specialCachedValue == null) {
                this.field_4_value = Double.longBitsToDouble(l);
            }
        }
        this.field_5_options = this.isBiff2() ? (short)recordInputStream.readUByte() : recordInputStream.readShort();
        short s = recordInputStream.readShort();
        int n = recordInputStream.available();
        this.field_6_parsed_expr = Formula.read(s, recordInputStream, n);
    }

    public int getCachedResultType() {
        if (this.specialCachedValue == null) {
            return 0;
        }
        return this.specialCachedValue.getValueType();
    }

    public boolean getCachedBooleanValue() {
        return this.specialCachedValue.getBooleanValue();
    }

    public int getCachedErrorValue() {
        return this.specialCachedValue.getErrorValue();
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public Ptg[] getParsedExpression() {
        return this.field_6_parsed_expr.getTokens();
    }

    public Formula getFormula() {
        return this.field_6_parsed_expr;
    }

    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("    .value       = ").append(this.getValue()).append("\n");
    }

    protected String getRecordName() {
        return "Old Formula";
    }
}

