/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecord;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai.org.apache.poi.ss.formula.Formula;
import ai.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianByteArrayInputStream;
import ai.org.apache.poi.util.StringUtil;

public final class NameRecord
extends ContinuableRecord {
    public static final short sid = 24;
    public static final byte BUILTIN_CONSOLIDATE_AREA = 1;
    public static final byte BUILTIN_AUTO_OPEN = 2;
    public static final byte BUILTIN_AUTO_CLOSE = 3;
    public static final byte BUILTIN_DATABASE = 4;
    public static final byte BUILTIN_CRITERIA = 5;
    public static final byte BUILTIN_PRINT_AREA = 6;
    public static final byte BUILTIN_PRINT_TITLE = 7;
    public static final byte BUILTIN_RECORDER = 8;
    public static final byte BUILTIN_DATA_FORM = 9;
    public static final byte BUILTIN_AUTO_ACTIVATE = 10;
    public static final byte BUILTIN_AUTO_DEACTIVATE = 11;
    public static final byte BUILTIN_SHEET_TITLE = 12;
    public static final byte BUILTIN_FILTER_DB = 13;
    private short field_1_option_flag;
    private byte field_2_keyboard_shortcut;
    private short field_5_externSheetIndex_plus1;
    private int field_6_sheetNumber;
    private boolean field_11_nameIsMultibyte;
    private byte field_12_built_in_code;
    private String field_12_name_text;
    private Formula field_13_name_definition;
    private String field_14_custom_menu_text;
    private String field_15_description_text;
    private String field_16_help_topic_text;
    private String field_17_status_bar_text;

    public NameRecord() {
        this.field_13_name_definition = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.field_12_name_text = "";
        this.field_14_custom_menu_text = "";
        this.field_15_description_text = "";
        this.field_16_help_topic_text = "";
        this.field_17_status_bar_text = "";
    }

    public NameRecord(byte by, int n) {
        this();
        this.field_12_built_in_code = by;
        this.setOptionFlag((short)(this.field_1_option_flag | 0x20));
        this.field_6_sheetNumber = n;
    }

    public void setOptionFlag(short s) {
        this.field_1_option_flag = s;
    }

    public void setKeyboardShortcut(byte by) {
        this.field_2_keyboard_shortcut = by;
    }

    public int getSheetNumber() {
        return this.field_6_sheetNumber;
    }

    public byte getFnGroup() {
        int n = this.field_1_option_flag & 0xFC0;
        return (byte)(n >> 4);
    }

    public void setSheetNumber(int n) {
        this.field_6_sheetNumber = n;
    }

    public void setNameText(String string) {
        this.field_12_name_text = string;
        this.field_11_nameIsMultibyte = StringUtil.hasMultibyte(string);
    }

    public void setCustomMenuText(String string) {
        this.field_14_custom_menu_text = string;
    }

    public void setDescriptionText(String string) {
        this.field_15_description_text = string;
    }

    public void setHelpTopicText(String string) {
        this.field_16_help_topic_text = string;
    }

    public void setStatusBarText(String string) {
        this.field_17_status_bar_text = string;
    }

    public short getOptionFlag() {
        return this.field_1_option_flag;
    }

    public byte getKeyboardShortcut() {
        return this.field_2_keyboard_shortcut;
    }

    private int getNameTextLength() {
        if (this.isBuiltInName()) {
            return 1;
        }
        return this.field_12_name_text.length();
    }

    public boolean isHiddenName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public void setHidden(boolean bl) {
        this.field_1_option_flag = bl ? (short)(this.field_1_option_flag | 1) : (short)(this.field_1_option_flag & 0xFFFFFFFE);
    }

    public boolean isFunctionName() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public void setFunction(boolean bl) {
        this.field_1_option_flag = bl ? (short)(this.field_1_option_flag | 2) : (short)(this.field_1_option_flag & 0xFFFFFFFD);
    }

    public boolean hasFormula() {
        return Option.isFormula(this.field_1_option_flag) && this.field_13_name_definition.getEncodedTokenSize() > 0;
    }

    public boolean isCommandName() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isMacro() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isComplexFunction() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 0x20) != 0;
    }

    public String getNameText() {
        return this.isBuiltInName() ? NameRecord.translateBuiltInName(this.getBuiltInName()) : this.field_12_name_text;
    }

    public byte getBuiltInName() {
        return this.field_12_built_in_code;
    }

    public Ptg[] getNameDefinition() {
        return this.field_13_name_definition.getTokens();
    }

    public void setNameDefinition(Ptg[] ptgArray) {
        this.field_13_name_definition = Formula.create(ptgArray);
    }

    public String getCustomMenuText() {
        return this.field_14_custom_menu_text;
    }

    public String getDescriptionText() {
        return this.field_15_description_text;
    }

    public String getHelpTopicText() {
        return this.field_16_help_topic_text;
    }

    public String getStatusBarText() {
        return this.field_17_status_bar_text;
    }

    public void serialize(ContinuableRecordOutput continuableRecordOutput) {
        int n = this.field_14_custom_menu_text.length();
        int n2 = this.field_15_description_text.length();
        int n3 = this.field_16_help_topic_text.length();
        int n4 = this.field_17_status_bar_text.length();
        continuableRecordOutput.writeShort(this.getOptionFlag());
        continuableRecordOutput.writeByte(this.getKeyboardShortcut());
        continuableRecordOutput.writeByte(this.getNameTextLength());
        continuableRecordOutput.writeShort(this.field_13_name_definition.getEncodedTokenSize());
        continuableRecordOutput.writeShort(this.field_5_externSheetIndex_plus1);
        continuableRecordOutput.writeShort(this.field_6_sheetNumber);
        continuableRecordOutput.writeByte(n);
        continuableRecordOutput.writeByte(n2);
        continuableRecordOutput.writeByte(n3);
        continuableRecordOutput.writeByte(n4);
        continuableRecordOutput.writeByte(this.field_11_nameIsMultibyte ? 1 : 0);
        if (this.isBuiltInName()) {
            continuableRecordOutput.writeByte(this.field_12_built_in_code);
        } else {
            String string = this.field_12_name_text;
            if (this.field_11_nameIsMultibyte) {
                StringUtil.putUnicodeLE(string, continuableRecordOutput);
            } else {
                StringUtil.putCompressedUnicode(string, continuableRecordOutput);
            }
        }
        this.field_13_name_definition.serializeTokens(continuableRecordOutput);
        this.field_13_name_definition.serializeArrayConstantData(continuableRecordOutput);
        StringUtil.putCompressedUnicode(this.getCustomMenuText(), continuableRecordOutput);
        StringUtil.putCompressedUnicode(this.getDescriptionText(), continuableRecordOutput);
        StringUtil.putCompressedUnicode(this.getHelpTopicText(), continuableRecordOutput);
        StringUtil.putCompressedUnicode(this.getStatusBarText(), continuableRecordOutput);
    }

    private int getNameRawSize() {
        if (this.isBuiltInName()) {
            return 1;
        }
        int n = this.field_12_name_text.length();
        if (this.field_11_nameIsMultibyte) {
            return 2 * n;
        }
        return n;
    }

    protected int getDataSize() {
        return 13 + this.getNameRawSize() + this.field_14_custom_menu_text.length() + this.field_15_description_text.length() + this.field_16_help_topic_text.length() + this.field_17_status_bar_text.length() + this.field_13_name_definition.getEncodedSize();
    }

    public int getExternSheetNumber() {
        if (this.field_13_name_definition.getEncodedSize() < 1) {
            return 0;
        }
        Ptg ptg = this.field_13_name_definition.getTokens()[0];
        if (ptg.getClass() == Area3DPtg.class) {
            return ((Area3DPtg)ptg).getExternSheetIndex();
        }
        if (ptg.getClass() == Ref3DPtg.class) {
            return ((Ref3DPtg)ptg).getExternSheetIndex();
        }
        return 0;
    }

    public NameRecord(RecordInputStream recordInputStream) {
        byte[] byArray = recordInputStream.readAllContinuedRemainder();
        LittleEndianByteArrayInputStream littleEndianByteArrayInputStream = new LittleEndianByteArrayInputStream(byArray);
        this.field_1_option_flag = littleEndianByteArrayInputStream.readShort();
        this.field_2_keyboard_shortcut = littleEndianByteArrayInputStream.readByte();
        int n = littleEndianByteArrayInputStream.readUByte();
        short s = littleEndianByteArrayInputStream.readShort();
        this.field_5_externSheetIndex_plus1 = littleEndianByteArrayInputStream.readShort();
        this.field_6_sheetNumber = littleEndianByteArrayInputStream.readUShort();
        int n2 = littleEndianByteArrayInputStream.readUByte();
        int n3 = littleEndianByteArrayInputStream.readUByte();
        int n4 = littleEndianByteArrayInputStream.readUByte();
        int n5 = littleEndianByteArrayInputStream.readUByte();
        boolean bl = this.field_11_nameIsMultibyte = littleEndianByteArrayInputStream.readByte() != 0;
        if (this.isBuiltInName()) {
            this.field_12_built_in_code = littleEndianByteArrayInputStream.readByte();
        } else {
            this.field_12_name_text = this.field_11_nameIsMultibyte ? StringUtil.readUnicodeLE(littleEndianByteArrayInputStream, n) : StringUtil.readCompressedUnicode(littleEndianByteArrayInputStream, n);
        }
        int n6 = littleEndianByteArrayInputStream.available() - (n2 + n3 + n4 + n5);
        this.field_13_name_definition = Formula.read(s, littleEndianByteArrayInputStream, n6);
        this.field_14_custom_menu_text = StringUtil.readCompressedUnicode(littleEndianByteArrayInputStream, n2);
        this.field_15_description_text = StringUtil.readCompressedUnicode(littleEndianByteArrayInputStream, n3);
        this.field_16_help_topic_text = StringUtil.readCompressedUnicode(littleEndianByteArrayInputStream, n4);
        this.field_17_status_bar_text = StringUtil.readCompressedUnicode(littleEndianByteArrayInputStream, n5);
    }

    public short getSid() {
        return 24;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NAME]\n");
        stringBuffer.append("    .option flags           = ").append(HexDump.shortToHex(this.field_1_option_flag)).append("\n");
        stringBuffer.append("    .keyboard shortcut      = ").append(HexDump.byteToHex(this.field_2_keyboard_shortcut)).append("\n");
        stringBuffer.append("    .length of the name     = ").append(this.getNameTextLength()).append("\n");
        stringBuffer.append("    .extSheetIx(1-based, 0=Global)= ").append(this.field_5_externSheetIndex_plus1).append("\n");
        stringBuffer.append("    .sheetTabIx             = ").append(this.field_6_sheetNumber).append("\n");
        stringBuffer.append("    .Menu text length       = ").append(this.field_14_custom_menu_text.length()).append("\n");
        stringBuffer.append("    .Description text length= ").append(this.field_15_description_text.length()).append("\n");
        stringBuffer.append("    .Help topic text length = ").append(this.field_16_help_topic_text.length()).append("\n");
        stringBuffer.append("    .Status bar text length = ").append(this.field_17_status_bar_text.length()).append("\n");
        stringBuffer.append("    .NameIsMultibyte        = ").append(this.field_11_nameIsMultibyte).append("\n");
        stringBuffer.append("    .Name (Unicode text)    = ").append(this.getNameText()).append("\n");
        Ptg[] ptgArray = this.field_13_name_definition.getTokens();
        stringBuffer.append("    .Formula (nTokens=").append(ptgArray.length).append("):").append("\n");
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            stringBuffer.append("       " + ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        stringBuffer.append("    .Menu text       = ").append(this.field_14_custom_menu_text).append("\n");
        stringBuffer.append("    .Description text= ").append(this.field_15_description_text).append("\n");
        stringBuffer.append("    .Help topic text = ").append(this.field_16_help_topic_text).append("\n");
        stringBuffer.append("    .Status bar text = ").append(this.field_17_status_bar_text).append("\n");
        stringBuffer.append("[/NAME]\n");
        return stringBuffer.toString();
    }

    private static String translateBuiltInName(byte by) {
        switch (by) {
            case 10: {
                return "Auto_Activate";
            }
            case 3: {
                return "Auto_Close";
            }
            case 11: {
                return "Auto_Deactivate";
            }
            case 2: {
                return "Auto_Open";
            }
            case 1: {
                return "Consolidate_Area";
            }
            case 5: {
                return "Criteria";
            }
            case 4: {
                return "Database";
            }
            case 9: {
                return "Data_Form";
            }
            case 6: {
                return "Print_Area";
            }
            case 7: {
                return "Print_Titles";
            }
            case 8: {
                return "Recorder";
            }
            case 12: {
                return "Sheet_Title";
            }
            case 13: {
                return "_FilterDatabase";
            }
        }
        return "Unknown";
    }

    private static final class Option {
        public static final int OPT_HIDDEN_NAME = 1;
        public static final int OPT_FUNCTION_NAME = 2;
        public static final int OPT_COMMAND_NAME = 4;
        public static final int OPT_MACRO = 8;
        public static final int OPT_COMPLEX = 16;
        public static final int OPT_BUILTIN = 32;
        public static final int OPT_BINDATA = 4096;

        private Option() {
        }

        public static final boolean isFormula(int n) {
            return (n & 0xF) == 0;
        }
    }
}

