/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.hssf.util.RKUtil;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class MulRKRecord
extends StandardRecord {
    public static final short sid = 189;
    private int field_1_row;
    private short field_2_first_col;
    private RkRec[] field_3_rks;
    private short field_4_last_col;

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int n) {
        return this.field_3_rks[n].xf;
    }

    public double getRKNumberAt(int n) {
        return RKUtil.decodeNumber(this.field_3_rks[n].rk);
    }

    public MulRKRecord(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_first_col = recordInputStream.readShort();
        this.field_3_rks = RkRec.parseRKs(recordInputStream);
        this.field_4_last_col = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MULRK]\n");
        stringBuffer.append("\t.row\t = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        stringBuffer.append("\t.firstcol= ").append(HexDump.shortToHex(this.getFirstColumn())).append("\n");
        stringBuffer.append("\t.lastcol = ").append(HexDump.shortToHex(this.getLastColumn())).append("\n");
        for (int i = 0; i < this.getNumColumns(); ++i) {
            stringBuffer.append("\txf[").append(i).append("] = ").append(HexDump.shortToHex(this.getXFAt(i))).append("\n");
            stringBuffer.append("\trk[").append(i).append("] = ").append(this.getRKNumberAt(i)).append("\n");
        }
        stringBuffer.append("[/MULRK]\n");
        return stringBuffer.toString();
    }

    public short getSid() {
        return 189;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        throw new RecordFormatException("Sorry, you can't serialize MulRK in this release");
    }

    protected int getDataSize() {
        throw new RecordFormatException("Sorry, you can't serialize MulRK in this release");
    }

    private static final class RkRec {
        public static final int ENCODED_SIZE = 6;
        public final short xf;
        public final int rk;

        private RkRec(RecordInputStream recordInputStream) {
            this.xf = recordInputStream.readShort();
            this.rk = recordInputStream.readInt();
        }

        public static RkRec[] parseRKs(RecordInputStream recordInputStream) {
            int n = (recordInputStream.remaining() - 2) / 6;
            RkRec[] rkRecArray = new RkRec[n];
            for (int i = 0; i < n; ++i) {
                rkRecArray[i] = new RkRec(recordInputStream);
            }
            return rkRecArray;
        }
    }
}

