/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class MMSRecord
extends StandardRecord {
    public static final short sid = 193;
    private byte field_1_addMenuCount;
    private byte field_2_delMenuCount;

    public MMSRecord() {
    }

    public MMSRecord(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() == 0) {
            return;
        }
        this.field_1_addMenuCount = recordInputStream.readByte();
        this.field_2_delMenuCount = recordInputStream.readByte();
    }

    public void setAddMenuCount(byte by) {
        this.field_1_addMenuCount = by;
    }

    public void setDelMenuCount(byte by) {
        this.field_2_delMenuCount = by;
    }

    public byte getAddMenuCount() {
        return this.field_1_addMenuCount;
    }

    public byte getDelMenuCount() {
        return this.field_2_delMenuCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MMS]\n");
        stringBuffer.append("    .addMenu        = ").append(Integer.toHexString(this.getAddMenuCount())).append("\n");
        stringBuffer.append("    .delMenu        = ").append(Integer.toHexString(this.getDelMenuCount())).append("\n");
        stringBuffer.append("[/MMS]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.getAddMenuCount());
        littleEndianOutput.writeByte(this.getDelMenuCount());
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 193;
    }
}

