/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class InterfaceHdrRecord
extends StandardRecord {
    public static final short sid = 225;
    private final int _codepage;
    public static final int CODEPAGE = 1200;

    public InterfaceHdrRecord(int n) {
        this._codepage = n;
    }

    public InterfaceHdrRecord(RecordInputStream recordInputStream) {
        this._codepage = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[INTERFACEHDR]\n");
        stringBuffer.append("    .codepage = ").append(HexDump.shortToHex(this._codepage)).append("\n");
        stringBuffer.append("[/INTERFACEHDR]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._codepage);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 225;
    }
}

