/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecord;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai.org.apache.poi.util.LittleEndianOutput;
import java.util.ArrayList;

public final class ExtSSTRecord
extends ContinuableRecord {
    public static final short sid = 255;
    public static final int DEFAULT_BUCKET_SIZE = 8;
    public static final int MAX_BUCKETS = 128;
    private short _stringsPerBucket;
    private InfoSubRecord[] _sstInfos;

    public ExtSSTRecord() {
        this._stringsPerBucket = (short)8;
        this._sstInfos = new InfoSubRecord[0];
    }

    public ExtSSTRecord(RecordInputStream recordInputStream) {
        this._stringsPerBucket = recordInputStream.readShort();
        int n = recordInputStream.remaining() / 8;
        ArrayList<InfoSubRecord> arrayList = new ArrayList<InfoSubRecord>(n);
        while (recordInputStream.available() > 0) {
            InfoSubRecord infoSubRecord = new InfoSubRecord(recordInputStream);
            arrayList.add(infoSubRecord);
            if (recordInputStream.available() != 0 || !recordInputStream.hasNextRecord() || recordInputStream.getNextSid() != 60) continue;
            recordInputStream.nextRecord();
        }
        this._sstInfos = arrayList.toArray(new InfoSubRecord[arrayList.size()]);
    }

    public void setNumStringsPerBucket(short s) {
        this._stringsPerBucket = s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTSST]\n");
        stringBuffer.append("    .dsst           = ").append(Integer.toHexString(this._stringsPerBucket)).append("\n");
        stringBuffer.append("    .numInfoRecords = ").append(this._sstInfos.length).append("\n");
        for (int i = 0; i < this._sstInfos.length; ++i) {
            stringBuffer.append("    .inforecord     = ").append(i).append("\n");
            stringBuffer.append("    .streampos      = ").append(Integer.toHexString(this._sstInfos[i].getStreamPos())).append("\n");
            stringBuffer.append("    .sstoffset      = ").append(Integer.toHexString(this._sstInfos[i].getBucketSSTOffset())).append("\n");
        }
        stringBuffer.append("[/EXTSST]\n");
        return stringBuffer.toString();
    }

    public void serialize(ContinuableRecordOutput continuableRecordOutput) {
        continuableRecordOutput.writeShort(this._stringsPerBucket);
        for (int i = 0; i < this._sstInfos.length; ++i) {
            this._sstInfos[i].serialize(continuableRecordOutput);
        }
    }

    protected int getDataSize() {
        return 2 + 8 * this._sstInfos.length;
    }

    protected InfoSubRecord[] getInfoSubRecords() {
        return this._sstInfos;
    }

    public static final int getNumberOfInfoRecsForStrings(int n) {
        int n2 = n / 8;
        if (n % 8 != 0) {
            ++n2;
        }
        if (n2 > 128) {
            n2 = 128;
        }
        return n2;
    }

    public static final int getRecordSizeForStrings(int n) {
        return 6 + ExtSSTRecord.getNumberOfInfoRecsForStrings(n) * 8;
    }

    public short getSid() {
        return 255;
    }

    public void setBucketOffsets(int[] nArray, int[] nArray2) {
        this._sstInfos = new InfoSubRecord[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this._sstInfos[i] = new InfoSubRecord(nArray[i], nArray2[i]);
        }
    }

    public static final class InfoSubRecord {
        public static final int ENCODED_SIZE = 8;
        private int field_1_stream_pos;
        private int field_2_bucket_sst_offset;
        private short field_3_zero;

        public InfoSubRecord(int n, int n2) {
            this.field_1_stream_pos = n;
            this.field_2_bucket_sst_offset = n2;
        }

        public InfoSubRecord(RecordInputStream recordInputStream) {
            this.field_1_stream_pos = recordInputStream.readInt();
            this.field_2_bucket_sst_offset = recordInputStream.readShort();
            this.field_3_zero = recordInputStream.readShort();
        }

        public int getStreamPos() {
            return this.field_1_stream_pos;
        }

        public int getBucketSSTOffset() {
            return this.field_2_bucket_sst_offset;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeInt(this.field_1_stream_pos);
            littleEndianOutput.writeShort(this.field_2_bucket_sst_offset);
            littleEndianOutput.writeShort(this.field_3_zero);
        }
    }
}

