/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class DVALRecord
extends StandardRecord {
    public static final short sid = 434;
    private short field_1_options;
    private int field_2_horiz_pos;
    private int field_3_vert_pos;
    private int field_cbo_id;
    private int field_5_dv_no;

    public DVALRecord() {
        this.field_cbo_id = -1;
        this.field_5_dv_no = 0;
    }

    public DVALRecord(RecordInputStream recordInputStream) {
        this.field_1_options = recordInputStream.readShort();
        this.field_2_horiz_pos = recordInputStream.readInt();
        this.field_3_vert_pos = recordInputStream.readInt();
        this.field_cbo_id = recordInputStream.readInt();
        this.field_5_dv_no = recordInputStream.readInt();
    }

    public void setOptions(short s) {
        this.field_1_options = s;
    }

    public void setHorizontalPos(int n) {
        this.field_2_horiz_pos = n;
    }

    public void setVerticalPos(int n) {
        this.field_3_vert_pos = n;
    }

    public void setObjectID(int n) {
        this.field_cbo_id = n;
    }

    public void setDVRecNo(int n) {
        this.field_5_dv_no = n;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public int getHorizontalPos() {
        return this.field_2_horiz_pos;
    }

    public int getVerticalPos() {
        return this.field_3_vert_pos;
    }

    public int getObjectID() {
        return this.field_cbo_id;
    }

    public int getDVRecNo() {
        return this.field_5_dv_no;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DVAL]\n");
        stringBuffer.append("    .options      = ").append(this.getOptions()).append('\n');
        stringBuffer.append("    .horizPos     = ").append(this.getHorizontalPos()).append('\n');
        stringBuffer.append("    .vertPos      = ").append(this.getVerticalPos()).append('\n');
        stringBuffer.append("    .comboObjectID   = ").append(Integer.toHexString(this.getObjectID())).append("\n");
        stringBuffer.append("    .DVRecordsNumber = ").append(Integer.toHexString(this.getDVRecNo())).append("\n");
        stringBuffer.append("[/DVAL]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getOptions());
        littleEndianOutput.writeInt(this.getHorizontalPos());
        littleEndianOutput.writeInt(this.getVerticalPos());
        littleEndianOutput.writeInt(this.getObjectID());
        littleEndianOutput.writeInt(this.getDVRecNo());
    }

    protected int getDataSize() {
        return 18;
    }

    public short getSid() {
        return 434;
    }

    public Object clone() {
        DVALRecord dVALRecord = new DVALRecord();
        dVALRecord.field_1_options = this.field_1_options;
        dVALRecord.field_2_horiz_pos = this.field_2_horiz_pos;
        dVALRecord.field_3_vert_pos = this.field_3_vert_pos;
        dVALRecord.field_cbo_id = this.field_cbo_id;
        dVALRecord.field_5_dv_no = this.field_5_dv_no;
        return dVALRecord;
    }
}

