/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.hssf.record.cf.BorderFormatting;
import ai.org.apache.poi.hssf.record.cf.FontFormatting;
import ai.org.apache.poi.hssf.record.cf.PatternFormatting;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.ss.formula.Formula;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;

public final class CFRuleRecord
extends StandardRecord {
    public static final short sid = 433;
    private byte field_1_condition_type;
    public static final byte CONDITION_TYPE_CELL_VALUE_IS = 1;
    public static final byte CONDITION_TYPE_FORMULA = 2;
    private byte field_2_comparison_operator;
    private int field_5_options;
    private static final BitField modificationBits = CFRuleRecord.bf(0x3FFFFF);
    private static final BitField alignHor = CFRuleRecord.bf(1);
    private static final BitField alignVer = CFRuleRecord.bf(2);
    private static final BitField alignWrap = CFRuleRecord.bf(4);
    private static final BitField alignRot = CFRuleRecord.bf(8);
    private static final BitField alignJustLast = CFRuleRecord.bf(16);
    private static final BitField alignIndent = CFRuleRecord.bf(32);
    private static final BitField alignShrin = CFRuleRecord.bf(64);
    private static final BitField notUsed1 = CFRuleRecord.bf(128);
    private static final BitField protLocked = CFRuleRecord.bf(256);
    private static final BitField protHidden = CFRuleRecord.bf(512);
    private static final BitField bordLeft = CFRuleRecord.bf(1024);
    private static final BitField bordRight = CFRuleRecord.bf(2048);
    private static final BitField bordTop = CFRuleRecord.bf(4096);
    private static final BitField bordBot = CFRuleRecord.bf(8192);
    private static final BitField bordTlBr = CFRuleRecord.bf(16384);
    private static final BitField bordBlTr = CFRuleRecord.bf(32768);
    private static final BitField pattStyle = CFRuleRecord.bf(65536);
    private static final BitField pattCol = CFRuleRecord.bf(131072);
    private static final BitField pattBgCol = CFRuleRecord.bf(262144);
    private static final BitField notUsed2 = CFRuleRecord.bf(0x380000);
    private static final BitField undocumented = CFRuleRecord.bf(0x3C00000);
    private static final BitField fmtBlockBits = CFRuleRecord.bf(0x7C000000);
    private static final BitField font = CFRuleRecord.bf(0x4000000);
    private static final BitField align = CFRuleRecord.bf(0x8000000);
    private static final BitField bord = CFRuleRecord.bf(0x10000000);
    private static final BitField patt = CFRuleRecord.bf(0x20000000);
    private static final BitField prot = CFRuleRecord.bf(0x40000000);
    private static final BitField alignTextDir = CFRuleRecord.bf(Integer.MIN_VALUE);
    private short field_6_not_used;
    private FontFormatting _fontFormatting;
    private BorderFormatting _borderFormatting;
    private PatternFormatting _patternFormatting;
    private Formula field_17_formula1;
    private Formula field_18_formula2;

    private static BitField bf(int n) {
        return BitFieldFactory.getInstance(n);
    }

    private CFRuleRecord(byte by, byte by2) {
        this.field_1_condition_type = by;
        this.field_2_comparison_operator = by2;
        this.field_5_options = modificationBits.setValue(this.field_5_options, -1);
        this.field_5_options = fmtBlockBits.setValue(this.field_5_options, 0);
        this.field_5_options = undocumented.clear(this.field_5_options);
        this.field_6_not_used = (short)-32766;
        this._fontFormatting = null;
        this._borderFormatting = null;
        this._patternFormatting = null;
        this.field_17_formula1 = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.field_18_formula2 = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    private CFRuleRecord(byte by, byte by2, Ptg[] ptgArray, Ptg[] ptgArray2) {
        this(by, by2);
        this.field_17_formula1 = Formula.create(ptgArray);
        this.field_18_formula2 = Formula.create(ptgArray2);
    }

    public static CFRuleRecord create(HSSFSheet hSSFSheet, String string) {
        Ptg[] ptgArray = CFRuleRecord.parseFormula(string, hSSFSheet);
        return new CFRuleRecord(2, 0, ptgArray, null);
    }

    public static CFRuleRecord create(HSSFSheet hSSFSheet, byte by, String string, String string2) {
        Ptg[] ptgArray = CFRuleRecord.parseFormula(string, hSSFSheet);
        Ptg[] ptgArray2 = CFRuleRecord.parseFormula(string2, hSSFSheet);
        return new CFRuleRecord(1, by, ptgArray, ptgArray2);
    }

    public CFRuleRecord(RecordInputStream recordInputStream) {
        this.field_1_condition_type = recordInputStream.readByte();
        this.field_2_comparison_operator = recordInputStream.readByte();
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.readUShort();
        this.field_5_options = recordInputStream.readInt();
        this.field_6_not_used = recordInputStream.readShort();
        if (this.containsFontFormattingBlock()) {
            this._fontFormatting = new FontFormatting(recordInputStream);
        }
        if (this.containsBorderFormattingBlock()) {
            this._borderFormatting = new BorderFormatting(recordInputStream);
        }
        if (this.containsPatternFormattingBlock()) {
            this._patternFormatting = new PatternFormatting(recordInputStream);
        }
        this.field_17_formula1 = Formula.read(n, recordInputStream);
        this.field_18_formula2 = Formula.read(n2, recordInputStream);
    }

    public byte getConditionType() {
        return this.field_1_condition_type;
    }

    public boolean containsFontFormattingBlock() {
        return this.getOptionFlag(font);
    }

    public void setFontFormatting(FontFormatting fontFormatting) {
        this._fontFormatting = fontFormatting;
        this.setOptionFlag(fontFormatting != null, font);
    }

    public FontFormatting getFontFormatting() {
        if (this.containsFontFormattingBlock()) {
            return this._fontFormatting;
        }
        return null;
    }

    public boolean containsAlignFormattingBlock() {
        return this.getOptionFlag(align);
    }

    public void setAlignFormattingUnchanged() {
        this.setOptionFlag(false, align);
    }

    public boolean containsBorderFormattingBlock() {
        return this.getOptionFlag(bord);
    }

    public void setBorderFormatting(BorderFormatting borderFormatting) {
        this._borderFormatting = borderFormatting;
        this.setOptionFlag(borderFormatting != null, bord);
    }

    public BorderFormatting getBorderFormatting() {
        if (this.containsBorderFormattingBlock()) {
            return this._borderFormatting;
        }
        return null;
    }

    public boolean containsPatternFormattingBlock() {
        return this.getOptionFlag(patt);
    }

    public void setPatternFormatting(PatternFormatting patternFormatting) {
        this._patternFormatting = patternFormatting;
        this.setOptionFlag(patternFormatting != null, patt);
    }

    public PatternFormatting getPatternFormatting() {
        if (this.containsPatternFormattingBlock()) {
            return this._patternFormatting;
        }
        return null;
    }

    public boolean containsProtectionFormattingBlock() {
        return this.getOptionFlag(prot);
    }

    public void setProtectionFormattingUnchanged() {
        this.setOptionFlag(false, prot);
    }

    public void setComparisonOperation(byte by) {
        this.field_2_comparison_operator = by;
    }

    public byte getComparisonOperation() {
        return this.field_2_comparison_operator;
    }

    public int getOptions() {
        return this.field_5_options;
    }

    private boolean isModified(BitField bitField) {
        return !bitField.isSet(this.field_5_options);
    }

    private void setModified(boolean bl, BitField bitField) {
        this.field_5_options = bitField.setBoolean(this.field_5_options, !bl);
    }

    public boolean isLeftBorderModified() {
        return this.isModified(bordLeft);
    }

    public void setLeftBorderModified(boolean bl) {
        this.setModified(bl, bordLeft);
    }

    public boolean isRightBorderModified() {
        return this.isModified(bordRight);
    }

    public void setRightBorderModified(boolean bl) {
        this.setModified(bl, bordRight);
    }

    public boolean isTopBorderModified() {
        return this.isModified(bordTop);
    }

    public void setTopBorderModified(boolean bl) {
        this.setModified(bl, bordTop);
    }

    public boolean isBottomBorderModified() {
        return this.isModified(bordBot);
    }

    public void setBottomBorderModified(boolean bl) {
        this.setModified(bl, bordBot);
    }

    public boolean isTopLeftBottomRightBorderModified() {
        return this.isModified(bordTlBr);
    }

    public void setTopLeftBottomRightBorderModified(boolean bl) {
        this.setModified(bl, bordTlBr);
    }

    public boolean isBottomLeftTopRightBorderModified() {
        return this.isModified(bordBlTr);
    }

    public void setBottomLeftTopRightBorderModified(boolean bl) {
        this.setModified(bl, bordBlTr);
    }

    public boolean isPatternStyleModified() {
        return this.isModified(pattStyle);
    }

    public void setPatternStyleModified(boolean bl) {
        this.setModified(bl, pattStyle);
    }

    public boolean isPatternColorModified() {
        return this.isModified(pattCol);
    }

    public void setPatternColorModified(boolean bl) {
        this.setModified(bl, pattCol);
    }

    public boolean isPatternBackgroundColorModified() {
        return this.isModified(pattBgCol);
    }

    public void setPatternBackgroundColorModified(boolean bl) {
        this.setModified(bl, pattBgCol);
    }

    private boolean getOptionFlag(BitField bitField) {
        return bitField.isSet(this.field_5_options);
    }

    private void setOptionFlag(boolean bl, BitField bitField) {
        this.field_5_options = bitField.setBoolean(this.field_5_options, bl);
    }

    public Ptg[] getParsedExpression1() {
        return this.field_17_formula1.getTokens();
    }

    public void setParsedExpression1(Ptg[] ptgArray) {
        this.field_17_formula1 = Formula.create(ptgArray);
    }

    public Ptg[] getParsedExpression2() {
        return Formula.getTokens(this.field_18_formula2);
    }

    public void setParsedExpression2(Ptg[] ptgArray) {
        this.field_18_formula2 = Formula.create(ptgArray);
    }

    public short getSid() {
        return 433;
    }

    private static int getFormulaSize(Formula formula) {
        return formula.getEncodedTokenSize();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = CFRuleRecord.getFormulaSize(this.field_17_formula1);
        int n2 = CFRuleRecord.getFormulaSize(this.field_18_formula2);
        littleEndianOutput.writeByte(this.field_1_condition_type);
        littleEndianOutput.writeByte(this.field_2_comparison_operator);
        littleEndianOutput.writeShort(n);
        littleEndianOutput.writeShort(n2);
        littleEndianOutput.writeInt(this.field_5_options);
        littleEndianOutput.writeShort(this.field_6_not_used);
        if (this.containsFontFormattingBlock()) {
            byte[] byArray = this._fontFormatting.getRawRecord();
            littleEndianOutput.write(byArray);
        }
        if (this.containsBorderFormattingBlock()) {
            this._borderFormatting.serialize(littleEndianOutput);
        }
        if (this.containsPatternFormattingBlock()) {
            this._patternFormatting.serialize(littleEndianOutput);
        }
        this.field_17_formula1.serializeTokens(littleEndianOutput);
        this.field_18_formula2.serializeTokens(littleEndianOutput);
    }

    protected int getDataSize() {
        int n = 12 + (this.containsFontFormattingBlock() ? this._fontFormatting.getRawRecord().length : 0) + (this.containsBorderFormattingBlock() ? 8 : 0) + (this.containsPatternFormattingBlock() ? 4 : 0) + CFRuleRecord.getFormulaSize(this.field_17_formula1) + CFRuleRecord.getFormulaSize(this.field_18_formula2);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CFRULE]\n");
        stringBuffer.append("    .condition_type   =").append(this.field_1_condition_type).append("\n");
        stringBuffer.append("    OPTION FLAGS=0x").append(Integer.toHexString(this.getOptions())).append("\n");
        if (this.containsFontFormattingBlock()) {
            stringBuffer.append(this._fontFormatting.toString()).append("\n");
        }
        if (this.containsBorderFormattingBlock()) {
            stringBuffer.append(this._borderFormatting.toString()).append("\n");
        }
        if (this.containsPatternFormattingBlock()) {
            stringBuffer.append(this._patternFormatting.toString()).append("\n");
        }
        stringBuffer.append("    Formula 1 =").append(Arrays.toString(this.field_17_formula1.getTokens())).append("\n");
        stringBuffer.append("    Formula 2 =").append(Arrays.toString(this.field_18_formula2.getTokens())).append("\n");
        stringBuffer.append("[/CFRULE]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        CFRuleRecord cFRuleRecord = new CFRuleRecord(this.field_1_condition_type, this.field_2_comparison_operator);
        cFRuleRecord.field_5_options = this.field_5_options;
        cFRuleRecord.field_6_not_used = this.field_6_not_used;
        if (this.containsFontFormattingBlock()) {
            cFRuleRecord._fontFormatting = (FontFormatting)this._fontFormatting.clone();
        }
        if (this.containsBorderFormattingBlock()) {
            cFRuleRecord._borderFormatting = (BorderFormatting)this._borderFormatting.clone();
        }
        if (this.containsPatternFormattingBlock()) {
            cFRuleRecord._patternFormatting = (PatternFormatting)this._patternFormatting.clone();
        }
        cFRuleRecord.field_17_formula1 = this.field_17_formula1.copy();
        cFRuleRecord.field_18_formula2 = this.field_18_formula2.copy();
        return cFRuleRecord;
    }

    private static Ptg[] parseFormula(String string, HSSFSheet hSSFSheet) {
        if (string == null) {
            return null;
        }
        int n = hSSFSheet.getWorkbook().getSheetIndex(hSSFSheet);
        return HSSFFormulaParser.parse(string, hSSFSheet.getWorkbook(), 0, n);
    }

    public static final class ComparisonOperator {
        public static final byte NO_COMPARISON = 0;
        public static final byte BETWEEN = 1;
        public static final byte NOT_BETWEEN = 2;
        public static final byte EQUAL = 3;
        public static final byte NOT_EQUAL = 4;
        public static final byte GT = 5;
        public static final byte LT = 6;
        public static final byte GE = 7;
        public static final byte LE = 8;
    }
}

