/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.hssf.record.cf.CellRangeUtil;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.ss.util.CellRangeAddressList;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class CFHeaderRecord
extends StandardRecord {
    public static final short sid = 432;
    private int field_1_numcf;
    private int field_2_need_recalculation;
    private CellRangeAddress field_3_enclosing_cell_range;
    private CellRangeAddressList field_4_cell_ranges;

    public CFHeaderRecord() {
        this.field_4_cell_ranges = new CellRangeAddressList();
    }

    public CFHeaderRecord(CellRangeAddress[] cellRangeAddressArray, int n) {
        CellRangeAddress[] cellRangeAddressArray2 = cellRangeAddressArray;
        CellRangeAddress[] cellRangeAddressArray3 = CellRangeUtil.mergeCellRanges(cellRangeAddressArray2);
        this.setCellRanges(cellRangeAddressArray3);
        this.field_1_numcf = n;
    }

    public CFHeaderRecord(RecordInputStream recordInputStream) {
        this.field_1_numcf = recordInputStream.readShort();
        this.field_2_need_recalculation = recordInputStream.readShort();
        this.field_3_enclosing_cell_range = new CellRangeAddress(recordInputStream);
        this.field_4_cell_ranges = new CellRangeAddressList(recordInputStream);
    }

    public int getNumberOfConditionalFormats() {
        return this.field_1_numcf;
    }

    public void setNumberOfConditionalFormats(int n) {
        this.field_1_numcf = n;
    }

    public boolean getNeedRecalculation() {
        return this.field_2_need_recalculation == 1;
    }

    public void setNeedRecalculation(boolean bl) {
        this.field_2_need_recalculation = bl ? 1 : 0;
    }

    public CellRangeAddress getEnclosingCellRange() {
        return this.field_3_enclosing_cell_range;
    }

    public void setEnclosingCellRange(CellRangeAddress cellRangeAddress) {
        this.field_3_enclosing_cell_range = cellRangeAddress;
    }

    public void setCellRanges(CellRangeAddress[] cellRangeAddressArray) {
        if (cellRangeAddressArray == null) {
            throw new IllegalArgumentException("cellRanges must not be null");
        }
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList();
        CellRangeAddress cellRangeAddress = null;
        for (int i = 0; i < cellRangeAddressArray.length; ++i) {
            CellRangeAddress cellRangeAddress2 = cellRangeAddressArray[i];
            cellRangeAddress = CellRangeUtil.createEnclosingCellRange(cellRangeAddress2, cellRangeAddress);
            cellRangeAddressList.addCellRangeAddress(cellRangeAddress2);
        }
        this.field_3_enclosing_cell_range = cellRangeAddress;
        this.field_4_cell_ranges = cellRangeAddressList;
    }

    public CellRangeAddress[] getCellRanges() {
        return this.field_4_cell_ranges.getCellRangeAddresses();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CFHEADER]\n");
        stringBuffer.append("\t.id\t\t= ").append(Integer.toHexString(432)).append("\n");
        stringBuffer.append("\t.numCF\t\t\t= ").append(this.getNumberOfConditionalFormats()).append("\n");
        stringBuffer.append("\t.needRecalc\t   = ").append(this.getNeedRecalculation()).append("\n");
        stringBuffer.append("\t.enclosingCellRange= ").append(this.getEnclosingCellRange()).append("\n");
        stringBuffer.append("\t.cfranges=[");
        for (int i = 0; i < this.field_4_cell_ranges.countRanges(); ++i) {
            stringBuffer.append(i == 0 ? "" : ",").append(this.field_4_cell_ranges.getCellRangeAddress(i).toString());
        }
        stringBuffer.append("]\n");
        stringBuffer.append("[/CFHEADER]\n");
        return stringBuffer.toString();
    }

    protected int getDataSize() {
        return 12 + this.field_4_cell_ranges.getSize();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_numcf);
        littleEndianOutput.writeShort(this.field_2_need_recalculation);
        this.field_3_enclosing_cell_range.serialize(littleEndianOutput);
        this.field_4_cell_ranges.serialize(littleEndianOutput);
    }

    public short getSid() {
        return 432;
    }

    public Object clone() {
        CFHeaderRecord cFHeaderRecord = new CFHeaderRecord();
        cFHeaderRecord.field_1_numcf = this.field_1_numcf;
        cFHeaderRecord.field_2_need_recalculation = this.field_2_need_recalculation;
        cFHeaderRecord.field_3_enclosing_cell_range = this.field_3_enclosing_cell_range;
        cFHeaderRecord.field_4_cell_ranges = this.field_4_cell_ranges.copy();
        return cFHeaderRecord;
    }
}

