/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.model;

import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.model.WorkbookRecordList;
import ai.org.apache.poi.hssf.record.CRNCountRecord;
import ai.org.apache.poi.hssf.record.CRNRecord;
import ai.org.apache.poi.hssf.record.ExternSheetRecord;
import ai.org.apache.poi.hssf.record.ExternalNameRecord;
import ai.org.apache.poi.hssf.record.NameCommentRecord;
import ai.org.apache.poi.hssf.record.NameRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.SupBookRecord;
import ai.org.apache.poi.ss.formula.SheetNameFormatter;
import ai.org.apache.poi.ss.formula.ptg.ErrPtg;
import ai.org.apache.poi.ss.formula.ptg.NameXPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.usermodel.Workbook;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LinkTable {
    private ExternalBookBlock[] _externalBookBlocks;
    private final ExternSheetRecord _externSheetRecord;
    private final List<NameRecord> _definedNames;
    private final int _recordCount;
    private final WorkbookRecordList _workbookRecordList;

    public LinkTable(List<Record> list, int n, WorkbookRecordList workbookRecordList, Map<String, NameCommentRecord> map) {
        this._workbookRecordList = workbookRecordList;
        RecordStream recordStream = new RecordStream(list, n);
        ArrayList<ExternalBookBlock> arrayList = new ArrayList<ExternalBookBlock>();
        while (recordStream.peekNextClass() == SupBookRecord.class) {
            arrayList.add(new ExternalBookBlock(recordStream));
        }
        this._externalBookBlocks = new ExternalBookBlock[arrayList.size()];
        arrayList.toArray(this._externalBookBlocks);
        arrayList.clear();
        this._externSheetRecord = this._externalBookBlocks.length > 0 ? (recordStream.peekNextClass() != ExternSheetRecord.class ? null : LinkTable.readExtSheetRecord(recordStream)) : null;
        this._definedNames = new ArrayList<NameRecord>();
        while (true) {
            Record record;
            Class<? extends Record> clazz;
            if ((clazz = recordStream.peekNextClass()) == NameRecord.class) {
                record = (NameRecord)recordStream.getNext();
                this._definedNames.add((NameRecord)record);
                continue;
            }
            if (clazz != NameCommentRecord.class) break;
            record = (NameCommentRecord)recordStream.getNext();
            map.put(((NameCommentRecord)record).getNameText(), (NameCommentRecord)record);
        }
        this._recordCount = recordStream.getCountRead();
        this._workbookRecordList.getRecords().addAll(list.subList(n, n + this._recordCount));
    }

    private static ExternSheetRecord readExtSheetRecord(RecordStream recordStream) {
        ArrayList<ExternSheetRecord> arrayList = new ArrayList<ExternSheetRecord>(2);
        while (recordStream.peekNextClass() == ExternSheetRecord.class) {
            arrayList.add((ExternSheetRecord)recordStream.getNext());
        }
        int n = arrayList.size();
        if (n < 1) {
            throw new RuntimeException("Expected an EXTERNSHEET record but got (" + recordStream.peekNextClass().getName() + ")");
        }
        if (n == 1) {
            return (ExternSheetRecord)arrayList.get(0);
        }
        ExternSheetRecord[] externSheetRecordArray = new ExternSheetRecord[n];
        arrayList.toArray(externSheetRecordArray);
        return ExternSheetRecord.combine(externSheetRecordArray);
    }

    public LinkTable(int n, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        this._definedNames = new ArrayList<NameRecord>();
        this._externalBookBlocks = new ExternalBookBlock[]{new ExternalBookBlock(n)};
        this._externSheetRecord = new ExternSheetRecord();
        this._recordCount = 2;
        SupBookRecord supBookRecord = this._externalBookBlocks[0].getExternalBookRecord();
        int n2 = this.findFirstRecordLocBySid((short)140);
        if (n2 < 0) {
            throw new RuntimeException("CountryRecord not found");
        }
        this._workbookRecordList.add(n2 + 1, this._externSheetRecord);
        this._workbookRecordList.add(n2 + 1, supBookRecord);
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public NameRecord getSpecificBuiltinRecord(byte by, int n) {
        for (NameRecord nameRecord : this._definedNames) {
            if (nameRecord.getBuiltInName() != by || nameRecord.getSheetNumber() != n) continue;
            return nameRecord;
        }
        return null;
    }

    public void removeBuiltinRecord(byte by, int n) {
        NameRecord nameRecord = this.getSpecificBuiltinRecord(by, n);
        if (nameRecord != null) {
            this._definedNames.remove(nameRecord);
        }
    }

    public int getNumNames() {
        return this._definedNames.size();
    }

    public NameRecord getNameRecord(int n) {
        return this._definedNames.get(n);
    }

    public void addName(NameRecord nameRecord) {
        this._definedNames.add(nameRecord);
        int n = this.findFirstRecordLocBySid((short)23);
        if (n == -1) {
            n = this.findFirstRecordLocBySid((short)430);
        }
        if (n == -1) {
            n = this.findFirstRecordLocBySid((short)140);
        }
        int n2 = this._definedNames.size();
        this._workbookRecordList.add(n + n2, nameRecord);
    }

    public void removeName(int n) {
        this._definedNames.remove(n);
    }

    public boolean nameAlreadyExists(NameRecord nameRecord) {
        for (int i = this.getNumNames() - 1; i >= 0; --i) {
            NameRecord nameRecord2 = this.getNameRecord(i);
            if (nameRecord2 == nameRecord || !LinkTable.isDuplicatedNames(nameRecord, nameRecord2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDuplicatedNames(NameRecord nameRecord, NameRecord nameRecord2) {
        return nameRecord2.getNameText().equalsIgnoreCase(nameRecord.getNameText()) && LinkTable.isSameSheetNames(nameRecord, nameRecord2);
    }

    private static boolean isSameSheetNames(NameRecord nameRecord, NameRecord nameRecord2) {
        return nameRecord2.getSheetNumber() == nameRecord.getSheetNumber();
    }

    public String[] getExternalBookAndSheetName(int n) {
        int n2 = this._externSheetRecord.getExtbookIndexFromRefIndex(n);
        SupBookRecord supBookRecord = this._externalBookBlocks[n2].getExternalBookRecord();
        if (!supBookRecord.isExternalReferences()) {
            return null;
        }
        int n3 = this._externSheetRecord.getFirstSheetIndexFromRefIndex(n);
        int n4 = this._externSheetRecord.getLastSheetIndexFromRefIndex(n);
        String string = null;
        String string2 = null;
        if (n3 >= 0) {
            string = supBookRecord.getSheetNames()[n3];
        }
        if (n4 >= 0) {
            string2 = supBookRecord.getSheetNames()[n4];
        }
        if (n3 == n4) {
            return new String[]{supBookRecord.getURL(), string};
        }
        return new String[]{supBookRecord.getURL(), string, string2};
    }

    private int getExternalWorkbookIndex(String string) {
        for (int i = 0; i < this._externalBookBlocks.length; ++i) {
            SupBookRecord supBookRecord = this._externalBookBlocks[i].getExternalBookRecord();
            if (!supBookRecord.isExternalReferences() || !string.equals(supBookRecord.getURL())) continue;
            return i;
        }
        return -1;
    }

    public int linkExternalWorkbook(String string, Workbook workbook) {
        int n = this.getExternalWorkbookIndex(string);
        if (n != -1) {
            return n;
        }
        String[] stringArray = new String[workbook.getNumberOfSheets()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = workbook.getSheetName(i);
        }
        String string2 = "\u0000" + string;
        ExternalBookBlock externalBookBlock = new ExternalBookBlock(string2, stringArray);
        n = this.extendExternalBookBlocks(externalBookBlock);
        int n2 = this.findFirstRecordLocBySid((short)23);
        if (n2 == -1) {
            n2 = this._workbookRecordList.size();
        }
        this._workbookRecordList.add(n2, externalBookBlock.getExternalBookRecord());
        for (int i = 0; i < stringArray.length; ++i) {
            this._externSheetRecord.addRef(n, i, i);
        }
        return n;
    }

    public int getExternalSheetIndex(String string, String string2, String string3) {
        int n;
        int n2 = this.getExternalWorkbookIndex(string);
        if (n2 == -1) {
            throw new RuntimeException("No external workbook with name '" + string + "'");
        }
        SupBookRecord supBookRecord = this._externalBookBlocks[n2].getExternalBookRecord();
        int n3 = LinkTable.getSheetIndex(supBookRecord.getSheetNames(), string2);
        int n4 = this._externSheetRecord.getRefIxForSheet(n2, n3, n = LinkTable.getSheetIndex(supBookRecord.getSheetNames(), string3));
        if (n4 < 0) {
            n4 = this._externSheetRecord.addRef(n2, n3, n);
        }
        return n4;
    }

    private static int getSheetIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        throw new RuntimeException("External workbook does not contain sheet '" + string + "'");
    }

    public int getFirstInternalSheetIndexForExtIndex(int n) {
        if (n >= this._externSheetRecord.getNumOfRefs() || n < 0) {
            return -1;
        }
        return this._externSheetRecord.getFirstSheetIndexFromRefIndex(n);
    }

    public int getLastInternalSheetIndexForExtIndex(int n) {
        if (n >= this._externSheetRecord.getNumOfRefs() || n < 0) {
            return -1;
        }
        return this._externSheetRecord.getLastSheetIndexFromRefIndex(n);
    }

    @Deprecated
    public void updateIndexToInternalSheet(int n, int n2) {
        this._externSheetRecord.adjustIndex(n, n2);
    }

    public void removeSheet(int n) {
        this._externSheetRecord.removeSheet(n);
    }

    public int checkExternSheet(int n) {
        return this.checkExternSheet(n, n);
    }

    public int checkExternSheet(int n, int n2) {
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < this._externalBookBlocks.length; ++n3) {
            SupBookRecord supBookRecord = this._externalBookBlocks[n3].getExternalBookRecord();
            if (!supBookRecord.isInternalReferences()) continue;
            n4 = n3;
            break;
        }
        if (n4 < 0) {
            throw new RuntimeException("Could not find 'internal references' EXTERNALBOOK");
        }
        n3 = this._externSheetRecord.getRefIxForSheet(n4, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        return this._externSheetRecord.addRef(n4, n, n2);
    }

    private int findFirstRecordLocBySid(short s) {
        int n = 0;
        for (Record record : this._workbookRecordList) {
            if (record.getSid() == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String resolveNameXText(int n, int n2, InternalWorkbook internalWorkbook) {
        int n3 = this._externSheetRecord.getExtbookIndexFromRefIndex(n);
        int n4 = this._externSheetRecord.getFirstSheetIndexFromRefIndex(n);
        if (n4 == -1) {
            throw new RuntimeException("Referenced sheet could not be found");
        }
        ExternalBookBlock externalBookBlock = this._externalBookBlocks[n3];
        if (externalBookBlock._externalNameRecords.length > n2) {
            return this._externalBookBlocks[n3].getNameText(n2);
        }
        if (n4 == -2) {
            NameRecord nameRecord = this.getNameRecord(n2);
            int n5 = nameRecord.getSheetNumber();
            StringBuffer stringBuffer = new StringBuffer();
            if (n5 > 0) {
                String string = internalWorkbook.getSheetName(n5 - 1);
                SheetNameFormatter.appendFormat(stringBuffer, string);
                stringBuffer.append("!");
            }
            stringBuffer.append(nameRecord.getNameText());
            return stringBuffer.toString();
        }
        throw new ArrayIndexOutOfBoundsException("Ext Book Index relative but beyond the supported length, was " + n3 + " but maximum is " + this._externalBookBlocks.length);
    }

    public int resolveNameXIx(int n, int n2) {
        int n3 = this._externSheetRecord.getExtbookIndexFromRefIndex(n);
        return this._externalBookBlocks[n3].getNameIx(n2);
    }

    public NameXPtg getNameXPtg(String string, int n) {
        for (int i = 0; i < this._externalBookBlocks.length; ++i) {
            int n2;
            int n3 = this._externalBookBlocks[i].getIndexOfName(string);
            if (n3 < 0 || (n2 = this.findRefIndexFromExtBookIndex(i)) < 0 || n != -1 && n2 != n) continue;
            return new NameXPtg(n2, n3);
        }
        return null;
    }

    public NameXPtg addNameXPtg(String string) {
        Record record;
        int n;
        int n2 = -1;
        ExternalBookBlock externalBookBlock = null;
        for (n = 0; n < this._externalBookBlocks.length; ++n) {
            SupBookRecord supBookRecord = this._externalBookBlocks[n].getExternalBookRecord();
            if (!supBookRecord.isAddInFunctions()) continue;
            externalBookBlock = this._externalBookBlocks[n];
            n2 = n;
            break;
        }
        if (externalBookBlock == null) {
            externalBookBlock = new ExternalBookBlock();
            n2 = this.extendExternalBookBlocks(externalBookBlock);
            n = this.findFirstRecordLocBySid((short)23);
            this._workbookRecordList.add(n, externalBookBlock.getExternalBookRecord());
            this._externSheetRecord.addRef(this._externalBookBlocks.length - 1, -2, -2);
        }
        ExternalNameRecord externalNameRecord = new ExternalNameRecord();
        externalNameRecord.setText(string);
        externalNameRecord.setParsedExpression(new Ptg[]{ErrPtg.REF_INVALID});
        int n3 = externalBookBlock.addExternalName(externalNameRecord);
        int n4 = 0;
        Iterator<Record> iterator = this._workbookRecordList.iterator();
        while (!(!iterator.hasNext() || (record = iterator.next()) instanceof SupBookRecord && ((SupBookRecord)record).isAddInFunctions())) {
            ++n4;
        }
        int n5 = externalBookBlock.getNumberOfNames();
        this._workbookRecordList.add(n4 + n5, externalNameRecord);
        int n6 = -2;
        int n7 = this._externSheetRecord.getRefIxForSheet(n2, n6, n6);
        return new NameXPtg(n7, n3);
    }

    private int extendExternalBookBlocks(ExternalBookBlock externalBookBlock) {
        ExternalBookBlock[] externalBookBlockArray = new ExternalBookBlock[this._externalBookBlocks.length + 1];
        System.arraycopy(this._externalBookBlocks, 0, externalBookBlockArray, 0, this._externalBookBlocks.length);
        externalBookBlockArray[externalBookBlockArray.length - 1] = externalBookBlock;
        this._externalBookBlocks = externalBookBlockArray;
        return this._externalBookBlocks.length - 1;
    }

    private int findRefIndexFromExtBookIndex(int n) {
        return this._externSheetRecord.findRefIndexFromExtBookIndex(n);
    }

    public boolean changeExternalReference(String string, String string2) {
        for (ExternalBookBlock externalBookBlock : this._externalBookBlocks) {
            SupBookRecord supBookRecord = externalBookBlock.getExternalBookRecord();
            if (!supBookRecord.isExternalReferences() || !supBookRecord.getURL().equals(string)) continue;
            supBookRecord.setURL(string2);
            return true;
        }
        return false;
    }

    private static final class ExternalBookBlock {
        private final SupBookRecord _externalBookRecord;
        private ExternalNameRecord[] _externalNameRecords;
        private final CRNBlock[] _crnBlocks;

        public ExternalBookBlock(RecordStream recordStream) {
            this._externalBookRecord = (SupBookRecord)recordStream.getNext();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (recordStream.peekNextClass() == ExternalNameRecord.class) {
                arrayList.add(recordStream.getNext());
            }
            this._externalNameRecords = new ExternalNameRecord[arrayList.size()];
            arrayList.toArray(this._externalNameRecords);
            arrayList.clear();
            while (recordStream.peekNextClass() == CRNCountRecord.class) {
                arrayList.add(new CRNBlock(recordStream));
            }
            this._crnBlocks = new CRNBlock[arrayList.size()];
            arrayList.toArray(this._crnBlocks);
        }

        public ExternalBookBlock(String string, String[] stringArray) {
            this._externalBookRecord = SupBookRecord.createExternalReferences(string, stringArray);
            this._crnBlocks = new CRNBlock[0];
        }

        public ExternalBookBlock(int n) {
            this._externalBookRecord = SupBookRecord.createInternalReferences((short)n);
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public ExternalBookBlock() {
            this._externalBookRecord = SupBookRecord.createAddInFunctions();
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public SupBookRecord getExternalBookRecord() {
            return this._externalBookRecord;
        }

        public String getNameText(int n) {
            return this._externalNameRecords[n].getText();
        }

        public int getNameIx(int n) {
            return this._externalNameRecords[n].getIx();
        }

        public int getIndexOfName(String string) {
            for (int i = 0; i < this._externalNameRecords.length; ++i) {
                if (!this._externalNameRecords[i].getText().equalsIgnoreCase(string)) continue;
                return i;
            }
            return -1;
        }

        public int getNumberOfNames() {
            return this._externalNameRecords.length;
        }

        public int addExternalName(ExternalNameRecord externalNameRecord) {
            ExternalNameRecord[] externalNameRecordArray = new ExternalNameRecord[this._externalNameRecords.length + 1];
            System.arraycopy(this._externalNameRecords, 0, externalNameRecordArray, 0, this._externalNameRecords.length);
            externalNameRecordArray[externalNameRecordArray.length - 1] = externalNameRecord;
            this._externalNameRecords = externalNameRecordArray;
            return this._externalNameRecords.length - 1;
        }
    }

    private static final class CRNBlock {
        private final CRNCountRecord _countRecord;
        private final CRNRecord[] _crns;

        public CRNBlock(RecordStream recordStream) {
            this._countRecord = (CRNCountRecord)recordStream.getNext();
            int n = this._countRecord.getNumberOfCRNs();
            CRNRecord[] cRNRecordArray = new CRNRecord[n];
            for (int i = 0; i < cRNRecordArray.length; ++i) {
                cRNRecordArray[i] = (CRNRecord)recordStream.getNext();
            }
            this._crns = cRNRecordArray;
        }

        public CRNRecord[] getCrns() {
            return (CRNRecord[])this._crns.clone();
        }
    }
}

