/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.model;

import ai.org.apache.poi.hssf.model.DrawingManager2;
import ai.org.apache.poi.hssf.model.RecordOrderer;
import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.model.RowBlocksReader;
import ai.org.apache.poi.hssf.record.BOFRecord;
import ai.org.apache.poi.hssf.record.CalcCountRecord;
import ai.org.apache.poi.hssf.record.CalcModeRecord;
import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.ColumnInfoRecord;
import ai.org.apache.poi.hssf.record.DefaultColWidthRecord;
import ai.org.apache.poi.hssf.record.DefaultRowHeightRecord;
import ai.org.apache.poi.hssf.record.DeltaRecord;
import ai.org.apache.poi.hssf.record.DimensionsRecord;
import ai.org.apache.poi.hssf.record.DrawingRecord;
import ai.org.apache.poi.hssf.record.EOFRecord;
import ai.org.apache.poi.hssf.record.EscherAggregate;
import ai.org.apache.poi.hssf.record.GridsetRecord;
import ai.org.apache.poi.hssf.record.GutsRecord;
import ai.org.apache.poi.hssf.record.IterationRecord;
import ai.org.apache.poi.hssf.record.NoteRecord;
import ai.org.apache.poi.hssf.record.PaneRecord;
import ai.org.apache.poi.hssf.record.PrintGridlinesRecord;
import ai.org.apache.poi.hssf.record.PrintHeadersRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordBase;
import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RefModeRecord;
import ai.org.apache.poi.hssf.record.RowRecord;
import ai.org.apache.poi.hssf.record.SCLRecord;
import ai.org.apache.poi.hssf.record.SaveRecalcRecord;
import ai.org.apache.poi.hssf.record.SelectionRecord;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.hssf.record.UncalcedRecord;
import ai.org.apache.poi.hssf.record.WSBoolRecord;
import ai.org.apache.poi.hssf.record.WindowTwoRecord;
import ai.org.apache.poi.hssf.record.aggregates.ChartSubstreamRecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import ai.org.apache.poi.hssf.record.aggregates.ConditionalFormattingTable;
import ai.org.apache.poi.hssf.record.aggregates.CustomViewSettingsRecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.DataValidityTable;
import ai.org.apache.poi.hssf.record.aggregates.MergedCellsTable;
import ai.org.apache.poi.hssf.record.aggregates.PageSettingsBlock;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.RowRecordsAggregate;
import ai.org.apache.poi.hssf.record.aggregates.WorksheetProtectionBlock;
import ai.org.apache.poi.hssf.util.PaneInformation;
import ai.org.apache.poi.ss.formula.FormulaShifter;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.util.Internal;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class InternalSheet {
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    private static POILogger log = POILogFactory.getLogger(InternalSheet.class);
    private List<RecordBase> _records;
    protected PrintGridlinesRecord printGridlines = null;
    protected GridsetRecord gridset = null;
    private GutsRecord _gutsRecord;
    protected DefaultColWidthRecord defaultcolwidth = new DefaultColWidthRecord();
    protected DefaultRowHeightRecord defaultrowheight = new DefaultRowHeightRecord();
    private PageSettingsBlock _psBlock;
    private final WorksheetProtectionBlock _protectionBlock = new WorksheetProtectionBlock();
    protected WindowTwoRecord windowTwo = null;
    protected SelectionRecord _selection = null;
    private final MergedCellsTable _mergedCellsTable = new MergedCellsTable();
    ColumnInfoRecordsAggregate _columnInfos;
    private DimensionsRecord _dimensions;
    protected final RowRecordsAggregate _rowsAggregate;
    private DataValidityTable _dataValidityTable = null;
    private ConditionalFormattingTable condFormatting;
    private Iterator<RowRecord> rowRecIterator = null;
    protected boolean _isUncalced = false;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;

    public static InternalSheet createSheet(RecordStream recordStream) {
        return new InternalSheet(recordStream);
    }

    private InternalSheet(RecordStream recordStream) {
        RowRecordsAggregate rowRecordsAggregate = null;
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>(128);
        this._records = arrayList;
        int n = -1;
        if (recordStream.peekNextSid() != 2057) {
            throw new RuntimeException("BOF record expected");
        }
        BOFRecord bOFRecord = (BOFRecord)recordStream.getNext();
        if (bOFRecord.getType() != 16 && bOFRecord.getType() != 32 && bOFRecord.getType() != 64) {
            Record record;
            while (recordStream.hasNext() && !((record = recordStream.getNext()) instanceof EOFRecord)) {
            }
            throw new UnsupportedBOFType(bOFRecord.getType());
        }
        arrayList.add(bOFRecord);
        while (recordStream.hasNext()) {
            Object object;
            int n2 = recordStream.peekNextSid();
            if (n2 == 432) {
                this.condFormatting = new ConditionalFormattingTable(recordStream);
                arrayList.add(this.condFormatting);
                continue;
            }
            if (n2 == 125) {
                this._columnInfos = new ColumnInfoRecordsAggregate(recordStream);
                arrayList.add(this._columnInfos);
                continue;
            }
            if (n2 == 434) {
                this._dataValidityTable = new DataValidityTable(recordStream);
                arrayList.add(this._dataValidityTable);
                continue;
            }
            if (RecordOrderer.isRowBlockRecord(n2)) {
                if (rowRecordsAggregate != null) {
                    throw new RuntimeException("row/cell records found in the wrong place");
                }
                object = new RowBlocksReader(recordStream);
                this._mergedCellsTable.addRecords(((RowBlocksReader)object).getLooseMergedCells());
                rowRecordsAggregate = new RowRecordsAggregate(((RowBlocksReader)object).getPlainRecordStream(), ((RowBlocksReader)object).getSharedFormulaManager());
                arrayList.add(rowRecordsAggregate);
                continue;
            }
            if (CustomViewSettingsRecordAggregate.isBeginRecord(n2)) {
                arrayList.add(new CustomViewSettingsRecordAggregate(recordStream));
                continue;
            }
            if (PageSettingsBlock.isComponentRecord(n2)) {
                if (this._psBlock == null) {
                    this._psBlock = new PageSettingsBlock(recordStream);
                    arrayList.add(this._psBlock);
                } else {
                    this._psBlock.addLateRecords(recordStream);
                }
                this._psBlock.positionRecords(arrayList);
                continue;
            }
            if (WorksheetProtectionBlock.isComponentRecord(n2)) {
                this._protectionBlock.addRecords(recordStream);
                continue;
            }
            if (n2 == 229) {
                this._mergedCellsTable.read(recordStream);
                continue;
            }
            if (n2 == 2057) {
                object = new ChartSubstreamRecordAggregate(recordStream);
                InternalSheet.spillAggregate((RecordAggregate)object, arrayList);
                continue;
            }
            object = recordStream.getNext();
            if (n2 == 523) continue;
            if (n2 == 94) {
                this._isUncalced = true;
                continue;
            }
            if (n2 == 2152 || n2 == 2151) {
                arrayList.add((RecordBase)object);
                continue;
            }
            if (n2 == 10) {
                arrayList.add((RecordBase)object);
                break;
            }
            if (n2 == 512) {
                if (this._columnInfos == null) {
                    this._columnInfos = new ColumnInfoRecordsAggregate();
                    arrayList.add(this._columnInfos);
                }
                this._dimensions = (DimensionsRecord)object;
                n = arrayList.size();
            } else if (n2 == 85) {
                this.defaultcolwidth = (DefaultColWidthRecord)object;
            } else if (n2 == 549) {
                this.defaultrowheight = (DefaultRowHeightRecord)object;
            } else if (n2 == 43) {
                this.printGridlines = (PrintGridlinesRecord)object;
            } else if (n2 == 130) {
                this.gridset = (GridsetRecord)object;
            } else if (n2 == 29) {
                this._selection = (SelectionRecord)object;
            } else if (n2 == 574) {
                this.windowTwo = (WindowTwoRecord)object;
            } else if (n2 == 128) {
                this._gutsRecord = (GutsRecord)object;
            }
            arrayList.add((RecordBase)object);
        }
        if (this.windowTwo == null) {
            throw new RuntimeException("WINDOW2 was not found");
        }
        if (this._dimensions == null) {
            if (rowRecordsAggregate == null) {
                rowRecordsAggregate = new RowRecordsAggregate();
            } else if (log.check(5)) {
                log.log(5, "DIMENSION record not found even though row/cells present");
            }
            n = this.findFirstRecordLocBySid((short)574);
            this._dimensions = rowRecordsAggregate.createDimensions();
            arrayList.add(n, this._dimensions);
        }
        if (rowRecordsAggregate == null) {
            rowRecordsAggregate = new RowRecordsAggregate();
            arrayList.add(n + 1, rowRecordsAggregate);
        }
        this._rowsAggregate = rowRecordsAggregate;
        RecordOrderer.addNewSheetRecord(arrayList, this._mergedCellsTable);
        RecordOrderer.addNewSheetRecord(arrayList, this._protectionBlock);
        if (log.check(1)) {
            log.log(1, "sheet createSheet (existing file) exited");
        }
    }

    private static void spillAggregate(RecordAggregate recordAggregate, final List<RecordBase> list) {
        recordAggregate.visitContainedRecords(new RecordAggregate.RecordVisitor(){

            public void visitRecord(Record record) {
                list.add(record);
            }
        });
    }

    public InternalSheet cloneSheet() {
        ArrayList<Record> arrayList = new ArrayList<Record>(this._records.size());
        for (int i = 0; i < this._records.size(); ++i) {
            RecordBase recordBase = this._records.get(i);
            if (recordBase instanceof RecordAggregate) {
                ((RecordAggregate)recordBase).visitContainedRecords(new RecordCloner(arrayList));
                continue;
            }
            if (recordBase instanceof EscherAggregate) {
                recordBase = new DrawingRecord();
            }
            Record record = (Record)((Record)recordBase).clone();
            arrayList.add(record);
        }
        return InternalSheet.createSheet(new RecordStream(arrayList, 0));
    }

    public static InternalSheet createSheet() {
        return new InternalSheet();
    }

    private InternalSheet() {
        ArrayList<RecordBase> arrayList = new ArrayList<RecordBase>(32);
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch called");
        }
        arrayList.add(InternalSheet.createBOF());
        arrayList.add(InternalSheet.createCalcMode());
        arrayList.add(InternalSheet.createCalcCount());
        arrayList.add(InternalSheet.createRefMode());
        arrayList.add(InternalSheet.createIteration());
        arrayList.add(InternalSheet.createDelta());
        arrayList.add(InternalSheet.createSaveRecalc());
        arrayList.add(InternalSheet.createPrintHeaders());
        this.printGridlines = InternalSheet.createPrintGridlines();
        arrayList.add(this.printGridlines);
        this.gridset = InternalSheet.createGridset();
        arrayList.add(this.gridset);
        this._gutsRecord = InternalSheet.createGuts();
        arrayList.add(this._gutsRecord);
        this.defaultrowheight = InternalSheet.createDefaultRowHeight();
        arrayList.add(this.defaultrowheight);
        arrayList.add(InternalSheet.createWSBool());
        this._psBlock = new PageSettingsBlock();
        arrayList.add(this._psBlock);
        arrayList.add(this._protectionBlock);
        this.defaultcolwidth = InternalSheet.createDefaultColWidth();
        arrayList.add(this.defaultcolwidth);
        ColumnInfoRecordsAggregate columnInfoRecordsAggregate = new ColumnInfoRecordsAggregate();
        arrayList.add(columnInfoRecordsAggregate);
        this._columnInfos = columnInfoRecordsAggregate;
        this._dimensions = InternalSheet.createDimensions();
        arrayList.add(this._dimensions);
        this._rowsAggregate = new RowRecordsAggregate();
        arrayList.add(this._rowsAggregate);
        this.windowTwo = InternalSheet.createWindowTwo();
        arrayList.add(this.windowTwo);
        this._selection = InternalSheet.createSelection();
        arrayList.add(this._selection);
        arrayList.add(this._mergedCellsTable);
        arrayList.add(EOFRecord.instance);
        this._records = arrayList;
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch exit");
        }
    }

    public RowRecordsAggregate getRowsAggregate() {
        return this._rowsAggregate;
    }

    private MergedCellsTable getMergedRecords() {
        return this._mergedCellsTable;
    }

    public void updateFormulasAfterCellShift(FormulaShifter formulaShifter, int n) {
        this.getRowsAggregate().updateFormulasAfterRowShift(formulaShifter, n);
        if (this.condFormatting != null) {
            this.getConditionalFormattingTable().updateFormulasAfterCellShift(formulaShifter, n);
        }
    }

    public int addMergedRegion(int n, int n2, int n3, int n4) {
        if (n3 < n) {
            throw new IllegalArgumentException("The 'to' row (" + n3 + ") must not be less than the 'from' row (" + n + ")");
        }
        if (n4 < n2) {
            throw new IllegalArgumentException("The 'to' col (" + n4 + ") must not be less than the 'from' col (" + n2 + ")");
        }
        MergedCellsTable mergedCellsTable = this.getMergedRecords();
        mergedCellsTable.addArea(n, n2, n3, n4);
        return mergedCellsTable.getNumberOfMergedRegions() - 1;
    }

    public void removeMergedRegion(int n) {
        MergedCellsTable mergedCellsTable = this.getMergedRecords();
        if (n >= mergedCellsTable.getNumberOfMergedRegions()) {
            return;
        }
        mergedCellsTable.remove(n);
    }

    public CellRangeAddress getMergedRegionAt(int n) {
        MergedCellsTable mergedCellsTable = this.getMergedRecords();
        if (n >= mergedCellsTable.getNumberOfMergedRegions()) {
            return null;
        }
        return mergedCellsTable.get(n);
    }

    public int getNumMergedRegions() {
        return this.getMergedRecords().getNumberOfMergedRegions();
    }

    public ConditionalFormattingTable getConditionalFormattingTable() {
        if (this.condFormatting == null) {
            this.condFormatting = new ConditionalFormattingTable();
            RecordOrderer.addNewSheetRecord(this._records, this.condFormatting);
        }
        return this.condFormatting;
    }

    public void setDimensions(int n, short s, int n2, short s2) {
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions");
            log.log(1, new StringBuffer("firstrow").append(n).append("firstcol").append(s).append("lastrow").append(n2).append("lastcol").append(s2).toString());
        }
        this._dimensions.setFirstCol(s);
        this._dimensions.setFirstRow(n);
        this._dimensions.setLastCol(s2);
        this._dimensions.setLastRow(n2);
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions exiting");
        }
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor, int n) {
        RecordAggregate.PositionTrackingVisitor positionTrackingVisitor = new RecordAggregate.PositionTrackingVisitor(recordVisitor, n);
        boolean bl = false;
        for (int i = 0; i < this._records.size(); ++i) {
            RecordBase recordBase = this._records.get(i);
            if (recordBase instanceof RecordAggregate) {
                RecordAggregate recordAggregate = (RecordAggregate)recordBase;
                recordAggregate.visitContainedRecords(positionTrackingVisitor);
            } else {
                positionTrackingVisitor.visitRecord((Record)recordBase);
            }
            if (!(recordBase instanceof BOFRecord) || bl) continue;
            bl = true;
            if (this._isUncalced) {
                positionTrackingVisitor.visitRecord(new UncalcedRecord());
            }
            if (this._rowsAggregate == null) continue;
            int n2 = this.getSizeOfInitialSheetRecords(i);
            int n3 = positionTrackingVisitor.getPosition();
            positionTrackingVisitor.visitRecord(this._rowsAggregate.createIndexRecord(n3, n2));
        }
    }

    private int getSizeOfInitialSheetRecords(int n) {
        RecordBase recordBase;
        int n2 = 0;
        for (int i = n + 1; i < this._records.size() && !((recordBase = this._records.get(i)) instanceof RowRecordsAggregate); ++i) {
            n2 += recordBase.getRecordSize();
        }
        if (this._isUncalced) {
            n2 += UncalcedRecord.getStaticRecordSize();
        }
        return n2;
    }

    public void addValueRecord(int n, CellValueRecordInterface cellValueRecordInterface) {
        if (log.check(1)) {
            log.log(1, "add value record  row" + n);
        }
        DimensionsRecord dimensionsRecord = this._dimensions;
        if (cellValueRecordInterface.getColumn() >= dimensionsRecord.getLastCol()) {
            dimensionsRecord.setLastCol((short)(cellValueRecordInterface.getColumn() + 1));
        }
        if (cellValueRecordInterface.getColumn() < dimensionsRecord.getFirstCol()) {
            dimensionsRecord.setFirstCol(cellValueRecordInterface.getColumn());
        }
        this._rowsAggregate.insertCell(cellValueRecordInterface);
    }

    public void removeValueRecord(int n, CellValueRecordInterface cellValueRecordInterface) {
        log.logFormatted(1, "remove value record row %", new int[]{n});
        this._rowsAggregate.removeCell(cellValueRecordInterface);
    }

    public void replaceValueRecord(CellValueRecordInterface cellValueRecordInterface) {
        if (log.check(1)) {
            log.log(1, "replaceValueRecord ");
        }
        this._rowsAggregate.removeCell(cellValueRecordInterface);
        this._rowsAggregate.insertCell(cellValueRecordInterface);
    }

    public void addRow(RowRecord rowRecord) {
        RowRecord rowRecord2;
        if (log.check(1)) {
            log.log(1, "addRow ");
        }
        DimensionsRecord dimensionsRecord = this._dimensions;
        if (rowRecord.getRowNumber() >= dimensionsRecord.getLastRow()) {
            dimensionsRecord.setLastRow(rowRecord.getRowNumber() + 1);
        }
        if (rowRecord.getRowNumber() < dimensionsRecord.getFirstRow()) {
            dimensionsRecord.setFirstRow(rowRecord.getRowNumber());
        }
        if ((rowRecord2 = this._rowsAggregate.getRow(rowRecord.getRowNumber())) != null) {
            this._rowsAggregate.removeRow(rowRecord2);
        }
        this._rowsAggregate.insertRow(rowRecord);
        if (log.check(1)) {
            log.log(1, "exit addRow");
        }
    }

    public void removeRow(RowRecord rowRecord) {
        this._rowsAggregate.removeRow(rowRecord);
    }

    public Iterator<CellValueRecordInterface> getCellValueIterator() {
        return this._rowsAggregate.getCellValueIterator();
    }

    @Deprecated
    public CellValueRecordInterface[] getValueRecords() {
        return this._rowsAggregate.getValueRecords();
    }

    public RowRecord getNextRow() {
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this._rowsAggregate.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return this.rowRecIterator.next();
    }

    public RowRecord getRow(int n) {
        return this._rowsAggregate.getRow(n);
    }

    static BOFRecord createBOF() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.setVersion(1536);
        bOFRecord.setType(16);
        bOFRecord.setBuild(3515);
        bOFRecord.setBuildYear(1996);
        bOFRecord.setHistoryBitMask(193);
        bOFRecord.setRequiredVersion(6);
        return bOFRecord;
    }

    private static CalcModeRecord createCalcMode() {
        CalcModeRecord calcModeRecord = new CalcModeRecord();
        calcModeRecord.setCalcMode((short)1);
        return calcModeRecord;
    }

    private static CalcCountRecord createCalcCount() {
        CalcCountRecord calcCountRecord = new CalcCountRecord();
        calcCountRecord.setIterations((short)100);
        return calcCountRecord;
    }

    private static RefModeRecord createRefMode() {
        RefModeRecord refModeRecord = new RefModeRecord();
        refModeRecord.setMode((short)1);
        return refModeRecord;
    }

    private static IterationRecord createIteration() {
        return new IterationRecord(false);
    }

    private static DeltaRecord createDelta() {
        return new DeltaRecord(0.001);
    }

    private static SaveRecalcRecord createSaveRecalc() {
        SaveRecalcRecord saveRecalcRecord = new SaveRecalcRecord();
        saveRecalcRecord.setRecalc(true);
        return saveRecalcRecord;
    }

    private static PrintHeadersRecord createPrintHeaders() {
        PrintHeadersRecord printHeadersRecord = new PrintHeadersRecord();
        printHeadersRecord.setPrintHeaders(false);
        return printHeadersRecord;
    }

    private static PrintGridlinesRecord createPrintGridlines() {
        PrintGridlinesRecord printGridlinesRecord = new PrintGridlinesRecord();
        printGridlinesRecord.setPrintGridlines(false);
        return printGridlinesRecord;
    }

    private static GridsetRecord createGridset() {
        GridsetRecord gridsetRecord = new GridsetRecord();
        gridsetRecord.setGridset(true);
        return gridsetRecord;
    }

    private static GutsRecord createGuts() {
        GutsRecord gutsRecord = new GutsRecord();
        gutsRecord.setLeftRowGutter((short)0);
        gutsRecord.setTopColGutter((short)0);
        gutsRecord.setRowLevelMax((short)0);
        gutsRecord.setColLevelMax((short)0);
        return gutsRecord;
    }

    private GutsRecord getGutsRecord() {
        if (this._gutsRecord == null) {
            GutsRecord gutsRecord = InternalSheet.createGuts();
            RecordOrderer.addNewSheetRecord(this._records, gutsRecord);
            this._gutsRecord = gutsRecord;
        }
        return this._gutsRecord;
    }

    private static DefaultRowHeightRecord createDefaultRowHeight() {
        DefaultRowHeightRecord defaultRowHeightRecord = new DefaultRowHeightRecord();
        defaultRowHeightRecord.setOptionFlags((short)0);
        defaultRowHeightRecord.setRowHeight((short)255);
        return defaultRowHeightRecord;
    }

    private static WSBoolRecord createWSBool() {
        WSBoolRecord wSBoolRecord = new WSBoolRecord();
        wSBoolRecord.setWSBool1((byte)4);
        wSBoolRecord.setWSBool2((byte)-63);
        return wSBoolRecord;
    }

    private static DefaultColWidthRecord createDefaultColWidth() {
        DefaultColWidthRecord defaultColWidthRecord = new DefaultColWidthRecord();
        defaultColWidthRecord.setColWidth(8);
        return defaultColWidthRecord;
    }

    public int getDefaultColumnWidth() {
        return this.defaultcolwidth.getColWidth();
    }

    public boolean isGridsPrinted() {
        if (this.gridset == null) {
            this.gridset = InternalSheet.createGridset();
            int n = this.findFirstRecordLocBySid((short)10);
            this._records.add(n, this.gridset);
        }
        return !this.gridset.getGridset();
    }

    public void setGridsPrinted(boolean bl) {
        this.gridset.setGridset(!bl);
    }

    public void setDefaultColumnWidth(int n) {
        this.defaultcolwidth.setColWidth(n);
    }

    public void setDefaultRowHeight(short s) {
        this.defaultrowheight.setRowHeight(s);
        this.defaultrowheight.setOptionFlags((short)1);
    }

    public short getDefaultRowHeight() {
        return this.defaultrowheight.getRowHeight();
    }

    public int getColumnWidth(int n) {
        ColumnInfoRecord columnInfoRecord = this._columnInfos.findColumnInfo(n);
        if (columnInfoRecord != null) {
            return columnInfoRecord.getColumnWidth();
        }
        return 256 * this.defaultcolwidth.getColWidth();
    }

    public short getXFIndexForColAt(short s) {
        ColumnInfoRecord columnInfoRecord = this._columnInfos.findColumnInfo(s);
        if (columnInfoRecord != null) {
            return (short)columnInfoRecord.getXFIndex();
        }
        return 15;
    }

    public void setColumnWidth(int n, int n2) {
        if (n2 > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.setColumn(n, null, n2, null, null, null);
    }

    public boolean isColumnHidden(int n) {
        ColumnInfoRecord columnInfoRecord = this._columnInfos.findColumnInfo(n);
        if (columnInfoRecord == null) {
            return false;
        }
        return columnInfoRecord.getHidden();
    }

    public void setColumnHidden(int n, boolean bl) {
        this.setColumn(n, null, null, null, bl, null);
    }

    public void setDefaultColumnStyle(int n, int n2) {
        this.setColumn(n, (short)n2, null, null, null, null);
    }

    private void setColumn(int n, Short s, Integer n2, Integer n3, Boolean bl, Boolean bl2) {
        this._columnInfos.setColumn(n, s, n2, n3, bl, bl2);
    }

    public void groupColumnRange(int n, int n2, boolean bl) {
        this._columnInfos.groupColumnRange(n, n2, bl);
        int n3 = this._columnInfos.getMaxOutlineLevel();
        GutsRecord gutsRecord = this.getGutsRecord();
        gutsRecord.setColLevelMax((short)(n3 + 1));
        if (n3 == 0) {
            gutsRecord.setTopColGutter((short)0);
        } else {
            gutsRecord.setTopColGutter((short)(29 + 12 * (n3 - 1)));
        }
    }

    private static DimensionsRecord createDimensions() {
        DimensionsRecord dimensionsRecord = new DimensionsRecord();
        dimensionsRecord.setFirstCol((short)0);
        dimensionsRecord.setLastRow(1);
        dimensionsRecord.setFirstRow(0);
        dimensionsRecord.setLastCol((short)1);
        return dimensionsRecord;
    }

    private static WindowTwoRecord createWindowTwo() {
        WindowTwoRecord windowTwoRecord = new WindowTwoRecord();
        windowTwoRecord.setOptions((short)1718);
        windowTwoRecord.setTopRow((short)0);
        windowTwoRecord.setLeftCol((short)0);
        windowTwoRecord.setHeaderColor(64);
        windowTwoRecord.setPageBreakZoom((short)0);
        windowTwoRecord.setNormalZoom((short)0);
        return windowTwoRecord;
    }

    private static SelectionRecord createSelection() {
        return new SelectionRecord(0, 0);
    }

    public short getTopRow() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getTopRow();
    }

    public void setTopRow(short s) {
        if (this.windowTwo != null) {
            this.windowTwo.setTopRow(s);
        }
    }

    public void setLeftCol(short s) {
        if (this.windowTwo != null) {
            this.windowTwo.setLeftCol(s);
        }
    }

    public short getLeftCol() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getLeftCol();
    }

    public int getActiveCellRow() {
        if (this._selection == null) {
            return 0;
        }
        return this._selection.getActiveCellRow();
    }

    public void setActiveCellRow(int n) {
        if (this._selection != null) {
            this._selection.setActiveCellRow(n);
        }
    }

    public short getActiveCellCol() {
        if (this._selection == null) {
            return 0;
        }
        return (short)this._selection.getActiveCellCol();
    }

    public void setActiveCellCol(short s) {
        if (this._selection != null) {
            this._selection.setActiveCellCol(s);
        }
    }

    public List<RecordBase> getRecords() {
        return this._records;
    }

    public GridsetRecord getGridsetRecord() {
        return this.gridset;
    }

    public Record findFirstRecordBySid(short s) {
        int n = this.findFirstRecordLocBySid(s);
        if (n < 0) {
            return null;
        }
        return (Record)this._records.get(n);
    }

    public void setSCLRecord(SCLRecord sCLRecord) {
        int n = this.findFirstRecordLocBySid((short)160);
        if (n == -1) {
            int n2 = this.findFirstRecordLocBySid((short)574);
            this._records.add(n2 + 1, sCLRecord);
        } else {
            this._records.set(n, sCLRecord);
        }
    }

    public int findFirstRecordLocBySid(short s) {
        int n = this._records.size();
        for (int i = 0; i < n; ++i) {
            Record record;
            RecordBase recordBase = this._records.get(i);
            if (!(recordBase instanceof Record) || (record = (Record)recordBase).getSid() != s) continue;
            return i;
        }
        return -1;
    }

    public WindowTwoRecord getWindowTwo() {
        return this.windowTwo;
    }

    public PrintGridlinesRecord getPrintGridlines() {
        return this.printGridlines;
    }

    public void setPrintGridlines(PrintGridlinesRecord printGridlinesRecord) {
        this.printGridlines = printGridlinesRecord;
    }

    public void setSelected(boolean bl) {
        this.windowTwo.setSelected(bl);
    }

    public void createFreezePane(int n, int n2, int n3, int n4) {
        int n5 = this.findFirstRecordLocBySid((short)65);
        if (n5 != -1) {
            this._records.remove(n5);
        }
        if (n == 0 && n2 == 0) {
            this.windowTwo.setFreezePanes(false);
            this.windowTwo.setFreezePanesNoSplit(false);
            SelectionRecord selectionRecord = (SelectionRecord)this.findFirstRecordBySid((short)29);
            selectionRecord.setPane((byte)3);
            return;
        }
        int n6 = this.findFirstRecordLocBySid((short)574);
        PaneRecord paneRecord = new PaneRecord();
        paneRecord.setX((short)n);
        paneRecord.setY((short)n2);
        paneRecord.setTopRow((short)n3);
        paneRecord.setLeftColumn((short)n4);
        if (n2 == 0) {
            paneRecord.setTopRow((short)0);
            paneRecord.setActivePane((short)1);
        } else if (n == 0) {
            paneRecord.setLeftColumn((short)0);
            paneRecord.setActivePane((short)2);
        } else {
            paneRecord.setActivePane((short)0);
        }
        this._records.add(n6 + 1, paneRecord);
        this.windowTwo.setFreezePanes(true);
        this.windowTwo.setFreezePanesNoSplit(true);
        SelectionRecord selectionRecord = (SelectionRecord)this.findFirstRecordBySid((short)29);
        selectionRecord.setPane((byte)paneRecord.getActivePane());
    }

    public void createSplitPane(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.findFirstRecordLocBySid((short)65);
        if (n6 != -1) {
            this._records.remove(n6);
        }
        int n7 = this.findFirstRecordLocBySid((short)574);
        PaneRecord paneRecord = new PaneRecord();
        paneRecord.setX((short)n);
        paneRecord.setY((short)n2);
        paneRecord.setTopRow((short)n3);
        paneRecord.setLeftColumn((short)n4);
        paneRecord.setActivePane((short)n5);
        this._records.add(n7 + 1, paneRecord);
        this.windowTwo.setFreezePanes(false);
        this.windowTwo.setFreezePanesNoSplit(false);
        SelectionRecord selectionRecord = (SelectionRecord)this.findFirstRecordBySid((short)29);
        selectionRecord.setPane((byte)0);
    }

    public PaneInformation getPaneInformation() {
        PaneRecord paneRecord = (PaneRecord)this.findFirstRecordBySid((short)65);
        if (paneRecord == null) {
            return null;
        }
        return new PaneInformation(paneRecord.getX(), paneRecord.getY(), paneRecord.getTopRow(), paneRecord.getLeftColumn(), (byte)paneRecord.getActivePane(), this.windowTwo.getFreezePanes());
    }

    public SelectionRecord getSelection() {
        return this._selection;
    }

    public void setSelection(SelectionRecord selectionRecord) {
        this._selection = selectionRecord;
    }

    public WorksheetProtectionBlock getProtectionBlock() {
        return this._protectionBlock;
    }

    public void setDisplayGridlines(boolean bl) {
        this.windowTwo.setDisplayGridlines(bl);
    }

    public boolean isDisplayGridlines() {
        return this.windowTwo.getDisplayGridlines();
    }

    public void setDisplayFormulas(boolean bl) {
        this.windowTwo.setDisplayFormulas(bl);
    }

    public boolean isDisplayFormulas() {
        return this.windowTwo.getDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean bl) {
        this.windowTwo.setDisplayRowColHeadings(bl);
    }

    public boolean isDisplayRowColHeadings() {
        return this.windowTwo.getDisplayRowColHeadings();
    }

    public boolean getUncalced() {
        return this._isUncalced;
    }

    public void setUncalced(boolean bl) {
        this._isUncalced = bl;
    }

    public int aggregateDrawingRecords(DrawingManager2 drawingManager2, boolean bl) {
        boolean bl2;
        int n = this.findFirstRecordLocBySid((short)236);
        boolean bl3 = bl2 = n == -1;
        if (bl2) {
            if (!bl) {
                return -1;
            }
            EscherAggregate escherAggregate = new EscherAggregate(true);
            n = this.findFirstRecordLocBySid((short)9876);
            if (n == -1) {
                n = this.findFirstRecordLocBySid((short)574);
            } else {
                this.getRecords().remove(n);
            }
            this.getRecords().add(n, escherAggregate);
            return n;
        }
        List<RecordBase> list = this.getRecords();
        EscherAggregate.createAggregate(list, n);
        return n;
    }

    public void preSerialize() {
        for (RecordBase recordBase : this.getRecords()) {
            if (!(recordBase instanceof EscherAggregate)) continue;
            recordBase.getRecordSize();
        }
    }

    public PageSettingsBlock getPageSettings() {
        if (this._psBlock == null) {
            this._psBlock = new PageSettingsBlock();
            RecordOrderer.addNewSheetRecord(this._records, this._psBlock);
        }
        return this._psBlock;
    }

    public void setColumnGroupCollapsed(int n, boolean bl) {
        if (bl) {
            this._columnInfos.collapseColumn(n);
        } else {
            this._columnInfos.expandColumn(n);
        }
    }

    public void groupRowRange(int n, int n2, boolean bl) {
        for (int i = n; i <= n2; ++i) {
            RowRecord rowRecord = this.getRow(i);
            if (rowRecord == null) {
                rowRecord = RowRecordsAggregate.createRow(i);
                this.addRow(rowRecord);
            }
            int n3 = rowRecord.getOutlineLevel();
            n3 = bl ? ++n3 : --n3;
            n3 = Math.max(0, n3);
            n3 = Math.min(7, n3);
            rowRecord.setOutlineLevel((short)n3);
        }
        this.recalcRowGutter();
    }

    private void recalcRowGutter() {
        StandardRecord standardRecord;
        int n = 0;
        Iterator<RowRecord> iterator = this._rowsAggregate.getIterator();
        while (iterator.hasNext()) {
            standardRecord = iterator.next();
            n = Math.max(((RowRecord)standardRecord).getOutlineLevel(), n);
        }
        standardRecord = this.getGutsRecord();
        ((GutsRecord)standardRecord).setRowLevelMax((short)(n + 1));
        ((GutsRecord)standardRecord).setLeftRowGutter((short)(29 + 12 * n));
    }

    public DataValidityTable getOrCreateDataValidityTable() {
        if (this._dataValidityTable == null) {
            DataValidityTable dataValidityTable = new DataValidityTable();
            RecordOrderer.addNewSheetRecord(this._records, dataValidityTable);
            this._dataValidityTable = dataValidityTable;
        }
        return this._dataValidityTable;
    }

    public NoteRecord[] getNoteRecords() {
        ArrayList<NoteRecord> arrayList = new ArrayList<NoteRecord>();
        for (int i = this._records.size() - 1; i >= 0; --i) {
            RecordBase recordBase = this._records.get(i);
            if (!(recordBase instanceof NoteRecord)) continue;
            arrayList.add((NoteRecord)recordBase);
        }
        if (arrayList.size() < 1) {
            return NoteRecord.EMPTY_ARRAY;
        }
        NoteRecord[] noteRecordArray = new NoteRecord[arrayList.size()];
        arrayList.toArray(noteRecordArray);
        return noteRecordArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RecordCloner
    implements RecordAggregate.RecordVisitor {
        private final List<Record> _destList;

        public RecordCloner(List<Record> list) {
            this._destList = list;
        }

        @Override
        public void visitRecord(Record record) {
            this._destList.add((Record)record.clone());
        }
    }

    public static class UnsupportedBOFType
    extends RecordFormatException {
        private final int type;

        protected UnsupportedBOFType(int n) {
            super("BOF not of a supported type, found " + n);
            this.type = n;
        }

        public int getType() {
            return this.type;
        }
    }
}

