/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.extractor;

import ai.org.apache.poi.POIDocument;
import ai.org.apache.poi.POIOLE2TextExtractor;
import ai.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai.org.apache.poi.hpsf.SummaryInformation;
import ai.org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import ai.org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import ai.org.apache.poi.hssf.eventusermodel.HSSFListener;
import ai.org.apache.poi.hssf.eventusermodel.HSSFRequest;
import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.record.BOFRecord;
import ai.org.apache.poi.hssf.record.BoundSheetRecord;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.LabelRecord;
import ai.org.apache.poi.hssf.record.LabelSSTRecord;
import ai.org.apache.poi.hssf.record.NoteRecord;
import ai.org.apache.poi.hssf.record.NumberRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.SSTRecord;
import ai.org.apache.poi.hssf.record.StringRecord;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.ss.extractor.ExcelExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EventBasedExcelExtractor
extends POIOLE2TextExtractor
implements ExcelExtractor {
    private DirectoryNode _dir;
    boolean _includeSheetNames = true;
    boolean _formulasNotResults = false;

    @Deprecated
    public EventBasedExcelExtractor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) {
        this(directoryNode);
    }

    public EventBasedExcelExtractor(DirectoryNode directoryNode) {
        super((POIDocument)null);
        this._dir = directoryNode;
    }

    public EventBasedExcelExtractor(POIFSFileSystem pOIFSFileSystem) {
        this(pOIFSFileSystem.getRoot());
    }

    public POIFSFileSystem getFileSystem() {
        return this._dir.getFileSystem();
    }

    public DocumentSummaryInformation getDocSummaryInformation() {
        throw new IllegalStateException("Metadata extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public SummaryInformation getSummaryInformation() {
        throw new IllegalStateException("Metadata extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public void setIncludeCellComments(boolean bl) {
        throw new IllegalStateException("Comment extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public void setIncludeHeadersFooters(boolean bl) {
        throw new IllegalStateException("Header/Footer extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public void setIncludeSheetNames(boolean bl) {
        this._includeSheetNames = bl;
    }

    public void setFormulasNotResults(boolean bl) {
        this._formulasNotResults = bl;
    }

    public String getText() {
        String string = null;
        try {
            TextListener textListener = this.triggerExtraction();
            string = textListener._text.toString();
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return string;
    }

    private TextListener triggerExtraction() throws IOException {
        FormatTrackingHSSFListener formatTrackingHSSFListener;
        TextListener textListener = new TextListener();
        textListener._ft = formatTrackingHSSFListener = new FormatTrackingHSSFListener(textListener);
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords(formatTrackingHSSFListener);
        hSSFEventFactory.processWorkbookEvents(hSSFRequest, this._dir);
        return textListener;
    }

    private class TextListener
    implements HSSFListener {
        FormatTrackingHSSFListener _ft;
        private SSTRecord sstRecord;
        private final List<String> sheetNames;
        final StringBuffer _text = new StringBuffer();
        private int sheetNum = -1;
        private int rowNum;
        private boolean outputNextStringValue = false;
        private int nextRow = -1;

        public TextListener() {
            this.sheetNames = new ArrayList<String>();
        }

        public void processRecord(Record record) {
            String string = null;
            int n = -1;
            switch (record.getSid()) {
                case 133: {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    this.sheetNames.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 2057: {
                    BOFRecord bOFRecord = (BOFRecord)record;
                    if (bOFRecord.getType() != 16) break;
                    ++this.sheetNum;
                    this.rowNum = -1;
                    if (!EventBasedExcelExtractor.this._includeSheetNames) break;
                    if (this._text.length() > 0) {
                        this._text.append("\n");
                    }
                    this._text.append(this.sheetNames.get(this.sheetNum));
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 6: {
                    FormulaRecord formulaRecord = (FormulaRecord)record;
                    n = formulaRecord.getRow();
                    if (EventBasedExcelExtractor.this._formulasNotResults) {
                        string = HSSFFormulaParser.toFormulaString(null, formulaRecord.getParsedExpression());
                        break;
                    }
                    if (formulaRecord.hasCachedResultString()) {
                        this.outputNextStringValue = true;
                        this.nextRow = formulaRecord.getRow();
                        break;
                    }
                    string = this._ft.formatNumberDateCell(formulaRecord);
                    break;
                }
                case 519: {
                    if (!this.outputNextStringValue) break;
                    StringRecord stringRecord = (StringRecord)record;
                    string = stringRecord.getString();
                    n = this.nextRow;
                    this.outputNextStringValue = false;
                    break;
                }
                case 516: {
                    LabelRecord labelRecord = (LabelRecord)record;
                    n = labelRecord.getRow();
                    string = labelRecord.getValue();
                    break;
                }
                case 253: {
                    LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                    n = labelSSTRecord.getRow();
                    if (this.sstRecord == null) {
                        throw new IllegalStateException("No SST record found");
                    }
                    string = this.sstRecord.getString(labelSSTRecord.getSSTIndex()).toString();
                    break;
                }
                case 28: {
                    NoteRecord noteRecord = (NoteRecord)record;
                    n = noteRecord.getRow();
                    break;
                }
                case 515: {
                    NumberRecord numberRecord = (NumberRecord)record;
                    n = numberRecord.getRow();
                    string = this._ft.formatNumberDateCell(numberRecord);
                    break;
                }
            }
            if (string != null) {
                if (n != this.rowNum) {
                    this.rowNum = n;
                    if (this._text.length() > 0) {
                        this._text.append("\n");
                    }
                } else {
                    this._text.append("\t");
                }
                this._text.append(string);
            }
        }
    }
}

