/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.eventusermodel;

import ai.org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import ai.org.apache.poi.hssf.eventusermodel.HSSFListener;
import ai.org.apache.poi.hssf.eventusermodel.HSSFUserException;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HSSFRequest {
    private final Map<Short, List<HSSFListener>> _records = new HashMap<Short, List<HSSFListener>>(50);

    public void addListener(HSSFListener hSSFListener, short s) {
        List<HSSFListener> list = this._records.get(s);
        if (list == null) {
            list = new ArrayList<HSSFListener>(1);
            this._records.put(s, list);
        }
        list.add(hSSFListener);
    }

    public void addListenerForAllRecords(HSSFListener hSSFListener) {
        short[] sArray = RecordFactory.getAllKnownRecordSIDs();
        for (int i = 0; i < sArray.length; ++i) {
            this.addListener(hSSFListener, sArray[i]);
        }
    }

    protected short processRecord(Record record) throws HSSFUserException {
        List<HSSFListener> list = this._records.get(record.getSid());
        short s = 0;
        if (list != null) {
            List<HSSFListener> list2 = list;
            for (int i = 0; i < list2.size(); ++i) {
                HSSFListener hSSFListener;
                HSSFListener hSSFListener2 = list2.get(i);
                if (hSSFListener2 instanceof AbortableHSSFListener) {
                    hSSFListener = (AbortableHSSFListener)hSSFListener2;
                    s = ((AbortableHSSFListener)hSSFListener).abortableProcessRecord(record);
                    if (s == 0) continue;
                    break;
                }
                hSSFListener = hSSFListener2;
                hSSFListener.processRecord(record);
            }
        }
        return s;
    }
}

