/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.dev;

import ai.org.apache.poi.hssf.dev.BiffViewer;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordFactory;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class RecordLister {
    String file;

    public void run() throws IOException {
        InputStream inputStream = BiffViewer.getPOIFSInputStream(new File(this.file));
        RecordInputStream recordInputStream = new RecordInputStream(inputStream);
        while (recordInputStream.hasNextRecord()) {
            int n = recordInputStream.getNextSid();
            recordInputStream.nextRecord();
            int n2 = recordInputStream.available();
            Class<? extends Record> clazz = RecordFactory.getRecordClass(n);
            System.out.print(RecordLister.formatSID(n) + " - " + RecordLister.formatSize(n2) + " bytes");
            if (clazz != null) {
                System.out.print("  \t");
                System.out.print(clazz.getName().replace("ai.org.apache.poi.hssf.record.", ""));
            }
            System.out.println();
            byte[] byArray = recordInputStream.readRemainder();
            if (byArray.length <= 0) continue;
            System.out.print("   ");
            System.out.println(RecordLister.formatData(byArray));
        }
    }

    private static String formatSID(int n) {
        int n2;
        String string = Integer.toHexString(n);
        String string2 = Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        for (n2 = string.length(); n2 < 4; ++n2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append(" (");
        for (n2 = string2.length(); n2 < 4; ++n2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String formatSize(int n) {
        int n2;
        String string = Integer.toHexString(n);
        String string2 = Integer.toString(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = string.length(); n2 < 3; ++n2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append(" (");
        for (n2 = string2.length(); n2 < 3; ++n2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String formatData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length > 9) {
            stringBuffer.append(RecordLister.byteToHex(byArray[0]));
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[1]));
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[2]));
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[3]));
            stringBuffer.append(' ');
            stringBuffer.append(" .... ");
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[byArray.length - 4]));
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[byArray.length - 3]));
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[byArray.length - 2]));
            stringBuffer.append(' ');
            stringBuffer.append(RecordLister.byteToHex(byArray[byArray.length - 1]));
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(RecordLister.byteToHex(byArray[i]));
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    private static String byteToHex(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = Integer.toHexString(n2);
        if (n2 < 16) {
            return "0" + string;
        }
        return string;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 && !stringArray[0].equals("--help")) {
            try {
                RecordLister recordLister = new RecordLister();
                recordLister.setFile(stringArray[0]);
                recordLister.run();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("RecordLister");
            System.out.println("Outputs the summary of the records in file order");
            System.out.println("usage: java ai.org.apache.poi.hssf.dev.RecordLister filename");
        }
    }
}

