/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.dev;

import ai.org.apache.poi.hssf.dev.BiffViewer;
import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordFactory;
import ai.org.apache.poi.ss.formula.ptg.ExpPtg;
import ai.org.apache.poi.ss.formula.ptg.FuncPtg;
import ai.org.apache.poi.ss.formula.ptg.OperationPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import java.io.File;
import java.util.List;

public class FormulaViewer {
    private String file;
    private boolean list = false;

    public void run() throws Exception {
        List<Record> list = RecordFactory.createRecords(BiffViewer.getPOIFSInputStream(new File(this.file)));
        for (int i = 0; i < list.size(); ++i) {
            Record record = list.get(i);
            if (record.getSid() != 6) continue;
            if (this.list) {
                this.listFormula((FormulaRecord)record);
                continue;
            }
            this.parseFormulaRecord((FormulaRecord)record);
        }
    }

    private void listFormula(FormulaRecord formulaRecord) {
        int n;
        String string = "~";
        Ptg[] ptgArray = formulaRecord.getParsedExpression();
        Ptg ptg = ptgArray[(n = ptgArray.length) - 1];
        String string2 = ptg instanceof FuncPtg ? String.valueOf(n - 1) : String.valueOf(-1);
        StringBuffer stringBuffer = new StringBuffer();
        if (ptg instanceof ExpPtg) {
            return;
        }
        stringBuffer.append(((OperationPtg)ptg).toFormulaString());
        stringBuffer.append(string);
        switch (ptg.getPtgClass()) {
            case 0: {
                stringBuffer.append("REF");
                break;
            }
            case 32: {
                stringBuffer.append("VALUE");
                break;
            }
            case 64: {
                stringBuffer.append("ARRAY");
            }
        }
        stringBuffer.append(string);
        if (n > 1) {
            ptg = ptgArray[n - 2];
            switch (ptg.getPtgClass()) {
                case 0: {
                    stringBuffer.append("REF");
                    break;
                }
                case 32: {
                    stringBuffer.append("VALUE");
                    break;
                }
                case 64: {
                    stringBuffer.append("ARRAY");
                }
            }
        } else {
            stringBuffer.append("VALUE");
        }
        stringBuffer.append(string);
        stringBuffer.append(string2);
        System.out.println(stringBuffer.toString());
    }

    public void parseFormulaRecord(FormulaRecord formulaRecord) {
        System.out.println("==============================");
        System.out.print("row = " + formulaRecord.getRow());
        System.out.println(", col = " + formulaRecord.getColumn());
        System.out.println("value = " + formulaRecord.getValue());
        System.out.print("xf = " + formulaRecord.getXFIndex());
        System.out.print(", number of ptgs = " + formulaRecord.getParsedExpression().length);
        System.out.println(", options = " + formulaRecord.getOptions());
        System.out.println("RPN List = " + this.formulaString(formulaRecord));
        System.out.println("Formula text = " + FormulaViewer.composeFormula(formulaRecord));
    }

    private String formulaString(FormulaRecord formulaRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        Ptg[] ptgArray = formulaRecord.getParsedExpression();
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            stringBuffer.append(ptg.toFormulaString());
            switch (ptg.getPtgClass()) {
                case 0: {
                    stringBuffer.append("(R)");
                    break;
                }
                case 32: {
                    stringBuffer.append("(V)");
                    break;
                }
                case 64: {
                    stringBuffer.append("(A)");
                }
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String composeFormula(FormulaRecord formulaRecord) {
        return HSSFFormulaParser.toFormulaString(null, formulaRecord.getParsedExpression());
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setList(boolean bl) {
        this.list = bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length > 2 || stringArray[0].equals("--help")) {
            System.out.println("FormulaViewer .8 proof that the devil lies in the details (or just in BIFF8 files in general)");
            System.out.println("usage: Give me a big fat file name");
        } else if (stringArray[0].equals("--listFunctions")) {
            try {
                FormulaViewer formulaViewer = new FormulaViewer();
                formulaViewer.setFile(stringArray[1]);
                formulaViewer.setList(true);
                formulaViewer.run();
            }
            catch (Exception exception) {
                System.out.println("Whoops!");
                exception.printStackTrace();
            }
        } else {
            try {
                FormulaViewer formulaViewer = new FormulaViewer();
                formulaViewer.setFile(stringArray[0]);
                formulaViewer.run();
            }
            catch (Exception exception) {
                System.out.println("Whoops!");
                exception.printStackTrace();
            }
        }
    }
}

