/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.dev;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.DrawingGroupRecord;
import ai.org.apache.poi.hssf.record.EscherAggregate;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiffDrawingToXml {
    private static final String SHEET_NAME_PARAM = "-sheet-name";
    private static final String SHEET_INDEXES_PARAM = "-sheet-indexes";
    private static final String EXCLUDE_WORKBOOK_RECORDS = "-exclude-workbook";

    private static int getAttributeIndex(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isExcludeWorkbookRecords(String[] stringArray) {
        return -1 != BiffDrawingToXml.getAttributeIndex(EXCLUDE_WORKBOOK_RECORDS, stringArray);
    }

    private static List<Integer> getIndexesByName(String[] stringArray, HSSFWorkbook hSSFWorkbook) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = BiffDrawingToXml.getAttributeIndex(SHEET_NAME_PARAM, stringArray);
        if (-1 != n) {
            if (n >= stringArray.length) {
                throw new IllegalArgumentException("sheet name param value was not specified");
            }
            String string = stringArray[n + 1];
            int n2 = hSSFWorkbook.getSheetIndex(string);
            if (-1 == n2) {
                throw new IllegalArgumentException("specified sheet name has not been found in xls file");
            }
            arrayList.add(n2);
        }
        return arrayList;
    }

    private static List<Integer> getIndexesByIdArray(String[] stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = BiffDrawingToXml.getAttributeIndex(SHEET_INDEXES_PARAM, stringArray);
        if (-1 != n) {
            String[] stringArray2;
            if (n >= stringArray.length) {
                throw new IllegalArgumentException("sheet list value was not specified");
            }
            String string = stringArray[n + 1];
            for (String string2 : stringArray2 = string.split(",")) {
                arrayList.add(Integer.parseInt(string2));
            }
        }
        return arrayList;
    }

    private static List<Integer> getSheetsIndexes(String[] stringArray, HSSFWorkbook hSSFWorkbook) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(BiffDrawingToXml.getIndexesByIdArray(stringArray));
        arrayList.addAll(BiffDrawingToXml.getIndexesByName(stringArray, hSSFWorkbook));
        if (0 == arrayList.size()) {
            int n = hSSFWorkbook.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                arrayList.add(i);
            }
        }
        return arrayList;
    }

    private static String getInputFileName(String[] stringArray) {
        return stringArray[stringArray.length - 1];
    }

    private static String getOutputFileName(String string) {
        if (string.contains("xls")) {
            return string.replace(".xls", ".xml");
        }
        return string + ".xml";
    }

    public static void main(String[] stringArray) throws IOException {
        if (0 == stringArray.length) {
            System.out.println("Usage: BiffDrawingToXml [options] inputWorkbook");
            System.out.println("Options:");
            System.out.println("  -exclude-workbook            exclude workbook-level records");
            System.out.println("  -sheet-indexes   <indexes>   output sheets with specified indexes");
            System.out.println("  -sheet-namek  <names>        output sheets with specified name");
            return;
        }
        String string = BiffDrawingToXml.getInputFileName(stringArray);
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = BiffDrawingToXml.getOutputFileName(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        BiffDrawingToXml.writeToFile(fileOutputStream, fileInputStream, BiffDrawingToXml.isExcludeWorkbookRecords(stringArray), stringArray);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void writeToFile(OutputStream outputStream, InputStream inputStream, boolean bl, String[] stringArray) throws IOException {
        List<Object> list;
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(inputStream);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
        InternalWorkbook internalWorkbook = BiffDrawingToXml.getInternalWorkbook(hSSFWorkbook);
        DrawingGroupRecord drawingGroupRecord = (DrawingGroupRecord)internalWorkbook.findFirstRecordBySid((short)235);
        drawingGroupRecord.decode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<workbook>\n");
        String string = "\t";
        if (!bl) {
            list = drawingGroupRecord.getEscherRecords();
            for (Object object : list) {
                stringBuilder.append(((EscherRecord)object).toXml(string));
            }
        }
        list = BiffDrawingToXml.getSheetsIndexes(stringArray, hSSFWorkbook);
        for (Object object : list) {
            HSSFPatriarch hSSFPatriarch = hSSFWorkbook.getSheetAt((Integer)object).getDrawingPatriarch();
            if (hSSFPatriarch == null) continue;
            stringBuilder.append(string).append("<sheet").append(object).append(">\n");
            stringBuilder.append(BiffDrawingToXml.getHSSFPatriarchBoundAggregate(hSSFPatriarch).toXml(string + "\t"));
            stringBuilder.append(string).append("</sheet").append(object).append(">\n");
        }
        stringBuilder.append("</workbook>\n");
        outputStream.write(stringBuilder.toString().getBytes());
        outputStream.close();
    }

    private static EscherAggregate getHSSFPatriarchBoundAggregate(HSSFPatriarch hSSFPatriarch) {
        Field field = null;
        try {
            field = hSSFPatriarch.getClass().getDeclaredField("_boundAggregate");
            field.setAccessible(true);
            return (EscherAggregate)field.get(hSSFPatriarch);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    private static InternalWorkbook getInternalWorkbook(HSSFWorkbook hSSFWorkbook) {
        Field field = null;
        try {
            field = hSSFWorkbook.getClass().getDeclaredField("workbook");
            field.setAccessible(true);
            return (InternalWorkbook)field.get(hSSFWorkbook);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }
}

