/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf.extractor;

import ai.org.apache.poi.POIDocument;
import ai.org.apache.poi.POITextExtractor;
import ai.org.apache.poi.hpsf.CustomProperties;
import ai.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai.org.apache.poi.hpsf.HPSFPropertiesOnlyDocument;
import ai.org.apache.poi.hpsf.MutablePropertySet;
import ai.org.apache.poi.hpsf.Property;
import ai.org.apache.poi.hpsf.SpecialPropertySet;
import ai.org.apache.poi.hpsf.SummaryInformation;
import ai.org.apache.poi.hpsf.wellknown.PropertyIDMap;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.File;
import java.io.IOException;

public class HPSFPropertiesExtractor
extends POITextExtractor {
    public HPSFPropertiesExtractor(POITextExtractor pOITextExtractor) {
        super(pOITextExtractor);
    }

    public HPSFPropertiesExtractor(POIDocument pOIDocument) {
        super(pOIDocument);
    }

    public HPSFPropertiesExtractor(POIFSFileSystem pOIFSFileSystem) {
        super(new HPSFPropertiesOnlyDocument(pOIFSFileSystem));
    }

    public HPSFPropertiesExtractor(NPOIFSFileSystem nPOIFSFileSystem) {
        super(new HPSFPropertiesOnlyDocument(nPOIFSFileSystem));
    }

    public String getDocumentSummaryInformationText() {
        CustomProperties customProperties;
        DocumentSummaryInformation documentSummaryInformation = this.document.getDocumentSummaryInformation();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HPSFPropertiesExtractor.getPropertiesText(documentSummaryInformation));
        CustomProperties customProperties2 = customProperties = documentSummaryInformation == null ? null : documentSummaryInformation.getCustomProperties();
        if (customProperties != null) {
            for (String string : customProperties.nameSet()) {
                String string2 = HelperPropertySet.getPropertyValueText(customProperties.get(string));
                stringBuffer.append(string + " = " + string2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getSummaryInformationText() {
        SummaryInformation summaryInformation = this.document.getSummaryInformation();
        return HPSFPropertiesExtractor.getPropertiesText(summaryInformation);
    }

    private static String getPropertiesText(SpecialPropertySet specialPropertySet) {
        if (specialPropertySet == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        PropertyIDMap propertyIDMap = specialPropertySet.getPropertySetIDMap();
        Property[] propertyArray = specialPropertySet.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = Long.toString(propertyArray[i].getID());
            Object object = propertyIDMap.get(propertyArray[i].getID());
            if (object != null) {
                string = object.toString();
            }
            String string2 = HelperPropertySet.getPropertyValueText(propertyArray[i].getValue());
            stringBuffer.append(string + " = " + string2 + "\n");
        }
        return stringBuffer.toString();
    }

    public String getText() {
        return this.getSummaryInformationText() + this.getDocumentSummaryInformationText();
    }

    public POITextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }

    public static void main(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            HPSFPropertiesExtractor hPSFPropertiesExtractor = new HPSFPropertiesExtractor(new NPOIFSFileSystem(new File(string)));
            System.out.println(hPSFPropertiesExtractor.getText());
        }
    }

    private static abstract class HelperPropertySet
    extends SpecialPropertySet {
        public HelperPropertySet() {
            super((MutablePropertySet)null);
        }

        public static String getPropertyValueText(Object object) {
            if (object == null) {
                return "(not set)";
            }
            return SpecialPropertySet.getPropertyStringValue(object);
        }
    }
}

