/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.TypedPropertyValue;
import ai.org.apache.poi.util.Internal;
import ai.org.apache.poi.util.LittleEndian;

@Internal
class Vector {
    private final short _type;
    private TypedPropertyValue[] _values;

    Vector(byte[] byArray, int n, short s) {
        this._type = s;
        this.read(byArray, n);
    }

    Vector(short s) {
        this._type = s;
    }

    int read(byte[] byArray, int n) {
        int n2 = n;
        long l = LittleEndian.getUInt(byArray, n2);
        n2 += 4;
        if (l > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Vector is too long -- " + l);
        }
        int n3 = (int)l;
        this._values = new TypedPropertyValue[n3];
        if (this._type == 12) {
            for (int i = 0; i < n3; ++i) {
                TypedPropertyValue typedPropertyValue = new TypedPropertyValue();
                n2 += typedPropertyValue.read(byArray, n2);
                this._values[i] = typedPropertyValue;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                TypedPropertyValue typedPropertyValue = new TypedPropertyValue(this._type, null);
                n2 += typedPropertyValue.readValue(byArray, n2);
                this._values[i] = typedPropertyValue;
            }
        }
        return n2 - n;
    }

    TypedPropertyValue[] getValues() {
        return this._values;
    }
}

