/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.ClipboardData;
import ai.org.apache.poi.hpsf.CodePageString;
import ai.org.apache.poi.hpsf.Filetime;
import ai.org.apache.poi.hpsf.ReadingNotSupportedException;
import ai.org.apache.poi.hpsf.TypeWriter;
import ai.org.apache.poi.hpsf.TypedPropertyValue;
import ai.org.apache.poi.hpsf.UnicodeString;
import ai.org.apache.poi.hpsf.UnsupportedVariantTypeException;
import ai.org.apache.poi.hpsf.Util;
import ai.org.apache.poi.hpsf.Variant;
import ai.org.apache.poi.hpsf.VariantBool;
import ai.org.apache.poi.hpsf.WritingNotSupportedException;
import ai.org.apache.poi.util.CodePageUtil;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class VariantSupport
extends Variant {
    private static final POILogger logger = POILogFactory.getLogger(VariantSupport.class);
    private static boolean logUnsupportedTypes = false;
    protected static List<Long> unsupportedMessage;
    public static final int[] SUPPORTED_TYPES;

    public static void setLogUnsupportedTypes(boolean bl) {
        logUnsupportedTypes = bl;
    }

    public static boolean isLogUnsupportedTypes() {
        return logUnsupportedTypes;
    }

    protected static void writeUnsupportedTypeMessage(UnsupportedVariantTypeException unsupportedVariantTypeException) {
        if (VariantSupport.isLogUnsupportedTypes()) {
            Long l;
            if (unsupportedMessage == null) {
                unsupportedMessage = new LinkedList<Long>();
            }
            if (!unsupportedMessage.contains(l = Long.valueOf(unsupportedVariantTypeException.getVariantType()))) {
                logger.log(7, unsupportedVariantTypeException.getMessage());
                unsupportedMessage.add(l);
            }
        }
    }

    public boolean isSupportedType(int n) {
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (n != SUPPORTED_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public static Object read(byte[] byArray, int n, int n2, long l, int n3) throws ReadingNotSupportedException, UnsupportedEncodingException {
        int n4;
        TypedPropertyValue typedPropertyValue = new TypedPropertyValue((int)l, null);
        try {
            n4 = typedPropertyValue.readValue(byArray, n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            int n5 = Math.min(n2, byArray.length - n);
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n, byArray2, 0, n5);
            throw new ReadingNotSupportedException(l, byArray2);
        }
        switch ((int)l) {
            case 0: 
            case 3: 
            case 5: 
            case 20: {
                return typedPropertyValue.getValue();
            }
            case 2: {
                return ((Short)typedPropertyValue.getValue()).intValue();
            }
            case 64: {
                Filetime filetime = (Filetime)typedPropertyValue.getValue();
                return Util.filetimeToDate((int)filetime.getHigh(), (int)filetime.getLow());
            }
            case 30: {
                CodePageString codePageString = (CodePageString)typedPropertyValue.getValue();
                return codePageString.getJavaValue(n3);
            }
            case 31: {
                UnicodeString unicodeString = (UnicodeString)typedPropertyValue.getValue();
                return unicodeString.toJavaString();
            }
            case 71: {
                ClipboardData clipboardData = (ClipboardData)typedPropertyValue.getValue();
                return clipboardData.toByteArray();
            }
            case 11: {
                VariantBool variantBool = (VariantBool)typedPropertyValue.getValue();
                return variantBool.getValue();
            }
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n, byArray3, 0, n4);
        throw new ReadingNotSupportedException(l, byArray3);
    }

    public static String codepageToEncoding(int n) throws UnsupportedEncodingException {
        return CodePageUtil.codepageToEncoding(n);
    }

    public static int write(OutputStream outputStream, long l, Object object, int n) throws IOException, WritingNotSupportedException {
        int n2 = 0;
        switch ((int)l) {
            case 11: {
                if (((Boolean)object).booleanValue()) {
                    outputStream.write(255);
                    outputStream.write(255);
                } else {
                    outputStream.write(0);
                    outputStream.write(0);
                }
                n2 += 2;
                break;
            }
            case 30: {
                CodePageString codePageString = new CodePageString((String)object, n);
                n2 += codePageString.write(outputStream);
                break;
            }
            case 31: {
                int n3;
                int n4;
                int n5 = ((String)object).length() + 1;
                n2 += TypeWriter.writeUIntToStream(outputStream, n5);
                char[] cArray = ((String)object).toCharArray();
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    n3 = (cArray[n4] & 0xFF00) >> 8;
                    int n6 = cArray[n4] & 0xFF;
                    byte by = (byte)n3;
                    byte by2 = (byte)n6;
                    outputStream.write(by2);
                    outputStream.write(by);
                    n2 += 2;
                }
                outputStream.write(0);
                outputStream.write(0);
                n2 += 2;
                break;
            }
            case 71: {
                byte[] byArray = (byte[])object;
                outputStream.write(byArray);
                n2 = byArray.length;
                break;
            }
            case 0: {
                n2 += TypeWriter.writeUIntToStream(outputStream, 0L);
                break;
            }
            case 2: {
                n2 += TypeWriter.writeToStream(outputStream, ((Integer)object).shortValue());
                break;
            }
            case 3: {
                if (!(object instanceof Integer)) {
                    throw new ClassCastException("Could not cast an object to " + Integer.class.toString() + ": " + object.getClass().toString() + ", " + object.toString());
                }
                n2 += TypeWriter.writeToStream(outputStream, (Integer)object);
                break;
            }
            case 20: {
                n2 += TypeWriter.writeToStream(outputStream, (Long)object);
                break;
            }
            case 5: {
                n2 += TypeWriter.writeToStream(outputStream, (Double)object);
                break;
            }
            case 64: {
                long l2 = Util.dateToFileTime((Date)object);
                int n4 = (int)(l2 >> 32 & 0xFFFFFFFFL);
                int n3 = (int)(l2 & 0xFFFFFFFFL);
                Filetime filetime = new Filetime(n3, n4);
                n2 += filetime.write(outputStream);
                break;
            }
            default: {
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    outputStream.write(byArray);
                    n2 = byArray.length;
                    VariantSupport.writeUnsupportedTypeMessage(new WritingNotSupportedException(l, object));
                    break;
                }
                throw new WritingNotSupportedException(l, object);
            }
        }
        while ((n2 & 3) != 0) {
            outputStream.write(0);
            ++n2;
        }
        return n2;
    }

    static {
        SUPPORTED_TYPES = new int[]{0, 2, 3, 20, 5, 64, 30, 31, 71, 11};
    }
}

