/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.HPSFRuntimeException;
import ai.org.apache.poi.hpsf.UnsupportedVariantTypeException;
import ai.org.apache.poi.hpsf.Util;
import ai.org.apache.poi.hpsf.VariantSupport;
import ai.org.apache.poi.hpsf.WritingNotSupportedException;
import ai.org.apache.poi.util.CodePageUtil;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property {
    protected long id;
    protected long type;
    protected Object value;

    public long getID() {
        return this.id;
    }

    public long getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Property(long l, long l2, Object object) {
        this.id = l;
        this.type = l2;
        this.value = object;
    }

    public Property(long l, byte[] byArray, long l2, int n, int n2) throws UnsupportedEncodingException {
        this.id = l;
        if (l == 0L) {
            this.value = this.readDictionary(byArray, l2, n, n2);
            return;
        }
        int n3 = (int)l2;
        this.type = LittleEndian.getUInt(byArray, n3);
        n3 += 4;
        try {
            this.value = VariantSupport.read(byArray, n3, n, (int)this.type, n2);
        }
        catch (UnsupportedVariantTypeException unsupportedVariantTypeException) {
            VariantSupport.writeUnsupportedTypeMessage(unsupportedVariantTypeException);
            this.value = unsupportedVariantTypeException.getValue();
        }
    }

    protected Property() {
    }

    protected Map<?, ?> readDictionary(byte[] byArray, long l, int n, int n2) throws UnsupportedEncodingException {
        if (l < 0L || l > (long)byArray.length) {
            throw new HPSFRuntimeException("Illegal offset " + l + " while HPSF stream contains " + n + " bytes.");
        }
        int n3 = (int)l;
        long l2 = LittleEndian.getUInt(byArray, n3);
        n3 += 4;
        LinkedHashMap<Long, String> linkedHashMap = new LinkedHashMap<Long, String>((int)l2, 1.0f);
        try {
            int n4 = 0;
            while ((long)n4 < l2) {
                Long l3 = LittleEndian.getUInt(byArray, n3);
                long l4 = LittleEndian.getUInt(byArray, n3 += 4);
                n3 += 4;
                StringBuffer stringBuffer = new StringBuffer();
                switch (n2) {
                    case -1: {
                        stringBuffer.append(new String(byArray, n3, (int)l4));
                        break;
                    }
                    case 1200: {
                        int n5 = (int)(l4 * 2L);
                        byte[] byArray2 = new byte[n5];
                        for (int i = 0; i < n5; i += 2) {
                            byArray2[i] = byArray[n3 + i + 1];
                            byArray2[i + 1] = byArray[n3 + i];
                        }
                        stringBuffer.append(new String(byArray2, 0, n5, CodePageUtil.codepageToEncoding(n2)));
                        break;
                    }
                    default: {
                        stringBuffer.append(new String(byArray, n3, (int)l4, VariantSupport.codepageToEncoding(n2)));
                    }
                }
                while (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\u0000') {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                if (n2 == 1200) {
                    if (l4 % 2L == 1L) {
                        ++l4;
                    }
                    n3 = (int)((long)n3 + (l4 + l4));
                } else {
                    n3 = (int)((long)n3 + l4);
                }
                linkedHashMap.put(l3, stringBuffer.toString());
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            POILogger pOILogger = POILogFactory.getLogger(this.getClass());
            pOILogger.log(5, (Object)("The property set's dictionary contains bogus data. All dictionary entries starting with the one with ID " + this.id + " will be ignored."), runtimeException);
        }
        return linkedHashMap;
    }

    protected int getSize() throws WritingNotSupportedException {
        int n = VariantSupport.getVariantLength(this.type);
        if (n >= 0) {
            return n;
        }
        if (n == -2) {
            throw new WritingNotSupportedException(this.type, null);
        }
        switch ((int)this.type) {
            case 30: {
                int n2 = ((String)this.value).length() + 1;
                int n3 = n2 % 4;
                if (n3 > 0) {
                    n2 += 4 - n3;
                }
                n += n2;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new WritingNotSupportedException(this.type, this.value);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        Class<?> clazz;
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        Object object2 = property.getValue();
        long l = property.getID();
        if (this.id != l || this.id != 0L && !this.typesAreEqual(this.type, property.getType())) {
            return false;
        }
        if (this.value == null && object2 == null) {
            return true;
        }
        if (this.value == null || object2 == null) {
            return false;
        }
        Class<?> clazz2 = this.value.getClass();
        if (!clazz2.isAssignableFrom(clazz = object2.getClass()) && !clazz.isAssignableFrom(clazz2)) {
            return false;
        }
        if (this.value instanceof byte[]) {
            return Util.equal((byte[])this.value, (byte[])object2);
        }
        return this.value.equals(object2);
    }

    private boolean typesAreEqual(long l, long l2) {
        return l == l2 || l == 30L && l2 == 31L || l2 == 30L && l == 31L;
    }

    public int hashCode() {
        long l = 0L;
        l += this.id;
        l += this.type;
        if (this.value != null) {
            l += (long)this.value.hashCode();
        }
        int n = (int)(l & 0xFFFFFFFFL);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("id: ");
        stringBuffer.append(this.getID());
        stringBuffer.append(", type: ");
        stringBuffer.append(this.getType());
        Object object = this.getValue();
        stringBuffer.append(", value: ");
        if (object instanceof String) {
            stringBuffer.append(object.toString());
            String string = (String)object;
            int n = string.length();
            byte[] byArray = new byte[n * 2];
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                byte by = (byte)((c & 0xFF00) >> 8);
                byte by2 = (byte)((c & 0xFF) >> 0);
                byArray[i * 2] = by;
                byArray[i * 2 + 1] = by2;
            }
            stringBuffer.append(" [");
            if (byArray.length > 0) {
                String string2 = HexDump.dump(byArray, 0L, 0);
                stringBuffer.append(string2);
            }
            stringBuffer.append("]");
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 0) {
                String string = HexDump.dump(byArray, 0L, 0);
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(object.toString());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

