/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.CustomProperty;
import ai.org.apache.poi.hpsf.MutableProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProperties
extends HashMap<Object, CustomProperty> {
    private Map<Long, String> dictionaryIDToName = new HashMap<Long, String>();
    private Map<String, Long> dictionaryNameToID = new HashMap<String, Long>();
    private boolean isPure = true;

    @Override
    public CustomProperty put(String string, CustomProperty customProperty) {
        if (string == null) {
            this.isPure = false;
            return null;
        }
        if (!string.equals(customProperty.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + string + ") and custom property's name (" + customProperty.getName() + ") do not match.");
        }
        Long l = customProperty.getID();
        Long l2 = this.dictionaryNameToID.get(string);
        this.dictionaryIDToName.remove(l2);
        this.dictionaryNameToID.put(string, l);
        this.dictionaryIDToName.put(l, string);
        CustomProperty customProperty2 = (CustomProperty)super.remove(l2);
        super.put(l, customProperty);
        return customProperty2;
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        String string = customProperty.getName();
        Long l = this.dictionaryNameToID.get(string);
        if (l != null) {
            customProperty.setID(l);
        } else {
            long l2 = 1L;
            for (long l3 : this.dictionaryIDToName.keySet()) {
                if (l3 <= l2) continue;
                l2 = l3;
            }
            customProperty.setID(l2 + 1L);
        }
        return this.put(string, customProperty);
    }

    public Object remove(String string) {
        Long l = this.dictionaryNameToID.get(string);
        if (l == null) {
            return null;
        }
        this.dictionaryIDToName.remove(l);
        this.dictionaryNameToID.remove(string);
        return super.remove(l);
    }

    @Override
    public Object put(String string, String string2) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(-1L);
        mutableProperty.setType(31L);
        mutableProperty.setValue(string2);
        CustomProperty customProperty = new CustomProperty(mutableProperty, string);
        return this.put(customProperty);
    }

    @Override
    public Object put(String string, Long l) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(-1L);
        mutableProperty.setType(20L);
        mutableProperty.setValue(l);
        CustomProperty customProperty = new CustomProperty(mutableProperty, string);
        return this.put(customProperty);
    }

    @Override
    public Object put(String string, Double d) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(-1L);
        mutableProperty.setType(5L);
        mutableProperty.setValue(d);
        CustomProperty customProperty = new CustomProperty(mutableProperty, string);
        return this.put(customProperty);
    }

    @Override
    public Object put(String string, Integer n) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(-1L);
        mutableProperty.setType(3L);
        mutableProperty.setValue(n);
        CustomProperty customProperty = new CustomProperty(mutableProperty, string);
        return this.put(customProperty);
    }

    @Override
    public Object put(String string, Boolean bl) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(-1L);
        mutableProperty.setType(11L);
        mutableProperty.setValue(bl);
        CustomProperty customProperty = new CustomProperty(mutableProperty, string);
        return this.put(customProperty);
    }

    public Object get(String string) {
        Long l = this.dictionaryNameToID.get(string);
        CustomProperty customProperty = (CustomProperty)super.get(l);
        return customProperty != null ? customProperty.getValue() : null;
    }

    @Override
    public Object put(String string, Date date) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(-1L);
        mutableProperty.setType(64L);
        mutableProperty.setValue(date);
        CustomProperty customProperty = new CustomProperty(mutableProperty, string);
        return this.put(customProperty);
    }

    @Override
    public Set keySet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set<String> nameSet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set<String> idSet() {
        return this.dictionaryNameToID.keySet();
    }

    public void setCodepage(int n) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(1L);
        mutableProperty.setType(2L);
        mutableProperty.setValue(n);
        this.put(new CustomProperty(mutableProperty));
    }

    Map<Long, String> getDictionary() {
        return this.dictionaryIDToName;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            return super.containsKey((Long)object);
        }
        if (object instanceof String) {
            return super.containsKey(this.dictionaryNameToID.get(object));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof CustomProperty) {
            return super.containsValue((CustomProperty)object);
        }
        for (CustomProperty customProperty : super.values()) {
            if (customProperty.getValue() != object) continue;
            return true;
        }
        return false;
    }

    public int getCodepage() {
        int n = -1;
        Iterator iterator = this.values().iterator();
        while (n == -1 && iterator.hasNext()) {
            CustomProperty customProperty = (CustomProperty)iterator.next();
            if (customProperty.getID() != 1L) continue;
            n = (Integer)customProperty.getValue();
        }
        return n;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean bl) {
        this.isPure = bl;
    }
}

