/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnknownEscherRecord
extends EscherRecord {
    private static final byte[] NO_BYTES = new byte[0];
    private byte[] thedata = NO_BYTES;
    private List<EscherRecord> _childRecords = new ArrayList<EscherRecord>();

    @Override
    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2;
        int n3 = this.readHeader(byArray, n);
        if (n3 > (n2 = byArray.length - (n + 8))) {
            n3 = n2;
        }
        if (this.isContainerRecord()) {
            int n4 = 0;
            this.thedata = new byte[0];
            n += 8;
            n4 += 8;
            while (n3 > 0) {
                EscherRecord escherRecord = escherRecordFactory.createRecord(byArray, n);
                int n5 = escherRecord.fillFields(byArray, n, escherRecordFactory);
                n4 += n5;
                n += n5;
                n3 -= n5;
                this.getChildRecords().add(escherRecord);
            }
            return n4;
        }
        this.thedata = new byte[n3];
        System.arraycopy(byArray, n + 8, this.thedata, 0, n3);
        return n3 + 8;
    }

    @Override
    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = this.thedata.length;
        for (EscherRecord object : this._childRecords) {
            n2 += object.getRecordSize();
        }
        LittleEndian.putInt(byArray, n + 4, n2);
        System.arraycopy(this.thedata, 0, byArray, n + 8, this.thedata.length);
        int n3 = n + 8 + this.thedata.length;
        for (EscherRecord escherRecord : this._childRecords) {
            n3 += escherRecord.serialize(n3, byArray, escherSerializationListener);
        }
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    public byte[] getData() {
        return this.thedata;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.thedata.length;
    }

    @Override
    public List<EscherRecord> getChildRecords() {
        return this._childRecords;
    }

    @Override
    public void setChildRecords(List<EscherRecord> list) {
        this._childRecords = list;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public String getRecordName() {
        return "Unknown 0x" + HexDump.toHex(this.getRecordId());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getChildRecords().size() > 0) {
            stringBuffer.append("  children: \n");
            for (EscherRecord escherRecord : this._childRecords) {
                stringBuffer.append(escherRecord.toString());
                stringBuffer.append('\n');
            }
        }
        String string = HexDump.toHex(this.thedata, 32);
        return this.getClass().getName() + ":" + '\n' + "  isContainer: " + this.isContainerRecord() + '\n' + "  version: 0x" + HexDump.toHex(this.getVersion()) + '\n' + "  instance: 0x" + HexDump.toHex(this.getInstance()) + '\n' + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + '\n' + "  numchildren: " + this.getChildRecords().size() + '\n' + (String)string + stringBuffer.toString();
    }

    @Override
    public String toXml(String string) {
        String string2 = HexDump.toHex(this.thedata, 32);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<IsContainer>").append(this.isContainerRecord()).append("</IsContainer>\n").append(string).append("\t").append("<Numchildren>").append(HexDump.toHex(this._childRecords.size())).append("</Numchildren>\n");
        for (EscherRecord escherRecord : this._childRecords) {
            stringBuilder.append(escherRecord.toXml(string + "\t"));
        }
        stringBuilder.append(string2).append("\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public void addChildRecord(EscherRecord escherRecord) {
        this.getChildRecords().add(escherRecord);
    }
}

