/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherProperties;
import ai.org.apache.poi.ddf.EscherProperty;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;

public class EscherSimpleProperty
extends EscherProperty {
    protected int propertyValue;

    public EscherSimpleProperty(short s, int n) {
        super(s);
        this.propertyValue = n;
    }

    public EscherSimpleProperty(short s, boolean bl, boolean bl2, int n) {
        super(s, bl, bl2);
        this.propertyValue = n;
    }

    public int serializeSimplePart(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this.getId());
        LittleEndian.putInt(byArray, n + 2, this.propertyValue);
        return 6;
    }

    public int serializeComplexPart(byte[] byArray, int n) {
        return 0;
    }

    public int getPropertyValue() {
        return this.propertyValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EscherSimpleProperty)) {
            return false;
        }
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)object;
        if (this.propertyValue != escherSimpleProperty.propertyValue) {
            return false;
        }
        return this.getId() == escherSimpleProperty.getId();
    }

    public int hashCode() {
        return this.propertyValue;
    }

    public String toString() {
        return "propNum: " + this.getPropertyNumber() + ", RAW: 0x" + HexDump.toHex(this.getId()) + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", value: " + this.propertyValue + " (0x" + HexDump.toHex(this.propertyValue) + ")";
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("<").append(this.getClass().getSimpleName()).append(" id=\"0x").append(HexDump.toHex(this.getId())).append("\" name=\"").append(this.getName()).append("\" blipId=\"").append(this.isBlipId()).append("\" complex=\"").append(this.isComplex()).append("\" value=\"").append("0x").append(HexDump.toHex(this.propertyValue)).append("\"/>\n");
        return stringBuilder.toString();
    }
}

