/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;

public class EscherDgRecord
extends EscherRecord {
    public static final short RECORD_ID = -4088;
    public static final String RECORD_DESCRIPTION = "MsofbtDg";
    private int field_1_numShapes;
    private int field_2_lastMSOSPID;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_numShapes = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_lastMSOSPID = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        n4 += 4;
        return this.getRecordSize();
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, 8);
        LittleEndian.putInt(byArray, n + 8, this.field_1_numShapes);
        LittleEndian.putInt(byArray, n + 12, this.field_2_lastMSOSPID);
        escherSerializationListener.afterRecordSerialize(n + 16, this.getRecordId(), this.getRecordSize(), this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public short getRecordId() {
        return -4088;
    }

    public String getRecordName() {
        return "Dg";
    }

    public String toString() {
        return this.getClass().getName() + ":" + '\n' + "  RecordId: 0x" + HexDump.toHex((short)-4088) + '\n' + "  Version: 0x" + HexDump.toHex(this.getVersion()) + '\n' + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + '\n' + "  NumShapes: " + this.field_1_numShapes + '\n' + "  LastMSOSPID: " + this.field_2_lastMSOSPID + '\n';
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<NumShapes>").append(this.field_1_numShapes).append("</NumShapes>\n").append(string).append("\t").append("<LastMSOSPID>").append(this.field_2_lastMSOSPID).append("</LastMSOSPID>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public int getNumShapes() {
        return this.field_1_numShapes;
    }

    public void setNumShapes(int n) {
        this.field_1_numShapes = n;
    }

    public int getLastMSOSPID() {
        return this.field_2_lastMSOSPID;
    }

    public void setLastMSOSPID(int n) {
        this.field_2_lastMSOSPID = n;
    }

    public short getDrawingGroupId() {
        return (short)(this.getOptions() >> 4);
    }

    public void incrementShapeCount() {
        ++this.field_1_numShapes;
    }
}

