/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherProperties;
import ai.org.apache.poi.ddf.EscherProperty;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

public class EscherComplexProperty
extends EscherProperty {
    protected byte[] _complexData;

    public EscherComplexProperty(short s, byte[] byArray) {
        super(s);
        this._complexData = byArray;
    }

    public EscherComplexProperty(short s, boolean bl, byte[] byArray) {
        super(s, true, bl);
        this._complexData = byArray;
    }

    public int serializeSimplePart(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this.getId());
        LittleEndian.putInt(byArray, n + 2, this._complexData.length);
        return 6;
    }

    public int serializeComplexPart(byte[] byArray, int n) {
        System.arraycopy(this._complexData, 0, byArray, n, this._complexData.length);
        return this._complexData.length;
    }

    public byte[] getComplexData() {
        return this._complexData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EscherComplexProperty)) {
            return false;
        }
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)object;
        return Arrays.equals(this._complexData, escherComplexProperty._complexData);
    }

    public int getPropertySize() {
        return 6 + this._complexData.length;
    }

    public int hashCode() {
        return this.getId() * 11;
    }

    public String toString() {
        String string = HexDump.toHex(this._complexData, 32);
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + System.getProperty("line.separator") + string;
    }

    public String toXml(String string) {
        String string2 = HexDump.toHex(this._complexData, 32);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("<").append(this.getClass().getSimpleName()).append(" id=\"0x").append(HexDump.toHex(this.getId())).append("\" name=\"").append(this.getName()).append("\" blipId=\"").append(this.isBlipId()).append("\">\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }
}

