/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;

public class EscherClientAnchorRecord
extends EscherRecord {
    public static final short RECORD_ID = -4080;
    public static final String RECORD_DESCRIPTION = "MsofbtClientAnchor";
    private short field_1_flag;
    private short field_2_col1;
    private short field_3_dx1;
    private short field_4_row1;
    private short field_5_dy1;
    private short field_6_col2;
    private short field_7_dx2;
    private short field_8_row2;
    private short field_9_dy2;
    private byte[] remainingData;
    private boolean shortRecord = false;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        if (n2 != 4) {
            this.field_1_flag = LittleEndian.getShort(byArray, n3 + n4);
            this.field_2_col1 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
            this.field_3_dx1 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
            this.field_4_row1 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
            n4 += 2;
            if (n2 >= 18) {
                this.field_5_dy1 = LittleEndian.getShort(byArray, n3 + n4);
                this.field_6_col2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                this.field_7_dx2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                this.field_8_row2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                this.field_9_dy2 = LittleEndian.getShort(byArray, n3 + (n4 += 2));
                n4 += 2;
                this.shortRecord = false;
            } else {
                this.shortRecord = true;
            }
        }
        this.remainingData = new byte[n2 -= n4];
        System.arraycopy(byArray, n3 + n4, this.remainingData, 0, n2);
        return 8 + n4 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        if (this.remainingData == null) {
            this.remainingData = new byte[0];
        }
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = this.remainingData.length + (this.shortRecord ? 8 : 18);
        LittleEndian.putInt(byArray, n + 4, n2);
        LittleEndian.putShort(byArray, n + 8, this.field_1_flag);
        LittleEndian.putShort(byArray, n + 10, this.field_2_col1);
        LittleEndian.putShort(byArray, n + 12, this.field_3_dx1);
        LittleEndian.putShort(byArray, n + 14, this.field_4_row1);
        if (!this.shortRecord) {
            LittleEndian.putShort(byArray, n + 16, this.field_5_dy1);
            LittleEndian.putShort(byArray, n + 18, this.field_6_col2);
            LittleEndian.putShort(byArray, n + 20, this.field_7_dx2);
            LittleEndian.putShort(byArray, n + 22, this.field_8_row2);
            LittleEndian.putShort(byArray, n + 24, this.field_9_dy2);
        }
        System.arraycopy(this.remainingData, 0, byArray, n + (this.shortRecord ? 16 : 26), this.remainingData.length);
        int n3 = n + 8 + (this.shortRecord ? 8 : 18) + this.remainingData.length;
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    public int getRecordSize() {
        return 8 + (this.shortRecord ? 8 : 18) + (this.remainingData == null ? 0 : this.remainingData.length);
    }

    public short getRecordId() {
        return -4080;
    }

    public String getRecordName() {
        return "ClientAnchor";
    }

    public String toString() {
        String string;
        String string2 = System.getProperty("line.separator");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.remainingData, 0L, byteArrayOutputStream, 0);
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string = "error\n";
        }
        return this.getClass().getName() + ":" + string2 + "  RecordId: 0x" + HexDump.toHex((short)-4080) + string2 + "  Version: 0x" + HexDump.toHex(this.getVersion()) + string2 + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + string2 + "  Flag: " + this.field_1_flag + string2 + "  Col1: " + this.field_2_col1 + string2 + "  DX1: " + this.field_3_dx1 + string2 + "  Row1: " + this.field_4_row1 + string2 + "  DY1: " + this.field_5_dy1 + string2 + "  Col2: " + this.field_6_col2 + string2 + "  DX2: " + this.field_7_dx2 + string2 + "  Row2: " + this.field_8_row2 + string2 + "  DY2: " + this.field_9_dy2 + string2 + "  Extra Data:" + string2 + string;
    }

    public String toXml(String string) {
        String string2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.remainingData, 0L, byteArrayOutputStream, 0);
            string2 = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string2 = "error\n";
        }
        if (string2.contains("No Data")) {
            string2 = "No Data";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<Flag>").append(this.field_1_flag).append("</Flag>\n").append(string).append("\t").append("<Col1>").append(this.field_2_col1).append("</Col1>\n").append(string).append("\t").append("<DX1>").append(this.field_3_dx1).append("</DX1>\n").append(string).append("\t").append("<Row1>").append(this.field_4_row1).append("</Row1>\n").append(string).append("\t").append("<DY1>").append(this.field_5_dy1).append("</DY1>\n").append(string).append("\t").append("<Col2>").append(this.field_6_col2).append("</Col2>\n").append(string).append("\t").append("<DX2>").append(this.field_7_dx2).append("</DX2>\n").append(string).append("\t").append("<Row2>").append(this.field_8_row2).append("</Row2>\n").append(string).append("\t").append("<DY2>").append(this.field_9_dy2).append("</DY2>\n").append(string).append("\t").append("<ExtraData>").append(string2).append("</ExtraData>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public short getFlag() {
        return this.field_1_flag;
    }

    public void setFlag(short s) {
        this.field_1_flag = s;
    }

    public short getCol1() {
        return this.field_2_col1;
    }

    public void setCol1(short s) {
        this.field_2_col1 = s;
    }

    public short getDx1() {
        return this.field_3_dx1;
    }

    public void setDx1(short s) {
        this.field_3_dx1 = s;
    }

    public short getRow1() {
        return this.field_4_row1;
    }

    public void setRow1(short s) {
        this.field_4_row1 = s;
    }

    public short getDy1() {
        return this.field_5_dy1;
    }

    public void setDy1(short s) {
        this.shortRecord = false;
        this.field_5_dy1 = s;
    }

    public short getCol2() {
        return this.field_6_col2;
    }

    public void setCol2(short s) {
        this.shortRecord = false;
        this.field_6_col2 = s;
    }

    public short getDx2() {
        return this.field_7_dx2;
    }

    public void setDx2(short s) {
        this.shortRecord = false;
        this.field_7_dx2 = s;
    }

    public short getRow2() {
        return this.field_8_row2;
    }

    public void setRow2(short s) {
        this.shortRecord = false;
        this.field_8_row2 = s;
    }

    public short getDy2() {
        return this.field_9_dy2;
    }

    public void setDy2(short s) {
        this.shortRecord = false;
        this.field_9_dy2 = s;
    }

    public byte[] getRemainingData() {
        return this.remainingData;
    }

    public void setRemainingData(byte[] byArray) {
        this.remainingData = byArray;
    }
}

