/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherProperty;
import ai.org.apache.poi.ddf.EscherPropertyFactory;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEscherOptRecord
extends EscherRecord {
    protected List<EscherProperty> properties = new ArrayList<EscherProperty>();

    public void addEscherProperty(EscherProperty escherProperty) {
        this.properties.add(escherProperty);
    }

    @Override
    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        short s = AbstractEscherOptRecord.readInstance(byArray, n);
        int n3 = n + 8;
        EscherPropertyFactory escherPropertyFactory = new EscherPropertyFactory();
        this.properties = escherPropertyFactory.createProperties(byArray, n3, s);
        return n2 + 8;
    }

    public List<EscherProperty> getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int n) {
        return this.properties.get(n);
    }

    private int getPropertiesSize() {
        int n = 0;
        for (EscherProperty escherProperty : this.properties) {
            n += escherProperty.getPropertySize();
        }
        return n;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public <T extends EscherProperty> T lookup(int n) {
        for (EscherProperty escherProperty : this.properties) {
            if (escherProperty.getPropertyNumber() != n) continue;
            EscherProperty escherProperty2 = escherProperty;
            return (T)escherProperty2;
        }
        return null;
    }

    @Override
    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, this.getPropertiesSize());
        int n2 = n + 8;
        for (EscherProperty escherProperty : this.properties) {
            n2 += escherProperty.serializeSimplePart(byArray, n2);
        }
        for (EscherProperty escherProperty : this.properties) {
            n2 += escherProperty.serializeComplexPart(byArray, n2);
        }
        escherSerializationListener.afterRecordSerialize(n2, this.getRecordId(), n2 - n, this);
        return n2 - n;
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator<EscherProperty>(){

            @Override
            public int compare(EscherProperty escherProperty, EscherProperty escherProperty2) {
                short s;
                short s2 = escherProperty.getPropertyNumber();
                return s2 < (s = escherProperty2.getPropertyNumber()) ? -1 : (s2 == s ? 0 : 1);
            }
        });
    }

    public void setEscherProperty(EscherProperty escherProperty) {
        Iterator<EscherProperty> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty2 = iterator.next();
            if (escherProperty2.getId() != escherProperty.getId()) continue;
            iterator.remove();
        }
        this.properties.add(escherProperty);
        this.sortProperties();
    }

    public void removeEscherProperty(int n) {
        Iterator<EscherProperty> iterator = this.getEscherProperties().iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty = iterator.next();
            if (escherProperty.getPropertyNumber() != n) continue;
            iterator.remove();
        }
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(":");
        stringBuilder.append(string);
        stringBuilder.append("  isContainer: ");
        stringBuilder.append(this.isContainerRecord());
        stringBuilder.append(string);
        stringBuilder.append("  version: 0x");
        stringBuilder.append(HexDump.toHex(this.getVersion()));
        stringBuilder.append(string);
        stringBuilder.append("  instance: 0x");
        stringBuilder.append(HexDump.toHex(this.getInstance()));
        stringBuilder.append(string);
        stringBuilder.append("  recordId: 0x");
        stringBuilder.append(HexDump.toHex(this.getRecordId()));
        stringBuilder.append(string);
        stringBuilder.append("  numchildren: ");
        stringBuilder.append(this.getChildRecords().size());
        stringBuilder.append(string);
        stringBuilder.append("  properties:");
        stringBuilder.append(string);
        for (EscherProperty escherProperty : this.properties) {
            stringBuilder.append("    " + escherProperty.toString() + string);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance())));
        for (EscherProperty escherProperty : this.getEscherProperties()) {
            stringBuilder.append(escherProperty.toXml(string + "\t"));
        }
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }
}

