/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi;

import ai.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai.org.apache.poi.hpsf.HPSFException;
import ai.org.apache.poi.hpsf.MutablePropertySet;
import ai.org.apache.poi.hpsf.PropertySet;
import ai.org.apache.poi.hpsf.PropertySetFactory;
import ai.org.apache.poi.hpsf.SummaryInformation;
import ai.org.apache.poi.hpsf.WritingNotSupportedException;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.Entry;
import ai.org.apache.poi.poifs.filesystem.EntryUtils;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.util.Internal;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class POIDocument {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    protected DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized = false;

    protected POIDocument(DirectoryNode directoryNode) {
        this.directory = directoryNode;
    }

    @Deprecated
    protected POIDocument(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) {
        this.directory = directoryNode;
    }

    protected POIDocument(POIFSFileSystem pOIFSFileSystem) {
        this(pOIFSFileSystem.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem nPOIFSFileSystem) {
        this(nPOIFSFileSystem.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        PropertySet propertySet = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (propertySet != null && propertySet instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)propertySet;
        } else if (propertySet != null) {
            logger.log(5, (Object)"DocumentSummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        propertySet = this.getPropertySet("\u0005SummaryInformation");
        if (propertySet instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)propertySet;
        } else if (propertySet != null) {
            logger.log(5, (Object)"SummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String string) {
        DocumentInputStream documentInputStream;
        if (this.directory == null || !this.directory.hasEntry(string)) {
            return null;
        }
        try {
            documentInputStream = this.directory.createDocumentInputStream(this.directory.getEntry(string));
        }
        catch (IOException iOException) {
            logger.log(5, "Error getting property set with name " + string + "\n" + iOException);
            return null;
        }
        try {
            PropertySet propertySet = PropertySetFactory.create(documentInputStream);
            return propertySet;
        }
        catch (IOException iOException) {
            logger.log(5, "Error creating property set with name " + string + "\n" + iOException);
        }
        catch (HPSFException hPSFException) {
            logger.log(5, "Error creating property set with name " + string + "\n" + hPSFException);
        }
        return null;
    }

    protected void writeProperties(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this.writeProperties(pOIFSFileSystem, null);
    }

    protected void writeProperties(POIFSFileSystem pOIFSFileSystem, List<String> list) throws IOException {
        DocumentSummaryInformation documentSummaryInformation;
        SummaryInformation summaryInformation = this.getSummaryInformation();
        if (summaryInformation != null) {
            this.writePropertySet("\u0005SummaryInformation", summaryInformation, pOIFSFileSystem);
            if (list != null) {
                list.add("\u0005SummaryInformation");
            }
        }
        if ((documentSummaryInformation = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", documentSummaryInformation, pOIFSFileSystem);
            if (list != null) {
                list.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String string, PropertySet propertySet, POIFSFileSystem pOIFSFileSystem) throws IOException {
        try {
            MutablePropertySet mutablePropertySet = new MutablePropertySet(propertySet);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mutablePropertySet.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            pOIFSFileSystem.createDocument(byteArrayInputStream, string);
            logger.log(3, "Wrote property set " + string + " of size " + byArray.length);
        }
        catch (WritingNotSupportedException writingNotSupportedException) {
            logger.log(7, "Couldn't write property set with name " + string + " as not supported by HPSF yet");
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    @Deprecated
    protected void copyNodes(POIFSFileSystem pOIFSFileSystem, POIFSFileSystem pOIFSFileSystem2, List<String> list) throws IOException {
        EntryUtils.copyNodes(pOIFSFileSystem, pOIFSFileSystem2, list);
    }

    @Deprecated
    protected void copyNodes(DirectoryNode directoryNode, DirectoryNode directoryNode2, List<String> list) throws IOException {
        EntryUtils.copyNodes(directoryNode, directoryNode2, list);
    }

    @Internal
    @Deprecated
    protected void copyNodeRecursively(Entry entry, DirectoryEntry directoryEntry) throws IOException {
        EntryUtils.copyNodeRecursively(entry, directoryEntry);
    }
}

