/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.commons.codec.language.bm;

import ai.org.apache.commons.codec.language.bm.Lang;
import ai.org.apache.commons.codec.language.bm.Languages;
import ai.org.apache.commons.codec.language.bm.NameType;
import ai.org.apache.commons.codec.language.bm.Rule;
import ai.org.apache.commons.codec.language.bm.RuleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneticEngine {
    private static final Map<NameType, Set<String>> NAME_PREFIXES = new EnumMap<NameType, Set<String>>(NameType.class);
    private final Lang lang;
    private final NameType nameType;
    private final RuleType ruleType;
    private final boolean concat;

    private static CharSequence cacheSubSequence(final CharSequence charSequence) {
        final CharSequence[][] charSequenceArray = new CharSequence[charSequence.length()][charSequence.length()];
        return new CharSequence(){

            public char charAt(int n) {
                return charSequence.charAt(n);
            }

            public int length() {
                return charSequence.length();
            }

            public CharSequence subSequence(int n, int n2) {
                if (n == n2) {
                    return "";
                }
                CharSequence charSequence2 = charSequenceArray[n][n2 - 1];
                if (charSequence2 == null) {
                    charSequenceArray[n][n2 - 1] = charSequence2 = charSequence.subSequence(n, n2);
                }
                return charSequence2;
            }
        };
    }

    private static String join(Iterable<String> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl) {
        if (ruleType == RuleType.RULES) {
            throw new IllegalArgumentException("ruleType must not be " + (Object)((Object)RuleType.RULES));
        }
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = bl;
        this.lang = Lang.instance(nameType);
    }

    private PhonemeBuilder applyFinalRules(PhonemeBuilder phonemeBuilder, List<Rule> list) {
        if (list == null) {
            throw new NullPointerException("finalRules can not be null");
        }
        if (list.isEmpty()) {
            return phonemeBuilder;
        }
        TreeSet<Rule.Phoneme> treeSet = new TreeSet<Rule.Phoneme>(Rule.Phoneme.COMPARATOR);
        for (Rule.Phoneme phoneme : phonemeBuilder.getPhonemes()) {
            PhonemeBuilder phonemeBuilder2 = PhonemeBuilder.empty(phoneme.getLanguages());
            CharSequence charSequence = PhoneticEngine.cacheSubSequence(phoneme.getPhonemeText());
            int n = 0;
            while (n < charSequence.length()) {
                RulesApplication rulesApplication = new RulesApplication(list, charSequence, phonemeBuilder2, n).invoke();
                boolean bl = rulesApplication.isFound();
                phonemeBuilder2 = rulesApplication.getPhonemeBuilder();
                if (!bl) {
                    phonemeBuilder2 = phonemeBuilder2.append(charSequence.subSequence(n, n + 1));
                }
                n = rulesApplication.getI();
            }
            treeSet.addAll(phonemeBuilder2.getPhonemes());
        }
        return new PhonemeBuilder(treeSet);
    }

    public String encode(String string) {
        Languages.LanguageSet languageSet = this.lang.guessLanguages(string);
        return this.encode(string, languageSet);
    }

    public String encode(String string, Languages.LanguageSet languageSet) {
        Object object;
        Object object2;
        Object object3;
        List<Rule> list = Rule.getInstance(this.nameType, RuleType.RULES, languageSet);
        List<Rule> list2 = Rule.getInstance(this.nameType, this.ruleType, "common");
        List<Rule> list3 = Rule.getInstance(this.nameType, this.ruleType, languageSet);
        string = string.toLowerCase(Locale.ENGLISH).replace('-', ' ').trim();
        if (this.nameType == NameType.GENERIC) {
            if (string.length() >= 2 && string.substring(0, 2).equals("d'")) {
                String string2 = string.substring(2);
                String string3 = "d" + string2;
                return "(" + this.encode(string2) + ")-(" + this.encode(string3) + ")";
            }
            for (String object52 : NAME_PREFIXES.get((Object)this.nameType)) {
                if (!string.startsWith(object52 + " ")) continue;
                String object4 = string.substring(object52.length() + 1);
                String object32 = object52 + object4;
                return "(" + this.encode(object4) + ")-(" + this.encode(object32) + ")";
            }
        }
        List<String> list4 = Arrays.asList(string.split("\\s+"));
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.nameType) {
            case SEPHARDIC: {
                object3 = list4.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    Object n = ((String)object2).split("'");
                    object = n[((String[])n).length - 1];
                    arrayList.add((String)object);
                }
                arrayList.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case ASHKENAZI: {
                arrayList.addAll(list4);
                arrayList.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case GENERIC: {
                arrayList.addAll(list4);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable case: " + (Object)((Object)this.nameType));
            }
        }
        if (this.concat) {
            string = PhoneticEngine.join(arrayList, " ");
        } else if (arrayList.size() == 1) {
            string = (String)list4.iterator().next();
        } else {
            object3 = new StringBuilder();
            for (Object n : arrayList) {
                ((StringBuilder)object3).append("-").append(this.encode((String)n));
            }
            return ((StringBuilder)object3).substring(1);
        }
        object3 = PhonemeBuilder.empty(languageSet);
        object2 = PhoneticEngine.cacheSubSequence(string);
        int n = 0;
        while (n < object2.length()) {
            object = new RulesApplication(list, (CharSequence)object2, (PhonemeBuilder)object3, n).invoke();
            n = ((RulesApplication)object).getI();
            object3 = ((RulesApplication)object).getPhonemeBuilder();
        }
        object3 = this.applyFinalRules((PhonemeBuilder)object3, list2);
        object3 = this.applyFinalRules((PhonemeBuilder)object3, list3);
        return ((PhonemeBuilder)object3).makeString();
    }

    public Lang getLang() {
        return this.lang;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isConcat() {
        return this.concat;
    }

    static {
        NAME_PREFIXES.put(NameType.ASHKENAZI, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bar", "ben", "da", "de", "van", "von"))));
        NAME_PREFIXES.put(NameType.SEPHARDIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("al", "el", "da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
        NAME_PREFIXES.put(NameType.GENERIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RulesApplication {
        private final List<Rule> finalRules;
        private final CharSequence input;
        private PhonemeBuilder phonemeBuilder;
        private int i;
        private boolean found;

        public RulesApplication(List<Rule> list, CharSequence charSequence, PhonemeBuilder phonemeBuilder, int n) {
            if (list == null) {
                throw new NullPointerException("The finalRules argument must not be null");
            }
            this.finalRules = list;
            this.phonemeBuilder = phonemeBuilder;
            this.input = charSequence;
            this.i = n;
        }

        public int getI() {
            return this.i;
        }

        public PhonemeBuilder getPhonemeBuilder() {
            return this.phonemeBuilder;
        }

        public RulesApplication invoke() {
            this.found = false;
            int n = 0;
            for (Rule rule : this.finalRules) {
                String string = rule.getPattern();
                n = string.length();
                if (!rule.patternAndContextMatches(this.input, this.i)) continue;
                this.phonemeBuilder = this.phonemeBuilder.apply(rule.getPhoneme());
                this.found = true;
                break;
            }
            if (!this.found) {
                n = 1;
            }
            this.i += n;
            return this;
        }

        public boolean isFound() {
            return this.found;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PhonemeBuilder {
        private final Set<Rule.Phoneme> phonemes;

        public static PhonemeBuilder empty(Languages.LanguageSet languageSet) {
            return new PhonemeBuilder(Collections.singleton(new Rule.Phoneme("", languageSet)));
        }

        private PhonemeBuilder(Set<Rule.Phoneme> set) {
            this.phonemes = set;
        }

        public PhonemeBuilder append(CharSequence charSequence) {
            HashSet<Rule.Phoneme> hashSet = new HashSet<Rule.Phoneme>();
            for (Rule.Phoneme phoneme : this.phonemes) {
                hashSet.add(phoneme.append(charSequence));
            }
            return new PhonemeBuilder(hashSet);
        }

        public PhonemeBuilder apply(Rule.PhonemeExpr phonemeExpr) {
            HashSet<Rule.Phoneme> hashSet = new HashSet<Rule.Phoneme>();
            for (Rule.Phoneme phoneme : this.phonemes) {
                for (Rule.Phoneme phoneme2 : phonemeExpr.getPhonemes()) {
                    Rule.Phoneme phoneme3 = phoneme.join(phoneme2);
                    if (phoneme3.getLanguages().isEmpty()) continue;
                    hashSet.add(phoneme3);
                }
            }
            return new PhonemeBuilder(hashSet);
        }

        public Set<Rule.Phoneme> getPhonemes() {
            return this.phonemes;
        }

        public String makeString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Rule.Phoneme phoneme : this.phonemes) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(phoneme.getPhonemeText());
            }
            return stringBuilder.toString();
        }
    }
}

