/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.output;

import ai.net.sourceforge.barbecue.output.AbstractOutput;
import ai.net.sourceforge.barbecue.output.LabelLayout;
import ai.net.sourceforge.barbecue.output.OutputException;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class SVGOutput
extends AbstractOutput {
    private static final String DEFAULT_FAMILY = "Arial";
    private static final int DEFAULT_SIZE = 20;
    private static final String[] FONT_STYLES = new String[]{"font-style: normal", "font-weight: bold", "font-style: italic"};
    private String units;
    private final Writer writer;
    private Element root;
    private Document doc;

    public SVGOutput(Writer writer, Font font, Color color, Color color2, double d, String string) {
        super(font, true, d, color, color2);
        this.writer = writer;
        this.units = string;
    }

    public void beginDraw() {
        this.root = this.createElement("svg");
        this.doc = new Document(this.root);
    }

    public void endDraw(int n, int n2) throws OutputException {
        this.root.setNamespace(Namespace.getNamespace((String)"svg", (String)"http://www.w3.org/2000/svg"));
        this.root.setAttribute("width", this.getScaledDimension(n));
        this.root.setAttribute("height", this.getScaledDimension(n2));
        this.doc.setDocType(new DocType("svg", "-//W3C//DTD SVG 1.1//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"));
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(this.writer);
            XMLOutputter xMLOutputter = new XMLOutputter();
            xMLOutputter.output(this.doc, (Writer)bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new OutputException(iOException.getMessage(), iOException);
        }
    }

    protected Element createElement(String string) {
        Element element = new Element(string);
        element.setNamespace(Namespace.getNamespace((String)"svg", (String)"http://www.w3.org/2000/svg"));
        return element;
    }

    public int drawBar(int n, int n2, int n3, int n4, boolean bl) {
        Element element = this.createElement("rect");
        element.setAttribute("x", this.getScaledDimension(n));
        element.setAttribute("y", this.getScaledDimension(n2));
        element.setAttribute("width", this.getScaledDimension(n3));
        element.setAttribute("height", this.getScaledDimension(n4));
        element.setAttribute("style", "fill:" + this.getColorAsCSS(bl ? this.foregroundColour : this.backgroundColour) + ";");
        this.root.addContent((Content)element);
        return n3;
    }

    public int drawText(String string, LabelLayout labelLayout) throws OutputException {
        Element element = this.createElement("text");
        element.setAttribute("x", this.getScaledDimension(labelLayout.getBackgroundX()));
        element.setAttribute("y", this.getScaledDimension(labelLayout.getBackgroundY()));
        element.setAttribute("style", this.constructStyleText());
        element.addContent(string);
        this.root.addContent((Content)element);
        return 0;
    }

    public void paintBackground(int n, int n2, int n3, int n4) {
    }

    private String constructStyleText() {
        String string = DEFAULT_FAMILY;
        int n = 20;
        int n2 = 0;
        if (this.font != null) {
            string = this.font.getFamily();
            n = this.font.getSize();
            n2 = this.font.getStyle();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("font-family: ");
        stringBuffer.append(string);
        stringBuffer.append("; ");
        stringBuffer.append("font-size: ");
        stringBuffer.append(n);
        stringBuffer.append("pt; ");
        stringBuffer.append(this.getFontStyle(n2));
        stringBuffer.append("; ");
        return stringBuffer.toString();
    }

    private String getFontStyle(int n) {
        if (n > FONT_STYLES.length && n >= 0) {
            return FONT_STYLES[0];
        }
        return FONT_STYLES[n];
    }

    private String getScaledDimension(int n) {
        return "" + (double)n * this.scalar + this.units;
    }

    private String getColorAsCSS(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        float[] fArray = color.getColorComponents(null);
        for (int i = 0; i < fArray.length; ++i) {
            String string = Integer.toHexString((int)(255.0f * fArray[i])).toUpperCase();
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

