/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.output;

import ai.net.sourceforge.barbecue.output.AbstractOutput;
import ai.net.sourceforge.barbecue.output.LabelLayout;
import ai.net.sourceforge.barbecue.output.OutputException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;

public class GraphicsOutput
extends AbstractOutput {
    private final Graphics2D g;
    private Color savedColour;

    public GraphicsOutput(Graphics2D graphics2D, Font font, Color color, Color color2) {
        super(font, true, 1.0, color, color2);
        this.g = graphics2D;
    }

    public void beginDraw() {
        this.savedColour = this.g.getColor();
    }

    public void endDraw(int n, int n2) {
        this.g.setColor(this.savedColour);
    }

    public int drawBar(int n, int n2, int n3, int n4, boolean bl) {
        if (this.painting) {
            if (bl) {
                this.g.setColor(this.foregroundColour);
            } else {
                this.g.setColor(this.backgroundColour);
            }
            this.g.fillRect((int)(this.scalar * (double)n), (int)(this.scalar * (double)n2), (int)(this.scalar * (double)n3), (int)(this.scalar * (double)n4));
        }
        return n3;
    }

    public int drawText(String string, LabelLayout labelLayout) throws OutputException {
        if (this.font == null) {
            return 0;
        }
        TextLayout textLayout = new TextLayout(string, this.font, this.g.getFontRenderContext());
        labelLayout.setTextLayout(textLayout);
        if (this.painting) {
            this.g.setColor(this.backgroundColour);
            this.g.fillRect(labelLayout.getBackgroundX(), labelLayout.getBackgroundY(), labelLayout.getBackgroundWidth(), labelLayout.getBackgroundHeight());
            this.g.setColor(this.foregroundColour);
            textLayout.draw(this.g, labelLayout.getTextX(), labelLayout.getTextY());
        }
        return labelLayout.getBackgroundHeight();
    }

    public void paintBackground(int n, int n2, int n3, int n4) {
        if (!this.painting) {
            return;
        }
        this.g.setColor(this.backgroundColour);
        this.g.fillRect(n, n2, n3, n4);
    }
}

