/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.output;

import ai.net.sourceforge.barbecue.env.DefaultEnvironment;
import ai.net.sourceforge.barbecue.output.AbstractOutput;
import ai.net.sourceforge.barbecue.output.LabelLayout;
import ai.net.sourceforge.barbecue.output.OutputException;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class EPSOutput
extends AbstractOutput {
    private StringBuffer epsHeader;
    private StringBuffer epsBody;
    private final Writer writer;
    private boolean backgroundDrawing = false;

    public EPSOutput(Writer writer) {
        super(DefaultEnvironment.DEFAULT_FONT, true, 1.0, Color.black, Color.white);
        this.writer = new BufferedWriter(writer);
        this.epsBody = new StringBuffer();
        this.epsHeader = new StringBuffer();
        this.backgroundDrawing = false;
    }

    public void beginDraw() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDraw(int n, int n2) {
        this.epsHeader.setLength(0);
        this.epsHeader.append("%!PS-Adobe-2.0 EPSF-1.2\n");
        this.epsHeader.append("%%Creator: barbeque\n");
        this.epsHeader.append("%%BoundingBox: 0 0 ");
        this.epsHeader.append((int)this.getScaledDimension(n));
        this.epsHeader.append(" ");
        this.epsHeader.append((int)this.getScaledDimension(n2));
        this.epsHeader.append("\n");
        this.epsHeader.append("%%EndComments\n");
        this.epsHeader.append("% Printing barcode for \"");
        this.epsHeader.append("\", scaled  1.00\n");
        try {
            this.writer.write(this.epsHeader.toString());
            this.writer.write(this.epsBody.toString());
            this.writer.write("% End barcode\n");
        }
        catch (IOException iOException) {
            System.err.println("IO Exception writing EPS epilogue: " + iOException.toString());
        }
        finally {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException iOException) {
                System.err.println("IO Exception closing EPS stream: " + iOException.toString());
            }
        }
    }

    public int drawBar(int n, int n2, int n3, int n4, boolean bl) {
        return (int)this.drawBarEPS(n, n2, n3, n4, bl);
    }

    public double drawBarEPS(double d, double d2, double d3, double d4, boolean bl) {
        this.epsBody.append("%");
        this.epsBody.append("\t[");
        this.epsBody.append(this.getScaledDimension(d4));
        this.epsBody.append("  ");
        this.epsBody.append(this.getScaledDimension(d));
        this.epsBody.append("  ");
        this.epsBody.append(this.getScaledDimension(d2));
        this.epsBody.append("  ");
        this.epsBody.append(this.getScaledDimension(d3));
        this.epsBody.append("]\n");
        if (bl && !this.backgroundDrawing) {
            this.epsBody.append("newpath\n");
            this.epsBody.append(d);
            this.epsBody.append(" ");
            this.epsBody.append(d2);
            this.epsBody.append(" moveto\n");
            this.epsBody.append(0);
            this.epsBody.append(" ");
            this.epsBody.append(d4);
            this.epsBody.append(" rlineto\n");
            this.epsBody.append(d3);
            this.epsBody.append(" ");
            this.epsBody.append(0);
            this.epsBody.append(" rlineto\n");
            this.epsBody.append(0);
            this.epsBody.append(" ");
            this.epsBody.append(-d4);
            this.epsBody.append(" rlineto\n");
            this.epsBody.append("closepath\n");
            this.epsBody.append("fill\n\n");
        }
        return d3;
    }

    public int drawText(String string, LabelLayout labelLayout) throws OutputException {
        return 0;
    }

    public void toggleDrawingColor() {
        this.backgroundDrawing = !this.backgroundDrawing;
    }

    public void paintBackground(int n, int n2, int n3, int n4) {
    }

    private double getScaledDimension(double d) {
        return this.scalar * d;
    }
}

