/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.linear.twoOfFive;

import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.Modulo10;
import ai.net.sourceforge.barbecue.linear.LinearBarcode;
import ai.net.sourceforge.barbecue.linear.twoOfFive.Std2of5ModuleFactory;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class Std2of5Barcode
extends LinearBarcode {
    private String label;

    public Std2of5Barcode(String string) throws BarcodeException {
        this(string, false);
    }

    public Std2of5Barcode(String string, boolean bl) throws BarcodeException {
        super(bl ? string + Modulo10.getMod10CheckDigit(string, 3) : string);
        this.label = string;
        this.validateData();
    }

    public String getLabel() {
        return this.label;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i = 0; i < this.data.length(); ++i) {
            Module module = Std2of5ModuleFactory.getModule(String.valueOf(this.data.charAt(i)));
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        return null;
    }

    protected Module getPreAmble() {
        return Std2of5ModuleFactory.START_CHAR;
    }

    protected Module getPostAmble() {
        return Std2of5ModuleFactory.END_CHAR;
    }

    protected void validateData() throws BarcodeException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.data);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c)) {
                if (!Std2of5ModuleFactory.isValid(String.valueOf(c))) {
                    throw new BarcodeException(c + " is not a valid character for Standard 2 of 5 encoding");
                }
                stringBuffer.append(c);
            }
            ++n;
            c = stringCharacterIterator.next();
        }
        this.data = stringBuffer.toString();
    }
}

