/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.linear.twoOfFive;

import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.Modulo10;
import ai.net.sourceforge.barbecue.linear.twoOfFive.Int2of5ModuleFactory;
import ai.net.sourceforge.barbecue.linear.twoOfFive.Std2of5Barcode;
import java.util.ArrayList;

public class Int2of5Barcode
extends Std2of5Barcode {
    public Int2of5Barcode(String string) throws BarcodeException {
        this(string, false);
    }

    public Int2of5Barcode(String string, boolean bl) throws BarcodeException {
        super(bl ? string + Modulo10.getMod10CheckDigit(string, 3) : string);
    }

    protected Module getPreAmble() {
        return Int2of5ModuleFactory.START_CHAR;
    }

    protected Module getPostAmble() {
        return Int2of5ModuleFactory.END_CHAR;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i = 0; i < this.data.length() - 1; i += 2) {
            Module module = Int2of5ModuleFactory.getModule(String.valueOf(this.data.charAt(i)), String.valueOf(this.data.charAt(i + 1)));
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected void validateData() throws BarcodeException {
        if (this.data.length() % 2 != 0) {
            throw new BarcodeException("The Interleave 2 of 5 encoding requires an even number of data");
        }
        super.validateData();
    }
}

