/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.linear.ean;

import ai.net.sourceforge.barbecue.BlankModule;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.linear.upc.ModuleFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class EAN13ModuleFactory
extends ModuleFactory {
    protected static final List KEYS_LEFT_ODD = new ArrayList();
    protected static final List KEYS_LEFT_EVEN = new ArrayList();
    protected static final Map SET_LEFT_ODD = new HashMap();
    protected static final Map SET_LEFT_EVEN = new HashMap();
    protected static final Module RIGHT_MARGIN = new BlankModule(7);
    protected static final Map PARITY_TABLE = new HashMap();
    protected static final int ODD = 0;
    protected static final int EVEN = 1;
    public static final int LEFT_WIDTH = 7;
    public static final int GUARD_CHAR_SIZE = 0;

    protected EAN13ModuleFactory() {
    }

    protected static void initBaseSet() {
        EAN13ModuleFactory.initRightSet();
        EAN13ModuleFactory.initLeftOddSet();
        EAN13ModuleFactory.initLeftEvenSet();
        PARITY_TABLE.put("0", new int[]{0, 0, 0, 0, 0, 0});
        PARITY_TABLE.put("1", new int[]{0, 0, 1, 0, 1, 1});
        PARITY_TABLE.put("2", new int[]{0, 0, 1, 1, 0, 1});
        PARITY_TABLE.put("3", new int[]{0, 0, 1, 1, 1, 0});
        PARITY_TABLE.put("4", new int[]{0, 1, 0, 0, 1, 1});
        PARITY_TABLE.put("5", new int[]{0, 1, 1, 0, 0, 1});
        PARITY_TABLE.put("6", new int[]{0, 1, 1, 1, 0, 0});
        PARITY_TABLE.put("7", new int[]{0, 1, 0, 1, 0, 1});
        PARITY_TABLE.put("8", new int[]{0, 1, 0, 1, 1, 0});
        PARITY_TABLE.put("9", new int[]{0, 1, 1, 0, 1, 0});
    }

    protected static void initLeftOddSet() {
        KEYS_LEFT_ODD.add("0");
        SET_LEFT_ODD.put("0", new Module(new int[]{0, 3, 2, 1, 1}));
        KEYS_LEFT_ODD.add("1");
        SET_LEFT_ODD.put("1", new Module(new int[]{0, 2, 2, 2, 1}));
        KEYS_LEFT_ODD.add("2");
        SET_LEFT_ODD.put("2", new Module(new int[]{0, 2, 1, 2, 2}));
        KEYS_LEFT_ODD.add("3");
        SET_LEFT_ODD.put("3", new Module(new int[]{0, 1, 4, 1, 1}));
        KEYS_LEFT_ODD.add("4");
        SET_LEFT_ODD.put("4", new Module(new int[]{0, 1, 1, 3, 2}));
        KEYS_LEFT_ODD.add("5");
        SET_LEFT_ODD.put("5", new Module(new int[]{0, 1, 2, 3, 1}));
        KEYS_LEFT_ODD.add("6");
        SET_LEFT_ODD.put("6", new Module(new int[]{0, 1, 1, 1, 4}));
        KEYS_LEFT_ODD.add("7");
        SET_LEFT_ODD.put("7", new Module(new int[]{0, 1, 3, 1, 2}));
        KEYS_LEFT_ODD.add("8");
        SET_LEFT_ODD.put("8", new Module(new int[]{0, 1, 2, 1, 3}));
        KEYS_LEFT_ODD.add("9");
        SET_LEFT_ODD.put("9", new Module(new int[]{0, 3, 1, 1, 2}));
    }

    protected static void initLeftEvenSet() {
        KEYS_LEFT_EVEN.add("0");
        SET_LEFT_EVEN.put("0", new Module(new int[]{0, 1, 1, 2, 3}));
        KEYS_LEFT_EVEN.add("1");
        SET_LEFT_EVEN.put("1", new Module(new int[]{0, 1, 2, 2, 2}));
        KEYS_LEFT_EVEN.add("2");
        SET_LEFT_EVEN.put("2", new Module(new int[]{0, 2, 2, 1, 2}));
        KEYS_LEFT_EVEN.add("3");
        SET_LEFT_EVEN.put("3", new Module(new int[]{0, 1, 1, 4, 1}));
        KEYS_LEFT_EVEN.add("4");
        SET_LEFT_EVEN.put("4", new Module(new int[]{0, 2, 3, 1, 1}));
        KEYS_LEFT_EVEN.add("5");
        SET_LEFT_EVEN.put("5", new Module(new int[]{0, 1, 3, 2, 1}));
        KEYS_LEFT_EVEN.add("6");
        SET_LEFT_EVEN.put("6", new Module(new int[]{0, 4, 1, 1, 1}));
        KEYS_LEFT_EVEN.add("7");
        SET_LEFT_EVEN.put("7", new Module(new int[]{0, 2, 1, 3, 1}));
        KEYS_LEFT_EVEN.add("8");
        SET_LEFT_EVEN.put("8", new Module(new int[]{0, 3, 1, 2, 1}));
        KEYS_LEFT_EVEN.add("9");
        SET_LEFT_EVEN.put("9", new Module(new int[]{0, 2, 1, 1, 3}));
    }

    public static Module getModule(String string, String string2, int n) {
        int[] nArray;
        Module module = null;
        module = n + 1 > 7 ? (Module)SET_RIGHT.get(string2) : ((nArray = (int[])PARITY_TABLE.get(string))[n - 1] == 0 ? (Module)SET_LEFT_ODD.get(string2) : (Module)SET_LEFT_EVEN.get(string2));
        module.setSymbol(string2);
        return module;
    }

    public static boolean hasModule(String string) {
        if (KEYS_RIGHT.indexOf(string) > -1) {
            return true;
        }
        if (KEYS_LEFT_ODD.indexOf(string) > -1) {
            return true;
        }
        return KEYS_LEFT_EVEN.indexOf(string) > -1;
    }

    public static Module getModuleForIndex(String string, int n) {
        if (n + 1 > 7) {
            return EAN13ModuleFactory.getModule((String)KEYS_RIGHT.get(n), n);
        }
        int[] nArray = (int[])PARITY_TABLE.get(string);
        if (nArray[n - 1] == 0) {
            return EAN13ModuleFactory.getModule((String)KEYS_LEFT_ODD.get(n), n);
        }
        return EAN13ModuleFactory.getModule((String)KEYS_LEFT_EVEN.get(n), n);
    }

    public static boolean isValid(String string) {
        if (KEYS_RIGHT.indexOf(string) > -1) {
            return true;
        }
        if (KEYS_LEFT_ODD.indexOf(string) > -1) {
            return true;
        }
        return KEYS_LEFT_EVEN.indexOf(string) > -1;
    }

    static {
        EAN13ModuleFactory.initBaseSet();
    }
}

