/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.linear.code128;

import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.BlankModule;
import ai.net.sourceforge.barbecue.CompositeModule;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.linear.LinearBarcode;
import ai.net.sourceforge.barbecue.linear.code128.Accumulator;
import ai.net.sourceforge.barbecue.linear.code128.CharBuffer;
import ai.net.sourceforge.barbecue.linear.code128.CodeChangeModule;
import ai.net.sourceforge.barbecue.linear.code128.ModuleFactory;
import ai.net.sourceforge.barbecue.linear.code128.ShiftModule;
import java.util.ArrayList;
import java.util.List;

public class Code128Barcode
extends LinearBarcode {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int O = 3;
    public static final String SHIFT = "\u00c6";
    public static final String CHANGE_TO_A = "\u00c9";
    public static final String CHANGE_TO_B = "\u00c8";
    public static final String CHANGE_TO_C = "\u00c7";
    public static final String FNC_1 = "\u00ca";
    public static final Module START_A = new Module(new int[]{2, 1, 1, 4, 1, 2});
    public static final Module START_B = new Module(new int[]{2, 1, 1, 2, 1, 4});
    public static final Module START_C = new Module(new int[]{2, 1, 1, 2, 3, 2});
    protected static final Module STOP = new Module(new int[]{2, 3, 3, 1, 1, 1, 2});
    protected static final Module QUIET_SECTION = new BlankModule(10);
    private static final Module[] START = new Module[]{START_A, START_B, START_C};
    protected static final int[] START_INDICES = new int[]{103, 104, 105};
    protected static final int[] BUF_SIZES = new int[]{1, 1, 2};
    protected int startIndex;
    protected int mode;
    private int startingMode;
    private boolean shiftNext;
    private boolean shifted;
    private CharBuffer buf;
    private Module checkDigit;
    private boolean optimising;
    private Accumulator sum;
    private Accumulator index;

    public Code128Barcode(String string) throws BarcodeException {
        this(string, 3);
    }

    public Code128Barcode(String string, int n) throws BarcodeException {
        super(string);
        if (n == 3) {
            this.optimising = true;
            this.mode = 1;
        } else {
            this.optimising = false;
            this.mode = n;
        }
        this.startingMode = this.mode;
        this.shiftNext = false;
        this.shifted = false;
        this.startIndex = START_INDICES[this.mode];
    }

    public int getCharacterSet() {
        return this.startingMode;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.data;
    }

    protected double getSymbolWidth(int n) {
        double d = this.convertToMillimetres(this.barWidth, n);
        double d2 = 11.0;
        if (this.startingMode == 2) {
            d2 = 5.5;
        }
        return (d2 * (double)this.data.length() + 35.0) * d;
    }

    protected int calculateMinimumBarHeight(int n) {
        double d = (double)n * 0.25;
        return (int)Math.max(0.15 * this.getSymbolWidth(n), d);
    }

    public Module[] encodeData() {
        this.sum = new Accumulator(this.startIndex);
        ArrayList arrayList = new ArrayList();
        this.buf = new CharBuffer(BUF_SIZES[this.mode]);
        this.index = new Accumulator(1);
        this.padDataToEvenLength();
        for (int i = 0; i < this.data.length(); ++i) {
            char c = this.data.charAt(i);
            if (this.optimising && this.startingMode == 1) {
                if (i + 1 < this.data.length() && this.isControl(c) && this.mode != 0) {
                    if (this.mode == 1) {
                        this.encode(arrayList, SHIFT);
                    } else {
                        this.encode(arrayList, CHANGE_TO_A);
                    }
                } else if (i + 3 < this.data.length() && this.digitGroupIsNext(i, this.data) && this.mode != 2) {
                    this.encode(arrayList, CHANGE_TO_C);
                } else if (i + 1 <= this.data.length() && this.digitGroupEndIsNext(i, this.data) && this.mode == 2 && this.buf.size() != 1) {
                    this.encode(arrayList, CHANGE_TO_B);
                }
            }
            if (this.isShiftOrCode(c)) {
                this.encode(arrayList, String.valueOf(c));
                this.buf.clear();
                continue;
            }
            this.buf.addChar(c);
            if (!this.buf.isFull()) continue;
            this.encode(arrayList, this.buf.toString());
            this.buf.clear();
        }
        this.checkDigit = ModuleFactory.getModuleForIndex(this.sum.getValue() % 103, this.mode);
        this.mode = this.startingMode;
        return arrayList.toArray(new Module[0]);
    }

    private boolean isShiftOrCode(char c) {
        String string = String.valueOf(c);
        return string.equals(SHIFT) || string.equals(CHANGE_TO_A) || string.equals(CHANGE_TO_B) || string.equals(CHANGE_TO_C) || string.equals(FNC_1);
    }

    public Module calculateChecksum() {
        if (this.checkDigit == null) {
            this.encodeData();
        }
        return this.checkDigit;
    }

    protected Module getPreAmble() {
        CompositeModule compositeModule = new CompositeModule();
        if (this.drawingQuietSection) {
            compositeModule.add(QUIET_SECTION);
        }
        compositeModule.add(START[this.mode]);
        return compositeModule;
    }

    protected Module getPostAmble() {
        CompositeModule compositeModule = new CompositeModule();
        compositeModule.add(STOP);
        if (this.drawingQuietSection) {
            compositeModule.add(QUIET_SECTION);
        }
        return compositeModule;
    }

    private boolean isControl(char c) {
        return Character.isISOControl(c);
    }

    private boolean digitGroupIsNext(int n, String string) {
        char c = string.charAt(n);
        char c2 = string.charAt(n + 1);
        char c3 = string.charAt(n + 2);
        char c4 = string.charAt(n + 3);
        return Character.isDigit(c) && Character.isDigit(c2) && Character.isDigit(c3) && Character.isDigit(c4);
    }

    private boolean digitGroupEndIsNext(int n, String string) {
        if (n == string.length() - 1) {
            return true;
        }
        char c = string.charAt(n);
        char c2 = string.charAt(n + 1);
        return Character.isDigit(c) && !Character.isDigit(c2) || !Character.isDigit(c);
    }

    private void padDataToEvenLength() {
        if (this.startingMode == 2 && this.data.length() % 2 != 0 && !this.containsShiftOrChange(this.data)) {
            this.data = '0' + this.data;
        }
    }

    private boolean containsShiftOrChange(String string) {
        return string.indexOf(CHANGE_TO_A) >= 0 || string.indexOf(CHANGE_TO_B) >= 0 || string.indexOf(CHANGE_TO_C) >= 0 || string.indexOf(SHIFT) >= 0;
    }

    private void clearShift() {
        if (this.shifted) {
            this.shifted = false;
            this.shiftNext = false;
            this.mode = this.shiftMode();
        }
    }

    private void checkShift(Module module) {
        if (module instanceof ShiftModule) {
            this.mode = this.shiftMode();
            this.shiftNext = true;
        } else if (this.shiftNext) {
            this.shifted = true;
        }
    }

    private int shiftMode() {
        if (this.mode == 0) {
            return 1;
        }
        return 0;
    }

    private void checkCodeChange(Module module) {
        if (module instanceof CodeChangeModule) {
            this.mode = ((CodeChangeModule)module).getCode();
            this.buf = new CharBuffer(BUF_SIZES[this.mode]);
        }
    }

    private void encode(List list, String string) {
        Module module = ModuleFactory.getModule(string, this.mode);
        this.updateCheckSum(string);
        this.checkShift(module);
        this.checkCodeChange(module);
        list.add(module);
        this.clearShift();
    }

    private void updateCheckSum(String string) {
        int n = ModuleFactory.getIndex(string, this.mode);
        this.sum.add(n * this.index.getValue());
        this.index.increment();
    }

    private double convertToMillimetres(double d, int n) {
        double d2 = (double)n / 25.4;
        return d / d2;
    }
}

