/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.linear.codabar;

import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.BlankModule;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.SeparatorModule;
import ai.net.sourceforge.barbecue.linear.LinearBarcode;
import ai.net.sourceforge.barbecue.linear.codabar.ModuleFactory;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class CodabarBarcode
extends LinearBarcode {
    public static final String DEFAULT_START = "A";
    public static final String DEFAULT_STOP = "C";
    private String label;

    public CodabarBarcode(String string) throws BarcodeException {
        super(string);
        this.label = string;
        this.validateData();
    }

    public String getLabel() {
        return this.label;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i = 0; i < this.data.length(); ++i) {
            if (i > 0) {
                arrayList.add(new SeparatorModule(1));
            }
            char c = this.data.charAt(i);
            Module module = ModuleFactory.getModule(String.valueOf(c));
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        return null;
    }

    protected Module getPreAmble() {
        if (this.drawingQuietSection) {
            return new BlankModule(0);
        }
        return null;
    }

    protected Module getPostAmble() {
        if (this.drawingQuietSection) {
            return new BlankModule(0);
        }
        return null;
    }

    private void validateData() throws BarcodeException {
        this.replaceTraditionalStartStopWithModern();
        this.addDefaultStartStopIfRequired();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.data);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c)) {
                if (!ModuleFactory.isValid(String.valueOf(c))) {
                    throw new BarcodeException(c + " is not a valid character for Codabar encoding");
                }
                this.checkStartStop(c, n);
                stringBuffer.append(c);
            }
            ++n;
            c = stringCharacterIterator.next();
        }
        this.data = stringBuffer.toString();
    }

    private void addDefaultStartStopIfRequired() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter(this.data.charAt(0))) {
            stringBuffer.append(DEFAULT_START);
        }
        stringBuffer.append(this.data);
        if (!Character.isLetter(this.data.charAt(this.data.length() - 1))) {
            stringBuffer.append(DEFAULT_STOP);
        }
        this.data = stringBuffer.toString();
    }

    private void replaceTraditionalStartStopWithModern() {
        this.data = this.data.replace('a', 'A');
        this.data = this.data.replace('t', 'A');
        this.data = this.data.replace('b', 'B');
        this.data = this.data.replace('n', 'B');
        this.data = this.data.replace('c', 'C');
        this.data = this.data.replace('*', 'C');
        this.data = this.data.replace('d', 'D');
        this.data = this.data.replace('e', 'D');
    }

    private void checkStartStop(char c, int n) throws BarcodeException {
        if (Character.isLetter(c) && n > 0 && n < this.data.length() - 1) {
            throw new BarcodeException(c + " is only allowed as the first and last characters for Codabar barcodes");
        }
    }
}

