/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue;

import ai.net.sourceforge.barbecue.Barcode;
import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.linear.codabar.CodabarBarcode;
import ai.net.sourceforge.barbecue.linear.code128.Code128Barcode;
import ai.net.sourceforge.barbecue.linear.code39.Code39Barcode;
import ai.net.sourceforge.barbecue.linear.ean.BooklandBarcode;
import ai.net.sourceforge.barbecue.linear.ean.EAN13Barcode;
import ai.net.sourceforge.barbecue.linear.ean.UCCEAN128Barcode;
import ai.net.sourceforge.barbecue.linear.postnet.PostNetBarcode;
import ai.net.sourceforge.barbecue.linear.twoOfFive.Int2of5Barcode;
import ai.net.sourceforge.barbecue.linear.twoOfFive.Std2of5Barcode;
import ai.net.sourceforge.barbecue.linear.upc.UPCABarcode;
import ai.net.sourceforge.barbecue.twod.pdf417.PDF417Barcode;

public final class BarcodeFactory {
    private BarcodeFactory() {
    }

    public static Barcode createCode128(String string) throws BarcodeException {
        return new Code128Barcode(string, 3);
    }

    public static Barcode createCode128A(String string) throws BarcodeException {
        return new Code128Barcode(string, 0);
    }

    public static Barcode createCode128B(String string) throws BarcodeException {
        return new Code128Barcode(string, 1);
    }

    public static Barcode createCode128C(String string) throws BarcodeException {
        return new Code128Barcode(string, 2);
    }

    public static Barcode createUCC128(String string, String string2) throws BarcodeException {
        return new UCCEAN128Barcode(string, string2);
    }

    public static Barcode createEAN128(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static Barcode createUSPS(String string) throws BarcodeException {
        return new UCCEAN128Barcode("420", string);
    }

    public static Barcode createShipmentIdentificationNumber(String string) throws BarcodeException {
        return new UCCEAN128Barcode("402", string);
    }

    public static Barcode parseEAN128(String string) throws BarcodeException {
        return new UCCEAN128Barcode(string);
    }

    public static Barcode createSSCC18(String string) throws BarcodeException {
        return new UCCEAN128Barcode("00", string);
    }

    public static Barcode createSCC14ShippingCode(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static Barcode createGlobalTradeItemNumber(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static Barcode createEAN13(String string) throws BarcodeException {
        return new EAN13Barcode(string);
    }

    public static Barcode createBookland(String string) throws BarcodeException {
        return new BooklandBarcode(string);
    }

    public static Barcode createUPCA(String string) throws BarcodeException {
        return new UPCABarcode(string);
    }

    public static Barcode createRandomWeightUPCA(String string) throws BarcodeException {
        return new UPCABarcode(string, true);
    }

    public static Barcode createStd2of5(String string) throws BarcodeException {
        return new Std2of5Barcode(string);
    }

    public static Barcode createStd2of5(String string, boolean bl) throws BarcodeException {
        return new Std2of5Barcode(string, bl);
    }

    public static Barcode createInt2of5(String string) throws BarcodeException {
        return new Int2of5Barcode(string);
    }

    public static Barcode createInt2of5(String string, boolean bl) throws BarcodeException {
        return new Int2of5Barcode(string, bl);
    }

    public static Barcode createPDF417(String string) throws BarcodeException {
        return new PDF417Barcode(string);
    }

    public static Barcode createCode39(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static Barcode create3of9(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static Barcode createUSD3(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static Barcode createCodabar(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createUSD4(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createNW7(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createMonarch(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode create2of7(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createPostNet(String string) throws BarcodeException {
        return new PostNetBarcode(string);
    }
}

