/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.parser;

import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.format.CSSFormatable;
import ai.com.steadystate.css.parser.LocatableImpl;
import ai.org.w3c.css.sac.LexicalUnit;
import java.io.Serializable;

public class LexicalUnitImpl
extends LocatableImpl
implements LexicalUnit,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -7260032046960116891L;
    private short lexicalUnitType_;
    private LexicalUnit nextLexicalUnit_;
    private LexicalUnit previousLexicalUnit_;
    private float floatValue_;
    private String dimension_;
    private String functionName_;
    private LexicalUnit parameters_;
    private String stringValue_;
    private transient String toString_;

    public void setLexicalUnitType(short s) {
        this.lexicalUnitType_ = s;
        this.toString_ = null;
    }

    public void setNextLexicalUnit(LexicalUnit lexicalUnit) {
        this.nextLexicalUnit_ = lexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lexicalUnit) {
        this.previousLexicalUnit_ = lexicalUnit;
    }

    public void setFloatValue(float f) {
        this.floatValue_ = f;
        this.toString_ = null;
    }

    public String getDimension() {
        return this.dimension_;
    }

    public void setDimension(String string) {
        this.dimension_ = string;
        this.toString_ = null;
    }

    public void setFunctionName(String string) {
        this.functionName_ = string;
        this.toString_ = null;
    }

    public void setParameters(LexicalUnit lexicalUnit) {
        this.parameters_ = lexicalUnit;
        this.toString_ = null;
    }

    public void setStringValue(String string) {
        this.stringValue_ = string;
        this.toString_ = null;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s) {
        this();
        this.lexicalUnitType_ = s;
        this.previousLexicalUnit_ = lexicalUnit;
        if (this.previousLexicalUnit_ != null) {
            ((LexicalUnitImpl)this.previousLexicalUnit_).nextLexicalUnit_ = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, int n) {
        this(lexicalUnit, 13);
        this.floatValue_ = n;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, float f) {
        this(lexicalUnit, s);
        this.floatValue_ = f;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string, float f) {
        this(lexicalUnit, s);
        this.dimension_ = string;
        this.floatValue_ = f;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string) {
        this(lexicalUnit, s);
        this.stringValue_ = string;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string, LexicalUnit lexicalUnit2) {
        this(lexicalUnit, s);
        this.functionName_ = string;
        this.parameters_ = lexicalUnit2;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string, String string2) {
        this(lexicalUnit, s);
        this.functionName_ = string;
        this.stringValue_ = string2;
    }

    protected LexicalUnitImpl() {
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType_;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit_;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit_;
    }

    public int getIntegerValue() {
        return (int)this.floatValue_;
    }

    public float getFloatValue() {
        return this.floatValue_;
    }

    public String getDimensionUnitText() {
        switch (this.lexicalUnitType_) {
            case 15: {
                return "em";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 18: {
                return "in";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 23: {
                return "%";
            }
            case 28: {
                return "deg";
            }
            case 29: {
                return "grad";
            }
            case 30: {
                return "rad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this.dimension_;
            }
        }
        return "";
    }

    public String getFunctionName() {
        return this.functionName_;
    }

    public LexicalUnit getParameters() {
        return this.parameters_;
    }

    public String getStringValue() {
        return this.stringValue_;
    }

    public LexicalUnit getSubValues() {
        return this.parameters_;
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    public String getCssText(CSSFormat cSSFormat) {
        if (null != this.toString_) {
            return this.toString_;
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case 0: {
                stringBuilder.append(",");
                break;
            }
            case 1: {
                stringBuilder.append("+");
                break;
            }
            case 2: {
                stringBuilder.append("-");
                break;
            }
            case 3: {
                stringBuilder.append("*");
                break;
            }
            case 4: {
                stringBuilder.append("/");
                break;
            }
            case 5: {
                stringBuilder.append("%");
                break;
            }
            case 6: {
                stringBuilder.append("^");
                break;
            }
            case 7: {
                stringBuilder.append("<");
                break;
            }
            case 8: {
                stringBuilder.append(">");
                break;
            }
            case 9: {
                stringBuilder.append("<=");
                break;
            }
            case 10: {
                stringBuilder.append(">=");
                break;
            }
            case 11: {
                stringBuilder.append("~");
                break;
            }
            case 12: {
                stringBuilder.append("inherit");
                break;
            }
            case 13: {
                stringBuilder.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case 14: {
                stringBuilder.append(this.getTrimedFloatValue());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                stringBuilder.append(this.getTrimedFloatValue());
                String string = this.getDimensionUnitText();
                if (null == string) break;
                stringBuilder.append(string);
                break;
            }
            case 24: {
                stringBuilder.append("url(").append(this.getStringValue()).append(")");
                break;
            }
            case 25: {
                stringBuilder.append("counter(");
                this.appendParams(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case 26: {
                stringBuilder.append("counters(");
                this.appendParams(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case 27: {
                stringBuilder.append("rgb(");
                this.appendParams(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case 35: {
                stringBuilder.append(this.getStringValue());
                break;
            }
            case 36: {
                stringBuilder.append("\"");
                String string = this.getStringValue();
                string = string.replace("\n", "\\A ").replace("\r", "\\D ");
                stringBuilder.append(string);
                stringBuilder.append("\"");
                break;
            }
            case 37: {
                stringBuilder.append("attr(").append(this.getStringValue()).append(")");
                break;
            }
            case 38: {
                stringBuilder.append("rect(");
                this.appendParams(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case 39: {
                String string = this.getStringValue();
                if (null == string) break;
                stringBuilder.append(string);
                break;
            }
            case 40: {
                String string = this.getStringValue();
                if (null == string) break;
                stringBuilder.append(string);
                break;
            }
            case 41: {
                String string = this.getFunctionName();
                if (null != string) {
                    stringBuilder.append(string);
                }
                stringBuilder.append('(');
                this.appendParams(stringBuilder);
                stringBuilder.append(")");
                break;
            }
        }
        this.toString_ = stringBuilder.toString();
        return this.toString_;
    }

    public String toString() {
        return this.getCssText(null);
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case 0: {
                stringBuilder.append("SAC_OPERATOR_COMMA");
                break;
            }
            case 1: {
                stringBuilder.append("SAC_OPERATOR_PLUS");
                break;
            }
            case 2: {
                stringBuilder.append("SAC_OPERATOR_MINUS");
                break;
            }
            case 3: {
                stringBuilder.append("SAC_OPERATOR_MULTIPLY");
                break;
            }
            case 4: {
                stringBuilder.append("SAC_OPERATOR_SLASH");
                break;
            }
            case 5: {
                stringBuilder.append("SAC_OPERATOR_MOD");
                break;
            }
            case 6: {
                stringBuilder.append("SAC_OPERATOR_EXP");
                break;
            }
            case 7: {
                stringBuilder.append("SAC_OPERATOR_LT");
                break;
            }
            case 8: {
                stringBuilder.append("SAC_OPERATOR_GT");
                break;
            }
            case 9: {
                stringBuilder.append("SAC_OPERATOR_LE");
                break;
            }
            case 10: {
                stringBuilder.append("SAC_OPERATOR_GE");
                break;
            }
            case 11: {
                stringBuilder.append("SAC_OPERATOR_TILDE");
                break;
            }
            case 12: {
                stringBuilder.append("SAC_INHERIT");
                break;
            }
            case 13: {
                stringBuilder.append("SAC_INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case 14: {
                stringBuilder.append("SAC_REAL(").append(this.getTrimedFloatValue()).append(")");
                break;
            }
            case 15: {
                stringBuilder.append("SAC_EM(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 16: {
                stringBuilder.append("SAC_EX(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 17: {
                stringBuilder.append("SAC_PIXEL(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 18: {
                stringBuilder.append("SAC_INCH(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 19: {
                stringBuilder.append("SAC_CENTIMETER(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 20: {
                stringBuilder.append("SAC_MILLIMETER(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 21: {
                stringBuilder.append("SAC_POINT(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 22: {
                stringBuilder.append("SAC_PICA(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 23: {
                stringBuilder.append("SAC_PERCENTAGE(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 28: {
                stringBuilder.append("SAC_DEGREE(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 29: {
                stringBuilder.append("SAC_GRADIAN(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 30: {
                stringBuilder.append("SAC_RADIAN(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 31: {
                stringBuilder.append("SAC_MILLISECOND(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 32: {
                stringBuilder.append("SAC_SECOND(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 33: {
                stringBuilder.append("SAC_HERTZ(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 34: {
                stringBuilder.append("SAC_KILOHERTZ(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 42: {
                stringBuilder.append("SAC_DIMENSION(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 24: {
                stringBuilder.append("SAC_URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case 25: {
                stringBuilder.append("SAC_COUNTER_FUNCTION(counter(");
                this.appendParams(stringBuilder);
                stringBuilder.append("))");
                break;
            }
            case 26: {
                stringBuilder.append("SAC_COUNTERS_FUNCTION(counters(");
                this.appendParams(stringBuilder);
                stringBuilder.append("))");
                break;
            }
            case 27: {
                stringBuilder.append("SAC_RGBCOLOR(rgb(");
                this.appendParams(stringBuilder);
                stringBuilder.append("))");
                break;
            }
            case 35: {
                stringBuilder.append("SAC_IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case 36: {
                stringBuilder.append("SAC_STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case 37: {
                stringBuilder.append("SAC_ATTR(attr(").append(this.getStringValue()).append("))");
                break;
            }
            case 38: {
                stringBuilder.append("SAC_RECT_FUNCTION(rect(");
                this.appendParams(stringBuilder);
                stringBuilder.append("))");
                break;
            }
            case 39: {
                stringBuilder.append("SAC_UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case 40: {
                stringBuilder.append("SAC_SUB_EXPRESSION(").append(this.getStringValue()).append(")");
                break;
            }
            case 41: {
                stringBuilder.append("SAC_FUNCTION(").append(this.getFunctionName()).append("(");
                for (LexicalUnit lexicalUnit = this.parameters_; lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
                    stringBuilder.append(lexicalUnit.toString());
                }
                stringBuilder.append("))");
                break;
            }
        }
        return stringBuilder.toString();
    }

    private void appendParams(StringBuilder stringBuilder) {
        LexicalUnit lexicalUnit = this.parameters_;
        if (lexicalUnit != null) {
            stringBuilder.append(lexicalUnit.toString());
            for (lexicalUnit = lexicalUnit.getNextLexicalUnit(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
                if (lexicalUnit.getLexicalUnitType() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(lexicalUnit.toString());
            }
        }
    }

    private String getTrimedFloatValue() {
        int n;
        float f = this.getFloatValue();
        if (f - (float)(n = (int)f) == 0.0f) {
            return Integer.toString((int)f);
        }
        return Float.toString(f);
    }

    public static LexicalUnit createNumber(LexicalUnit lexicalUnit, int n) {
        return new LexicalUnitImpl(lexicalUnit, n);
    }

    public static LexicalUnit createNumber(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 14, f);
    }

    public static LexicalUnit createPercentage(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 23, f);
    }

    public static LexicalUnit createPixel(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 17, f);
    }

    public static LexicalUnit createCentimeter(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 19, f);
    }

    public static LexicalUnit createMillimeter(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 20, f);
    }

    public static LexicalUnit createInch(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 18, f);
    }

    public static LexicalUnit createPoint(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 21, f);
    }

    public static LexicalUnit createPica(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 22, f);
    }

    public static LexicalUnit createEm(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 15, f);
    }

    public static LexicalUnit createEx(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 16, f);
    }

    public static LexicalUnit createDegree(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 28, f);
    }

    public static LexicalUnit createRadian(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 30, f);
    }

    public static LexicalUnit createGradian(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 29, f);
    }

    public static LexicalUnit createMillisecond(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 31, f);
    }

    public static LexicalUnit createSecond(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 32, f);
    }

    public static LexicalUnit createHertz(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 33, f);
    }

    public static LexicalUnit createDimension(LexicalUnit lexicalUnit, float f, String string) {
        return new LexicalUnitImpl(lexicalUnit, 42, string, f);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 34, f);
    }

    public static LexicalUnit createCounter(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 25, "counter", lexicalUnit2);
    }

    public static LexicalUnit createCounters(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 26, "counters", lexicalUnit2);
    }

    public static LexicalUnit createAttr(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 37, "name", string);
    }

    public static LexicalUnit createRect(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 38, "rect", lexicalUnit2);
    }

    public static LexicalUnit createRgbColor(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 27, "rgb", lexicalUnit2);
    }

    public static LexicalUnit createFunction(LexicalUnit lexicalUnit, String string, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 41, string, lexicalUnit2);
    }

    public static LexicalUnit createString(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 36, string);
    }

    public static LexicalUnit createIdent(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 35, string);
    }

    public static LexicalUnit createURI(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 24, string);
    }

    public static LexicalUnit createComma(LexicalUnit lexicalUnit) {
        return new LexicalUnitImpl(lexicalUnit, 0);
    }
}

