/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.parser;

import ai.com.steadystate.css.dom.CSSCharsetRuleImpl;
import ai.com.steadystate.css.dom.CSSFontFaceRuleImpl;
import ai.com.steadystate.css.dom.CSSImportRuleImpl;
import ai.com.steadystate.css.dom.CSSMediaRuleImpl;
import ai.com.steadystate.css.dom.CSSOMObject;
import ai.com.steadystate.css.dom.CSSPageRuleImpl;
import ai.com.steadystate.css.dom.CSSRuleListImpl;
import ai.com.steadystate.css.dom.CSSStyleDeclarationImpl;
import ai.com.steadystate.css.dom.CSSStyleRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.CSSUnknownRuleImpl;
import ai.com.steadystate.css.dom.CSSValueImpl;
import ai.com.steadystate.css.dom.MediaListImpl;
import ai.com.steadystate.css.dom.Property;
import ai.com.steadystate.css.parser.AbstractSACParser;
import ai.com.steadystate.css.parser.HandlerBase;
import ai.com.steadystate.css.parser.SACParserCSS21;
import ai.com.steadystate.css.sac.DocumentHandlerExt;
import ai.com.steadystate.css.userdata.UserDataConstants;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.ErrorHandler;
import ai.org.w3c.css.sac.InputSource;
import ai.org.w3c.css.sac.LexicalUnit;
import ai.org.w3c.css.sac.Locator;
import ai.org.w3c.css.sac.Parser;
import ai.org.w3c.css.sac.SACMediaList;
import ai.org.w3c.css.sac.SelectorList;
import ai.org.w3c.css.sac.helpers.ParserFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSOMParser {
    private static final Object LOCK = new Object();
    private static final String DEFAULT_PARSER = "ai.com.steadystate.css.parser.SACParserCSS21";
    private static String LastFailed_;
    private Parser parser_;
    private CSSStyleSheetImpl parentStyleSheet_;

    public CSSOMParser() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSOMParser(Parser parser) {
        Object object = LOCK;
        synchronized (object) {
            if (null != parser) {
                System.setProperty("ai.org.w3c.css.sac.parser", parser.getClass().getCanonicalName());
                this.parser_ = parser;
                return;
            }
            String string = System.getProperty("ai.org.w3c.css.sac.parser");
            try {
                if (null != LastFailed_ && LastFailed_.equals(string)) {
                    this.parser_ = new SACParserCSS21();
                } else {
                    if (null == string) {
                        System.setProperty("ai.org.w3c.css.sac.parser", DEFAULT_PARSER);
                        string = DEFAULT_PARSER;
                    }
                    ParserFactory parserFactory = new ParserFactory();
                    this.parser_ = parserFactory.makeParser();
                }
            }
            catch (Exception exception) {
                Logger logger = Logger.getLogger("ai.com.steadystate.css");
                logger.warning(exception.toString());
                logger.warning("using the default 'SACParserCSS21' instead");
                logger.throwing("CSSOMParser", "consturctor", exception);
                LastFailed_ = string;
                this.parser_ = new SACParserCSS21();
            }
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser_.setErrorHandler(errorHandler);
    }

    public CSSStyleSheet parseStyleSheet(InputSource inputSource, Node node, String string) throws IOException {
        CSSOMHandler cSSOMHandler = new CSSOMHandler();
        cSSOMHandler.setOwnerNode(node);
        cSSOMHandler.setHref(string);
        this.parser_.setDocumentHandler(cSSOMHandler);
        this.parser_.parseStyleSheet(inputSource);
        Object object = cSSOMHandler.getRoot();
        if (object instanceof CSSStyleSheet) {
            return (CSSStyleSheet)object;
        }
        return null;
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource inputSource) throws IOException {
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(cSSStyleDeclarationImpl, inputSource);
        return cSSStyleDeclarationImpl;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration cSSStyleDeclaration, InputSource inputSource) throws IOException {
        Stack<Object> stack = new Stack<Object>();
        stack.push(cSSStyleDeclaration);
        CSSOMHandler cSSOMHandler = new CSSOMHandler(stack);
        this.parser_.setDocumentHandler(cSSOMHandler);
        this.parser_.parseStyleDeclaration(inputSource);
    }

    public CSSValue parsePropertyValue(InputSource inputSource) throws IOException {
        CSSOMHandler cSSOMHandler = new CSSOMHandler();
        this.parser_.setDocumentHandler(cSSOMHandler);
        LexicalUnit lexicalUnit = this.parser_.parsePropertyValue(inputSource);
        if (null == lexicalUnit) {
            return null;
        }
        return new CSSValueImpl(lexicalUnit);
    }

    public CSSRule parseRule(InputSource inputSource) throws IOException {
        CSSOMHandler cSSOMHandler = new CSSOMHandler();
        this.parser_.setDocumentHandler(cSSOMHandler);
        this.parser_.parseRule(inputSource);
        return (CSSRule)cSSOMHandler.getRoot();
    }

    public SelectorList parseSelectors(InputSource inputSource) throws IOException {
        HandlerBase handlerBase = new HandlerBase();
        this.parser_.setDocumentHandler(handlerBase);
        return this.parser_.parseSelectors(inputSource);
    }

    public SACMediaList parseMedia(InputSource inputSource) throws IOException {
        HandlerBase handlerBase = new HandlerBase();
        this.parser_.setDocumentHandler(handlerBase);
        if (this.parser_ instanceof AbstractSACParser) {
            return ((AbstractSACParser)this.parser_).parseMedia(inputSource);
        }
        return null;
    }

    public void setParentStyleSheet(CSSStyleSheetImpl cSSStyleSheetImpl) {
        this.parentStyleSheet_ = cSSStyleSheetImpl;
    }

    protected CSSStyleSheetImpl getParentStyleSheet() {
        return this.parentStyleSheet_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CSSOMHandler
    implements DocumentHandlerExt {
        private Stack<Object> nodeStack_;
        private Object root_;
        private Node ownerNode_;
        private String href_;

        private Node getOwnerNode() {
            return this.ownerNode_;
        }

        private void setOwnerNode(Node node) {
            this.ownerNode_ = node;
        }

        private String getHref() {
            return this.href_;
        }

        private void setHref(String string) {
            this.href_ = string;
        }

        CSSOMHandler(Stack<Object> stack) {
            this.nodeStack_ = stack;
        }

        CSSOMHandler() {
            this.nodeStack_ = new Stack();
        }

        Object getRoot() {
            return this.root_;
        }

        @Override
        public void startDocument(InputSource inputSource) throws CSSException {
            if (this.nodeStack_.empty()) {
                CSSStyleSheetImpl cSSStyleSheetImpl = new CSSStyleSheetImpl();
                CSSOMParser.this.setParentStyleSheet(cSSStyleSheetImpl);
                cSSStyleSheetImpl.setOwnerNode(this.getOwnerNode());
                cSSStyleSheetImpl.setBaseUri(inputSource.getURI());
                cSSStyleSheetImpl.setHref(this.getHref());
                cSSStyleSheetImpl.setMediaText(inputSource.getMedia());
                cSSStyleSheetImpl.setTitle(inputSource.getTitle());
                CSSRuleListImpl cSSRuleListImpl = new CSSRuleListImpl();
                cSSStyleSheetImpl.setCssRules(cSSRuleListImpl);
                this.nodeStack_.push(cSSStyleSheetImpl);
                this.nodeStack_.push(cSSRuleListImpl);
            }
        }

        @Override
        public void endDocument(InputSource inputSource) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void comment(String string) throws CSSException {
        }

        @Override
        public void ignorableAtRule(String string) throws CSSException {
            this.ignorableAtRule(string, null);
        }

        @Override
        public void ignorableAtRule(String string, Locator locator) throws CSSException {
            CSSUnknownRuleImpl cSSUnknownRuleImpl = new CSSUnknownRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), string);
            this.addLocator(locator, cSSUnknownRuleImpl);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cSSUnknownRuleImpl);
            } else {
                this.root_ = cSSUnknownRuleImpl;
            }
        }

        @Override
        public void namespaceDeclaration(String string, String string2) throws CSSException {
        }

        @Override
        public void charset(String string, Locator locator) throws CSSException {
            CSSCharsetRuleImpl cSSCharsetRuleImpl = new CSSCharsetRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), string);
            this.addLocator(locator, cSSCharsetRuleImpl);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cSSCharsetRuleImpl);
            } else {
                this.root_ = cSSCharsetRuleImpl;
            }
        }

        @Override
        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            this.importStyle(string, sACMediaList, string2, null);
        }

        @Override
        public void importStyle(String string, SACMediaList sACMediaList, String string2, Locator locator) throws CSSException {
            CSSImportRuleImpl cSSImportRuleImpl = new CSSImportRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), string, new MediaListImpl(sACMediaList));
            this.addLocator(locator, cSSImportRuleImpl);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cSSImportRuleImpl);
            } else {
                this.root_ = cSSImportRuleImpl;
            }
        }

        @Override
        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            this.startMedia(sACMediaList, null);
        }

        @Override
        public void startMedia(SACMediaList sACMediaList, Locator locator) throws CSSException {
            MediaListImpl mediaListImpl = new MediaListImpl(sACMediaList);
            CSSMediaRuleImpl cSSMediaRuleImpl = new CSSMediaRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), mediaListImpl);
            this.addLocator(locator, cSSMediaRuleImpl);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cSSMediaRuleImpl);
            }
            CSSRuleListImpl cSSRuleListImpl = new CSSRuleListImpl();
            cSSMediaRuleImpl.setRuleList(cSSRuleListImpl);
            this.nodeStack_.push(cSSMediaRuleImpl);
            this.nodeStack_.push(cSSRuleListImpl);
        }

        @Override
        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startPage(String string, String string2) throws CSSException {
            this.startPage(string, string2, null);
        }

        @Override
        public void startPage(String string, String string2, Locator locator) throws CSSException {
            CSSPageRuleImpl cSSPageRuleImpl = new CSSPageRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), string2);
            this.addLocator(locator, cSSPageRuleImpl);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cSSPageRuleImpl);
            }
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSPageRuleImpl);
            cSSPageRuleImpl.setStyle(cSSStyleDeclarationImpl);
            this.nodeStack_.push(cSSPageRuleImpl);
            this.nodeStack_.push(cSSStyleDeclarationImpl);
        }

        @Override
        public void endPage(String string, String string2) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startFontFace() throws CSSException {
            this.startFontFace(null);
        }

        @Override
        public void startFontFace(Locator locator) throws CSSException {
            CSSFontFaceRuleImpl cSSFontFaceRuleImpl = new CSSFontFaceRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule());
            this.addLocator(locator, cSSFontFaceRuleImpl);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cSSFontFaceRuleImpl);
            }
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSFontFaceRuleImpl);
            cSSFontFaceRuleImpl.setStyle(cSSStyleDeclarationImpl);
            this.nodeStack_.push(cSSFontFaceRuleImpl);
            this.nodeStack_.push(cSSStyleDeclarationImpl);
        }

        @Override
        public void endFontFace() throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startSelector(SelectorList selectorList) throws CSSException {
            this.startSelector(selectorList, null);
        }

        @Override
        public void startSelector(SelectorList selectorList, Locator locator) throws CSSException {
            Object object;
            CSSStyleRuleImpl cSSStyleRuleImpl = new CSSStyleRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), selectorList);
            this.addLocator(locator, cSSStyleRuleImpl);
            if (!this.nodeStack_.empty()) {
                object = this.nodeStack_.peek();
                ((CSSRuleListImpl)object).add(cSSStyleRuleImpl);
            }
            object = new CSSStyleDeclarationImpl(cSSStyleRuleImpl);
            cSSStyleRuleImpl.setStyle((CSSStyleDeclaration)object);
            this.nodeStack_.push(cSSStyleRuleImpl);
            this.nodeStack_.push(object);
        }

        @Override
        public void endSelector(SelectorList selectorList) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            this.property(string, lexicalUnit, bl, null);
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl, Locator locator) {
            block2: {
                CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)this.nodeStack_.peek();
                try {
                    Property property = new Property(string, new CSSValueImpl(lexicalUnit), bl);
                    this.addLocator(locator, property);
                    cSSStyleDeclarationImpl.addProperty(property);
                }
                catch (DOMException dOMException) {
                    if (!(CSSOMParser.this.parser_ instanceof AbstractSACParser)) break block2;
                    AbstractSACParser abstractSACParser = (AbstractSACParser)CSSOMParser.this.parser_;
                    abstractSACParser.getErrorHandler().error(abstractSACParser.toCSSParseException(dOMException));
                }
            }
        }

        private CSSRule getParentRule() {
            Object e;
            if (!this.nodeStack_.empty() && this.nodeStack_.size() > 1 && (e = this.nodeStack_.get(this.nodeStack_.size() - 2)) instanceof CSSRule) {
                return (CSSRule)e;
            }
            return null;
        }

        private void addLocator(Locator locator, CSSOMObject cSSOMObject) {
            if (locator == null) {
                Parser parser = CSSOMParser.this.parser_;
                try {
                    Method method = parser.getClass().getMethod("getLocator", null);
                    locator = (Locator)method.invoke((Object)parser, (Object[])null);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (locator != null) {
                cSSOMObject.setUserData(UserDataConstants.KEY_LOCATOR, locator);
            }
        }
    }
}

