/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.parser;

import ai.com.steadystate.css.parser.CharStream;
import ai.com.steadystate.css.parser.CssCharStream;
import ai.com.steadystate.css.parser.HandlerBase;
import ai.com.steadystate.css.parser.LexicalUnitImpl;
import ai.com.steadystate.css.parser.LocatorImpl;
import ai.com.steadystate.css.parser.ParseException;
import ai.com.steadystate.css.parser.SACMediaListImpl;
import ai.com.steadystate.css.parser.SACParser;
import ai.com.steadystate.css.parser.Token;
import ai.com.steadystate.css.parser.TokenMgrError;
import ai.com.steadystate.css.parser.selectors.ConditionFactoryImpl;
import ai.com.steadystate.css.parser.selectors.SelectorFactoryImpl;
import ai.com.steadystate.css.sac.DocumentHandlerExt;
import ai.org.w3c.css.sac.CSSParseException;
import ai.org.w3c.css.sac.ConditionFactory;
import ai.org.w3c.css.sac.DocumentHandler;
import ai.org.w3c.css.sac.ErrorHandler;
import ai.org.w3c.css.sac.InputSource;
import ai.org.w3c.css.sac.LexicalUnit;
import ai.org.w3c.css.sac.Locator;
import ai.org.w3c.css.sac.SACMediaList;
import ai.org.w3c.css.sac.Selector;
import ai.org.w3c.css.sac.SelectorFactory;
import ai.org.w3c.css.sac.SelectorList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.DOMException;

abstract class AbstractSACParser
implements SACParser {
    private DocumentHandler documentHandler_;
    private ErrorHandler errorHandler_;
    private InputSource source_;
    private Locale locale_;
    private SelectorFactory selectorFactory_;
    private ConditionFactory conditionFactory_;
    private ResourceBundle sacParserMessages_;
    private boolean ieStarHackAccepted_;
    private static final String NUM_CHARS = "0123456789.";

    AbstractSACParser() {
    }

    protected DocumentHandler getDocumentHandler() {
        if (this.documentHandler_ == null) {
            this.setDocumentHandler(new HandlerBase());
        }
        return this.documentHandler_;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler_ = documentHandler;
    }

    protected ErrorHandler getErrorHandler() {
        if (this.errorHandler_ == null) {
            this.setErrorHandler(new HandlerBase());
        }
        return this.errorHandler_;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    protected InputSource getInputSource() {
        return this.source_;
    }

    public void setIeStarHackAccepted(boolean bl) {
        this.ieStarHackAccepted_ = bl;
    }

    public boolean isIeStarHackAccepted() {
        return this.ieStarHackAccepted_;
    }

    public void setLocale(Locale locale) {
        if (this.locale_ != locale) {
            this.sacParserMessages_ = null;
        }
        this.locale_ = locale;
    }

    protected Locale getLocale() {
        if (this.locale_ == null) {
            this.setLocale(Locale.getDefault());
        }
        return this.locale_;
    }

    protected SelectorFactory getSelectorFactory() {
        if (this.selectorFactory_ == null) {
            this.selectorFactory_ = new SelectorFactoryImpl();
        }
        return this.selectorFactory_;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory_ = selectorFactory;
    }

    protected ConditionFactory getConditionFactory() {
        if (this.conditionFactory_ == null) {
            this.conditionFactory_ = new ConditionFactoryImpl();
        }
        return this.conditionFactory_;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory_ = conditionFactory;
    }

    protected ResourceBundle getSACParserMessages() {
        if (this.sacParserMessages_ == null) {
            try {
                this.sacParserMessages_ = ResourceBundle.getBundle("ai.com.steadystate.css.parser.SACParserMessages", this.getLocale());
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
        }
        return this.sacParserMessages_;
    }

    protected Locator createLocator(Token token) {
        return new LocatorImpl(this.getInputSource().getURI(), token == null ? 0 : token.beginLine, token == null ? 0 : token.beginColumn);
    }

    protected String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block11;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected CSSParseException toCSSParseException(String string, ParseException parseException) {
        String string2 = this.getSACParserMessages().getString("invalidExpectingOne");
        String string3 = this.getSACParserMessages().getString("invalidExpectingMore");
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parseException.expectedTokenSequences.length; ++i) {
            if (n < parseException.expectedTokenSequences[i].length) {
                n = parseException.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < parseException.expectedTokenSequences[i].length; ++j) {
                stringBuilder.append(parseException.tokenImage[parseException.expectedTokenSequences[i][j]]);
            }
            if (i >= parseException.expectedTokenSequences.length - 1) continue;
            stringBuilder.append(", ");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        Token token = parseException.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder2.append(" ");
            }
            if (token.kind == 0) {
                stringBuilder2.append(parseException.tokenImage[0]);
                break;
            }
            stringBuilder2.append(this.add_escapes(token.image));
            token = token.next;
        }
        String string4 = null;
        try {
            string4 = this.getSACParserMessages().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string4 = string;
        }
        StringBuilder stringBuilder3 = new StringBuilder(string4);
        stringBuilder3.append(" (");
        if (parseException.expectedTokenSequences.length == 1) {
            stringBuilder3.append(MessageFormat.format(string2, stringBuilder2, stringBuilder));
        } else {
            stringBuilder3.append(MessageFormat.format(string3, stringBuilder2, stringBuilder));
        }
        stringBuilder3.append(")");
        return new CSSParseException(stringBuilder3.toString(), this.getInputSource().getURI(), parseException.currentToken.next.beginLine, parseException.currentToken.next.beginColumn);
    }

    protected CSSParseException toCSSParseException(DOMException dOMException) {
        String string = this.getSACParserMessages().getString("domException");
        return new CSSParseException(MessageFormat.format(string, dOMException.getMessage()), this.getInputSource().getURI(), 1, 1);
    }

    protected CSSParseException toCSSParseException(TokenMgrError tokenMgrError) {
        String string = this.getSACParserMessages().getString("tokenMgrError");
        return new CSSParseException(string, this.getInputSource().getURI(), 1, 1);
    }

    protected CSSParseException toCSSParseException(String string, Object[] objectArray, Locator locator) {
        String string2 = this.getSACParserMessages().getString(string);
        return new CSSParseException(MessageFormat.format(string2, objectArray), locator);
    }

    protected CSSParseException createSkipWarning(String string, CSSParseException cSSParseException) {
        String string2 = null;
        try {
            string2 = this.getSACParserMessages().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return new CSSParseException(string2, cSSParseException.getURI(), cSSParseException.getLineNumber(), cSSParseException.getColumnNumber());
    }

    public void parseStyleSheet(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        try {
            this.styleSheet();
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidStyleSheet", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
    }

    public void parseStyleSheet(String string) throws IOException {
        this.parseStyleSheet(new InputSource(string));
    }

    public void parseStyleDeclaration(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        try {
            this.styleDeclaration();
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidStyleDeclaration", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
    }

    public void parseRule(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        try {
            this.styleSheetRuleSingle();
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidRule", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
    }

    public SelectorList parseSelectors(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        SelectorList selectorList = null;
        try {
            selectorList = this.parseSelectorsInternal();
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidSelectorList", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
        return selectorList;
    }

    public LexicalUnit parsePropertyValue(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        LexicalUnit lexicalUnit = null;
        try {
            lexicalUnit = this.expr();
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidExpr", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
        return lexicalUnit;
    }

    public boolean parsePriority(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        boolean bl = false;
        try {
            bl = this.prio();
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidPrio", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
        return bl;
    }

    public SACMediaList parseMedia(InputSource inputSource) throws IOException {
        this.source_ = inputSource;
        this.ReInit(this.getCharStream(inputSource));
        SACMediaListImpl sACMediaListImpl = new SACMediaListImpl();
        try {
            this.mediaList(sACMediaListImpl);
        }
        catch (ParseException parseException) {
            this.getErrorHandler().error(this.toCSSParseException("invalidMediaList", parseException));
        }
        catch (TokenMgrError tokenMgrError) {
            this.getErrorHandler().error(this.toCSSParseException(tokenMgrError));
        }
        catch (CSSParseException cSSParseException) {
            this.getErrorHandler().error(cSSParseException);
        }
        return sACMediaListImpl;
    }

    private CharStream getCharStream(InputSource inputSource) throws IOException {
        if (inputSource.getCharacterStream() != null) {
            return new CssCharStream(inputSource.getCharacterStream(), 1, 1);
        }
        if (inputSource.getByteStream() != null) {
            String string = inputSource.getEncoding();
            InputStreamReader inputStreamReader = string == null || string.length() < 1 ? new InputStreamReader(inputSource.getByteStream(), Charset.defaultCharset()) : new InputStreamReader(inputSource.getByteStream(), string);
            return new CssCharStream(inputStreamReader, 1, 1);
        }
        if (inputSource.getURI() != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(new URL(inputSource.getURI()).openStream());
            return new CssCharStream(inputStreamReader, 1, 1);
        }
        return null;
    }

    public abstract String getParserVersion();

    protected abstract String getGrammarUri();

    protected abstract void ReInit(CharStream var1);

    protected abstract void styleSheet() throws CSSParseException, ParseException;

    protected abstract void styleDeclaration() throws ParseException;

    protected abstract void styleSheetRuleSingle() throws ParseException;

    protected abstract SelectorList parseSelectorsInternal() throws ParseException;

    protected abstract SelectorList selectorList() throws ParseException;

    protected abstract LexicalUnit expr() throws ParseException;

    protected abstract boolean prio() throws ParseException;

    protected abstract void mediaList(SACMediaListImpl var1) throws ParseException;

    protected void handleStartDocument() {
        this.getDocumentHandler().startDocument(this.getInputSource());
    }

    protected void handleEndDocument() {
        this.getDocumentHandler().endDocument(this.getInputSource());
    }

    protected void handleIgnorableAtRule(String string, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).ignorableAtRule(string, locator);
        } else {
            documentHandler.ignorableAtRule(string);
        }
    }

    protected void handleCharset(String string, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).charset(string, locator);
        }
    }

    protected void handleImportStyle(String string, SACMediaList sACMediaList, String string2, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).importStyle(string, sACMediaList, string2, locator);
        } else {
            documentHandler.importStyle(string, sACMediaList, string2);
        }
    }

    protected void handleStartMedia(SACMediaList sACMediaList, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startMedia(sACMediaList, locator);
        } else {
            documentHandler.startMedia(sACMediaList);
        }
    }

    protected void handleMedium(String string, Locator locator) {
    }

    protected void handleEndMedia(SACMediaList sACMediaList) {
        this.getDocumentHandler().endMedia(sACMediaList);
    }

    protected void handleStartPage(String string, String string2, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startPage(string, string2, locator);
        } else {
            documentHandler.startPage(string, string2);
        }
    }

    protected void handleEndPage(String string, String string2) {
        this.getDocumentHandler().endPage(string, string2);
    }

    protected void handleStartFontFace(Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startFontFace(locator);
        } else {
            documentHandler.startFontFace();
        }
    }

    protected void handleEndFontFace() {
        this.getDocumentHandler().endFontFace();
    }

    protected void handleSelector(Selector selector) {
    }

    protected void handleStartSelector(SelectorList selectorList, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startSelector(selectorList, locator);
        } else {
            documentHandler.startSelector(selectorList);
        }
    }

    protected void handleEndSelector(SelectorList selectorList) {
        this.getDocumentHandler().endSelector(selectorList);
    }

    protected void handleProperty(String string, LexicalUnit lexicalUnit, boolean bl, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).property(string, lexicalUnit, bl, locator);
        } else {
            documentHandler.property(string, lexicalUnit, bl);
        }
    }

    protected LexicalUnit functionInternal(LexicalUnit lexicalUnit, String string, LexicalUnit lexicalUnit2) {
        if ("counter(".equalsIgnoreCase(string)) {
            return LexicalUnitImpl.createCounter(lexicalUnit, lexicalUnit2);
        }
        if ("counters(".equalsIgnoreCase(string)) {
            return LexicalUnitImpl.createCounters(lexicalUnit, lexicalUnit2);
        }
        if ("attr(".equalsIgnoreCase(string)) {
            return LexicalUnitImpl.createAttr(lexicalUnit, lexicalUnit2.getStringValue());
        }
        if ("rect(".equalsIgnoreCase(string)) {
            return LexicalUnitImpl.createRect(lexicalUnit, lexicalUnit2);
        }
        if ("rgb(".equalsIgnoreCase(string)) {
            return LexicalUnitImpl.createRgbColor(lexicalUnit, lexicalUnit2);
        }
        return LexicalUnitImpl.createFunction(lexicalUnit, string.substring(0, string.length() - 1), lexicalUnit2);
    }

    protected LexicalUnit hexcolorInternal(LexicalUnit lexicalUnit, Token token) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = token.image.length() - 1;
        try {
            if (n4 == 3) {
                n = Integer.parseInt(token.image.substring(1, 2), 16);
                n2 = Integer.parseInt(token.image.substring(2, 3), 16);
                n3 = Integer.parseInt(token.image.substring(3, 4), 16);
                n = n << 4 | n;
                n2 = n2 << 4 | n2;
                n3 = n3 << 4 | n3;
            } else if (n4 == 6) {
                n = Integer.parseInt(token.image.substring(1, 3), 16);
                n2 = Integer.parseInt(token.image.substring(3, 5), 16);
                n3 = Integer.parseInt(token.image.substring(5, 7), 16);
            } else {
                String string = this.getSACParserMessages().getString("invalidColor");
                throw new CSSParseException(MessageFormat.format(string, token), this.getInputSource().getURI(), token.beginLine, token.beginColumn);
            }
            LexicalUnit lexicalUnit2 = LexicalUnitImpl.createNumber(null, n);
            LexicalUnit lexicalUnit3 = LexicalUnitImpl.createComma(lexicalUnit2);
            LexicalUnit lexicalUnit4 = LexicalUnitImpl.createNumber(lexicalUnit3, n2);
            LexicalUnit lexicalUnit5 = LexicalUnitImpl.createComma(lexicalUnit4);
            LexicalUnitImpl.createNumber(lexicalUnit5, n3);
            return LexicalUnitImpl.createRgbColor(lexicalUnit, lexicalUnit2);
        }
        catch (NumberFormatException numberFormatException) {
            String string = this.getSACParserMessages().getString("invalidColor");
            throw new CSSParseException(MessageFormat.format(string, token), this.getInputSource().getURI(), token.beginLine, token.beginColumn, numberFormatException);
        }
    }

    int intValue(char c, String string) {
        int n = Integer.parseInt(string);
        if (c == '-') {
            return -1 * n;
        }
        return n;
    }

    float floatValue(char c, String string) {
        float f = Float.parseFloat(string);
        if (c == '-') {
            return -1.0f * f;
        }
        return f;
    }

    int getLastNumPos(String string) {
        int n;
        for (n = 0; n < string.length() && NUM_CHARS.indexOf(string.charAt(n)) >= 0; ++n) {
        }
        return n - 1;
    }

    public String unescape(String string, boolean bl) {
        int n;
        if (string == null) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n2 = -1;
        int n3 = string.length();
        --n3;
        if (bl) {
            while (n2 < n3) {
                if ((n = string.charAt(++n2)) != 92 && n != 34) continue;
                stringBuilder = new StringBuilder(n3);
                stringBuilder.append(string.substring(0, n2));
                --n2;
                break;
            }
        } else {
            while (n2 < n3) {
                if ('\\' != string.charAt(++n2)) continue;
                stringBuilder = new StringBuilder(n3);
                stringBuilder.append(string.substring(0, n2));
                --n2;
                break;
            }
        }
        if (null == stringBuilder) {
            return string;
        }
        n = -1;
        int n4 = 0;
        while (n2 < n3) {
            char c = string.charAt(++n2);
            if (n > -1) {
                int n5 = AbstractSACParser.hexval(c);
                if (n5 != -1) {
                    n = n * 16 + n5;
                    if (++n4 < 6) continue;
                    if (n > 65535 || n == 0) {
                        n = 65533;
                    }
                    stringBuilder.append((char)n);
                    n = -1;
                    continue;
                }
                if (n4 > 0) {
                    if (n > 65535 || n == 0) {
                        n = 65533;
                    }
                    stringBuilder.append((char)n);
                    if (c == ' ' || c == '\t') {
                        n = -1;
                        continue;
                    }
                }
                n = -1;
                if (n4 == 0 && c == '\\') {
                    stringBuilder.append('\\');
                    continue;
                }
                if (c == '\n' || c == '\f') continue;
                if (c == '\r') {
                    if (n2 >= n3 || string.charAt(n2 + 1) != '\n') continue;
                    ++n2;
                    continue;
                }
            }
            if (c == '\\') {
                n = 0;
                n4 = 0;
                continue;
            }
            if (c == '\"' && !bl) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        if (n > -1) {
            if (n4 == 0) {
                stringBuilder.append('\\');
            } else {
                if (n > 65535 || n == 0) {
                    n = 65533;
                }
                stringBuilder.append((char)n);
            }
        }
        return stringBuilder.toString();
    }

    private static int hexval(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }
}

