/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.CSSValueImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.format.CSSFormatable;
import ai.org.w3c.css.sac.LexicalUnit;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class RGBColorImpl
implements RGBColor,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = 8152675334081993160L;
    private CSSPrimitiveValue red_;
    private CSSPrimitiveValue green_;
    private CSSPrimitiveValue blue_;

    public RGBColorImpl(LexicalUnit lexicalUnit) throws DOMException {
        LexicalUnit lexicalUnit2 = lexicalUnit;
        this.red_ = new CSSValueImpl(lexicalUnit2, true);
        lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
        if (lexicalUnit2 != null) {
            if (lexicalUnit2.getLexicalUnitType() != 0) {
                throw new DOMException(12, "rgb parameters must be separated by ','.");
            }
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                this.green_ = new CSSValueImpl(lexicalUnit2, true);
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    if (lexicalUnit2.getLexicalUnitType() != 0) {
                        throw new DOMException(12, "rgb parameters must be separated by ','.");
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    this.blue_ = new CSSValueImpl(lexicalUnit2, true);
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                        throw new DOMException(12, "Too many parameters for rgb function.");
                    }
                }
            }
        }
    }

    public RGBColorImpl() {
    }

    public CSSPrimitiveValue getRed() {
        return this.red_;
    }

    public void setRed(CSSPrimitiveValue cSSPrimitiveValue) {
        this.red_ = cSSPrimitiveValue;
    }

    public CSSPrimitiveValue getGreen() {
        return this.green_;
    }

    public void setGreen(CSSPrimitiveValue cSSPrimitiveValue) {
        this.green_ = cSSPrimitiveValue;
    }

    public CSSPrimitiveValue getBlue() {
        return this.blue_;
    }

    public void setBlue(CSSPrimitiveValue cSSPrimitiveValue) {
        this.blue_ = cSSPrimitiveValue;
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    public String getCssText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != cSSFormat && cSSFormat.isRgbAsHex()) {
            stringBuilder.append("#").append(this.getColorAsHex(this.red_)).append(this.getColorAsHex(this.green_)).append(this.getColorAsHex(this.blue_));
            return stringBuilder.toString();
        }
        stringBuilder.append("rgb(").append(this.red_).append(", ").append(this.green_).append(", ").append(this.blue_).append(")");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getCssText(null);
    }

    private String getColorAsHex(CSSPrimitiveValue cSSPrimitiveValue) {
        return String.format("%02x", Math.round(cSSPrimitiveValue.getFloatValue((short)13)));
    }
}

