/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.CSSOMObjectImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.parser.Locatable;
import ai.com.steadystate.css.parser.SACMediaListImpl;
import ai.com.steadystate.css.parser.media.MediaQuery;
import ai.com.steadystate.css.userdata.UserDataConstants;
import ai.com.steadystate.css.util.LangUtils;
import ai.com.steadystate.css.util.ThrowCssExceptionErrorHandler;
import ai.org.w3c.css.sac.CSSParseException;
import ai.org.w3c.css.sac.InputSource;
import ai.org.w3c.css.sac.Locator;
import ai.org.w3c.css.sac.SACMediaList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaListImpl
extends CSSOMObjectImpl
implements MediaList {
    private static final long serialVersionUID = 6662784733573034870L;
    private List<MediaQuery> mediaQueries_ = new ArrayList<MediaQuery>(10);

    public MediaListImpl(SACMediaList sACMediaList) {
        this();
        Locator locator;
        this.setMediaList(sACMediaList);
        if (sACMediaList instanceof Locatable && (locator = ((Locatable)((Object)sACMediaList)).getLocator()) != null) {
            this.setUserData(UserDataConstants.KEY_LOCATOR, locator);
        }
    }

    public MediaListImpl() {
    }

    @Override
    public String getMediaText() {
        return this.getMediaText(null);
    }

    public String getMediaText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder("");
        boolean bl = false;
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            if (bl) {
                stringBuilder.append(", ");
            } else {
                bl = true;
            }
            stringBuilder.append(mediaQuery.getCssText(cSSFormat));
        }
        return stringBuilder.toString();
    }

    @Override
    public void setMediaText(String string) throws DOMException {
        InputSource inputSource = new InputSource(new StringReader(string));
        try {
            CSSOMParser cSSOMParser = new CSSOMParser();
            cSSOMParser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            SACMediaList sACMediaList = cSSOMParser.parseMedia(inputSource);
            this.setMediaList(sACMediaList);
        }
        catch (CSSParseException cSSParseException) {
            throw new DOMException(12, cSSParseException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new DOMException(8, iOException.getLocalizedMessage());
        }
    }

    @Override
    public int getLength() {
        return this.mediaQueries_.size();
    }

    @Override
    public String item(int n) {
        MediaQuery mediaQuery = this.mediaQuery(n);
        if (null == mediaQuery) {
            return null;
        }
        return mediaQuery.getMedia();
    }

    public MediaQuery mediaQuery(int n) {
        if (n < 0 || n >= this.mediaQueries_.size()) {
            return null;
        }
        return this.mediaQueries_.get(n);
    }

    @Override
    public void deleteMedium(String string) throws DOMException {
        for (MediaQuery mediaQuery : this.mediaQueries_) {
            String string2 = mediaQuery.getMedia();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.mediaQueries_.remove(mediaQuery);
            return;
        }
        throw new DOMExceptionImpl(8, 18);
    }

    @Override
    public void appendMedium(String string) throws DOMException {
        this.mediaQueries_.add(new MediaQuery(string));
    }

    public String toString() {
        return this.getMediaText(null);
    }

    public void setMedia(List<String> list) {
        this.mediaQueries_.clear();
        for (String string : list) {
            this.mediaQueries_.add(new MediaQuery(string));
        }
    }

    private void setMediaList(SACMediaList sACMediaList) {
        if (sACMediaList instanceof SACMediaListImpl) {
            SACMediaListImpl sACMediaListImpl = (SACMediaListImpl)sACMediaList;
            for (int i = 0; i < sACMediaList.getLength(); ++i) {
                this.mediaQueries_.add(sACMediaListImpl.mediaQuery(i));
            }
            return;
        }
        for (int i = 0; i < sACMediaList.getLength(); ++i) {
            this.mediaQueries_.add(new MediaQuery(sACMediaList.item(i)));
        }
    }

    private boolean equalsMedia(MediaList mediaList) {
        if (mediaList == null || this.getLength() != mediaList.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            String string;
            String string2 = this.item(i);
            if (LangUtils.equals(string2, string = mediaList.item(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaList)) {
            return false;
        }
        MediaList mediaList = (MediaList)object;
        return super.equals(object) && this.equalsMedia(mediaList);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.mediaQueries_);
        return n;
    }
}

