/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.dom.Property;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.format.CSSFormatable;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.InputSource;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -2373755821317100189L;
    private static final String PRIORITY_IMPORTANT = "important";
    private CSSRule parentRule_;
    private List<Property> properties_ = new ArrayList<Property>();

    public void setParentRule(CSSRule cSSRule) {
        this.parentRule_ = cSSRule;
    }

    public List<Property> getProperties() {
        return this.properties_;
    }

    public void setProperties(List<Property> list) {
        this.properties_ = list;
    }

    public CSSStyleDeclarationImpl(CSSRule cSSRule) {
        this.parentRule_ = cSSRule;
    }

    public CSSStyleDeclarationImpl() {
    }

    @Override
    public String getCssText() {
        return this.getCssText(null);
    }

    @Override
    public String getCssText(CSSFormat cSSFormat) {
        boolean bl = cSSFormat != null && cSSFormat.getPropertiesInSeparateLines();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property property = this.properties_.get(i);
            if (property != null) {
                if (bl) {
                    stringBuilder.append(cSSFormat.getNewLine());
                    stringBuilder.append(cSSFormat.getPropertiesIndent());
                }
                stringBuilder.append(property.getCssText(cSSFormat));
            }
            if (i < this.properties_.size() - 1) {
                stringBuilder.append(";");
                if (bl) continue;
                stringBuilder.append(' ');
                continue;
            }
            if (!bl) continue;
            stringBuilder.append(cSSFormat.getNewLine());
        }
        return stringBuilder.toString();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            this.properties_.clear();
            cSSOMParser.parseStyleDeclaration(this, inputSource);
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String string) {
        Property property = this.getPropertyDeclaration(string);
        if (property == null || property.getValue() == null) {
            return "";
        }
        return property.getValue().toString();
    }

    @Override
    public CSSValue getPropertyCSSValue(String string) {
        Property property = this.getPropertyDeclaration(string);
        return property == null ? null : property.getValue();
    }

    @Override
    public String removeProperty(String string) throws DOMException {
        if (null == string) {
            return "";
        }
        for (int i = 0; i < this.properties_.size(); ++i) {
            Property property = this.properties_.get(i);
            if (property == null || !string.equalsIgnoreCase(property.getName())) continue;
            this.properties_.remove(i);
            if (property.getValue() == null) {
                return "";
            }
            return property.getValue().toString();
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String string) {
        Property property = this.getPropertyDeclaration(string);
        if (property == null) {
            return "";
        }
        return property.isImportant() ? PRIORITY_IMPORTANT : "";
    }

    @Override
    public void setProperty(String string, String string2, String string3) throws DOMException {
        try {
            Object object;
            CSSValue cSSValue = null;
            if (!string2.isEmpty()) {
                object = new CSSOMParser();
                InputSource inputSource = new InputSource(new StringReader(string2));
                cSSValue = ((CSSOMParser)object).parsePropertyValue(inputSource);
            }
            object = this.getPropertyDeclaration(string);
            boolean bl = PRIORITY_IMPORTANT.equalsIgnoreCase(string3);
            if (object == null) {
                object = new Property(string, cSSValue, bl);
                this.addProperty((Property)object);
            } else {
                ((Property)object).setValue(cSSValue);
                ((Property)object).setImportant(bl);
            }
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.properties_.size();
    }

    @Override
    public String item(int n) {
        Property property = this.properties_.get(n);
        return property == null ? "" : property.getName();
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule_;
    }

    public void addProperty(Property property) {
        if (null == property) {
            return;
        }
        this.properties_.add(property);
    }

    public Property getPropertyDeclaration(String string) {
        if (null == string) {
            return null;
        }
        for (int i = this.properties_.size() - 1; i > -1; --i) {
            Property property = this.properties_.get(i);
            if (property == null || !string.equalsIgnoreCase(property.getName())) continue;
            return property;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSStyleDeclaration)) {
            return false;
        }
        CSSStyleDeclaration cSSStyleDeclaration = (CSSStyleDeclaration)object;
        return this.equalsProperties(cSSStyleDeclaration);
    }

    private boolean equalsProperties(CSSStyleDeclaration cSSStyleDeclaration) {
        if (cSSStyleDeclaration == null || this.getLength() != cSSStyleDeclaration.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            String string;
            String string2;
            String string3 = this.item(i);
            String string4 = this.getPropertyValue(string3);
            if (!LangUtils.equals(string4, string2 = cSSStyleDeclaration.getPropertyValue(string3))) {
                return false;
            }
            String string5 = this.getPropertyPriority(string3);
            if (LangUtils.equals(string5, string = cSSStyleDeclaration.getPropertyPriority(string3))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.properties_);
        return n;
    }
}

