/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleDeclarationImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPageRuleImpl
extends AbstractCSSRuleImpl
implements CSSPageRule {
    private static final long serialVersionUID = -6007519872104320812L;
    private String pseudoPage_;
    private CSSStyleDeclaration style_;

    public CSSPageRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string) {
        super(cSSStyleSheetImpl, cSSRule);
        this.pseudoPage_ = string;
    }

    public CSSPageRuleImpl() {
    }

    public short getType() {
        return 6;
    }

    public String getCssText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getSelectorText();
        stringBuilder.append("@page ").append(string);
        if (string.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("{");
        CSSStyleDeclaration cSSStyleDeclaration = this.getStyle();
        if (null != cSSStyleDeclaration) {
            stringBuilder.append(cSSStyleDeclaration.getCssText());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 6) {
                throw new DOMExceptionImpl(13, 9);
            }
            this.pseudoPage_ = ((CSSPageRuleImpl)cSSRule).pseudoPage_;
            this.style_ = ((CSSPageRuleImpl)cSSRule).style_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public String getSelectorText() {
        if (null == this.pseudoPage_) {
            return "";
        }
        return this.pseudoPage_;
    }

    public void setSelectorText(String string) throws DOMException {
    }

    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    public void setPseudoPage(String string) {
        this.pseudoPage_ = string;
    }

    public void setStyle(CSSStyleDeclarationImpl cSSStyleDeclarationImpl) {
        this.style_ = cSSStyleDeclarationImpl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSPageRule)) {
            return false;
        }
        CSSPageRule cSSPageRule = (CSSPageRule)object;
        return super.equals(object) && LangUtils.equals(this.getSelectorText(), cSSPageRule.getSelectorText()) && LangUtils.equals(this.getStyle(), cSSPageRule.getStyle());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.pseudoPage_);
        n = LangUtils.hashCode(n, this.style_);
        return n;
    }

    public String toString() {
        return this.getCssText(null);
    }
}

